/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.transport;

import com.liferay.util.transport.MulticastDatagramHandler;
import com.liferay.util.transport.MulticastTransport;
import java.util.HashMap;
import java.util.Map;

public class MulticastClientTool {
    public static void main(String[] args) {
        try {
            new MulticastClientTool(args);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            StringBuilder sb = new StringBuilder(4);
            sb.append("Usage: java -classpath util-java.jar ");
            sb.append(MulticastClientTool.class.getName());
            sb.append("[-g] [-s] -h [multicastAddress] -p [port] [-b]");
            sb.append("[bindAddress]");
            System.err.println(sb.toString());
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MulticastClientTool(String[] args) throws Exception {
        Map<String, Object> argsMap = this._getArgsMap(args);
        Integer port = (Integer)argsMap.get("port");
        String multicastAddress = (String)argsMap.get("multicastAddress");
        String bindAddress = (String)argsMap.get("bindAddress");
        Boolean gzipData = (Boolean)argsMap.get("gzip");
        Boolean shortData = (Boolean)argsMap.get("short");
        MulticastDatagramHandler datagramHandler = new MulticastDatagramHandler(gzipData, shortData);
        MulticastTransport multicastTransport = new MulticastTransport(datagramHandler, multicastAddress, port, bindAddress);
        if (shortData.booleanValue()) {
            System.out.println("Truncating to 96 bytes.");
        }
        System.out.println("Started up and waiting...");
        multicastTransport.connect();
        MulticastTransport multicastTransport2 = multicastTransport;
        synchronized (multicastTransport2) {
            multicastTransport.wait();
        }
    }

    private Map<String, Object> _getArgsMap(String[] args) throws Exception {
        HashMap<String, Object> argsMap = new HashMap<String, Object>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-g")) {
                argsMap.put("gzip", Boolean.TRUE);
                continue;
            }
            if (args[i].equals("-s")) {
                argsMap.put("short", Boolean.TRUE);
                continue;
            }
            if (args[i].equals("-h")) {
                argsMap.put("multicastAddress", args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equals("-p")) {
                argsMap.put("port", Integer.valueOf(args[i + 1]));
                ++i;
                continue;
            }
            if (!args[i].equals("-b")) continue;
            argsMap.put("bindAddress", args[i + 1]);
            ++i;
        }
        if (!argsMap.containsKey("gzip")) {
            argsMap.put("gzip", Boolean.FALSE);
        }
        if (!argsMap.containsKey("short")) {
            argsMap.put("short", Boolean.FALSE);
        }
        return argsMap;
    }
}

