/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.transport;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.util.transport.DatagramHandler;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.util.zip.GZIPInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MulticastDatagramHandler
implements DatagramHandler {
    private static final Log _log = LogFactory.getLog(MulticastDatagramHandler.class);
    private final boolean _gzipData;
    private final boolean _shortData;

    public MulticastDatagramHandler(boolean gzipData, boolean shortData) {
        this._gzipData = gzipData;
        this._shortData = shortData;
    }

    @Override
    public void errorReceived(Throwable t) {
        _log.error((Object)t, t);
    }

    @Override
    public void process(DatagramPacket packet) {
        byte[] bytes = packet.getData();
        if (this._gzipData) {
            try {
                bytes = this.getUnzippedBytes(bytes);
            }
            catch (Exception exception) {
                _log.error((Object)exception, (Throwable)exception);
            }
        }
        if (this._shortData) {
            byte[] temp = new byte[96];
            System.arraycopy(bytes, 0, temp, 0, 96);
            bytes = temp;
        }
        StringBundler sb = new StringBundler(4);
        sb.append("[");
        sb.append((Object)packet.getSocketAddress());
        sb.append("] ");
        sb.append(new String(bytes));
        if (_log.isInfoEnabled()) {
            _log.info((Object)sb.toString());
        }
    }

    protected byte[] getUnzippedBytes(byte[] bytes) throws Exception {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream(bytes.length);
        try (GZIPInputStream is = new GZIPInputStream((InputStream)new UnsyncByteArrayInputStream(bytes));){
            byte[] buffer = new byte[1500];
            int c = 0;
            while (c != -1) {
                c = ((InputStream)is).read(buffer, 0, 1500);
                if (c == -1) continue;
                unsyncByteArrayOutputStream.write(buffer, 0, c);
            }
        }
        unsyncByteArrayOutputStream.flush();
        unsyncByteArrayOutputStream.close();
        return unsyncByteArrayOutputStream.toByteArray();
    }
}

