/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.transport;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.util.transport.DatagramHandler;
import com.liferay.util.transport.Transport;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MulticastTransport
extends Thread
implements Transport {
    private static final Log _log = LogFactory.getLog(MulticastTransport.class);
    private InetAddress _address;
    private final String _bindAddress;
    private boolean _connected;
    private final DatagramHandler _handler;
    private final byte[] _inboundBuffer = new byte[4096];
    private final DatagramPacket _inboundPacket = new DatagramPacket(this._inboundBuffer, this._inboundBuffer.length);
    private final String _multicastAddress;
    private final byte[] _outboundBuffer = new byte[4096];
    private final DatagramPacket _outboundPacket = new DatagramPacket(this._outboundBuffer, this._outboundBuffer.length);
    private final int _port;
    private MulticastSocket _socket;

    @Deprecated
    public MulticastTransport(DatagramHandler handler, String multicastAddress, int port) {
        this(handler, multicastAddress, port, null);
    }

    public MulticastTransport(DatagramHandler handler, String multicastAddress, int port, String bindAddress) {
        super("MulticastListener-" + multicastAddress + port);
        this.setDaemon(true);
        this._handler = handler;
        this._multicastAddress = multicastAddress;
        this._port = port;
        this._bindAddress = bindAddress;
    }

    @Override
    public synchronized void connect() throws IOException {
        if (this._socket == null) {
            this._socket = new MulticastSocket(this._port);
        } else if (this._socket.isConnected() && this._socket.isBound()) {
            return;
        }
        this._address = InetAddress.getByName(this._multicastAddress);
        this._socket.joinGroup(this._address);
        if (Validator.isNotNull((String)this._bindAddress)) {
            this._socket.setNetworkInterface(NetworkInterface.getByInetAddress(InetAddress.getByName(this._bindAddress)));
        }
        this._connected = true;
        this.start();
    }

    @Override
    public synchronized void disconnect() {
        if (this._address != null) {
            try {
                this._socket.leaveGroup(this._address);
                this._address = null;
            }
            catch (IOException ioException) {
                _log.error((Object)"Unable to leave group", (Throwable)ioException);
            }
        }
        this._connected = false;
        this.interrupt();
        this._socket.close();
    }

    @Override
    public boolean isConnected() {
        return this._connected;
    }

    @Override
    public void run() {
        try {
            while (this._connected) {
                this._socket.receive(this._inboundPacket);
                this._handler.process(this._inboundPacket);
            }
        }
        catch (IOException ioException) {
            if (!this._connected) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Unable to disconnect", (Throwable)ioException);
                }
                return;
            }
            _log.error((Object)"Unable to process ", (Throwable)ioException);
            this._socket.disconnect();
            this._connected = false;
            this._handler.errorReceived(ioException);
        }
    }

    public synchronized void sendMessage(byte[] bytes) throws IOException {
        this._outboundPacket.setData(bytes);
        this._outboundPacket.setAddress(this._address);
        this._outboundPacket.setPort(this._port);
        this._socket.send(this._outboundPacket);
    }

    @Override
    public synchronized void sendMessage(String message) throws IOException {
        this.sendMessage(message.getBytes());
    }
}

