/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.transport;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.util.transport.DatagramHandler;
import com.liferay.util.transport.MulticastTransport;
import java.net.DatagramPacket;
import java.net.InetAddress;

public class MulticastServerTool {
    private static final Log _log = LogFactoryUtil.getLog(MulticastServerTool.class);

    public static void main(String[] args) {
        try {
            int port = GetterUtil.getInteger((String)args[1]);
            long interval = GetterUtil.getLong((String)args[2]);
            DatagramHandler handler = new DatagramHandler(){

                @Override
                public void errorReceived(Throwable t) {
                    t.printStackTrace();
                }

                @Override
                public void process(DatagramPacket packet) {
                    String s = new String(packet.getData(), 0, packet.getLength());
                    System.out.println(s);
                }
            };
            MulticastTransport transport = null;
            transport = args.length > 3 ? new MulticastTransport(handler, args[0], port, args[3]) : new MulticastTransport(handler, args[0], port);
            transport.connect();
            InetAddress inetAddress = InetAddress.getLocalHost();
            String msg = StringBundler.concat((Object[])new Object[]{inetAddress.getHostName(), ":", port, " heartbeat "});
            int i = 0;
            while (true) {
                transport.sendMessage(msg + i);
                ++i;
                Thread.sleep(interval);
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            System.err.println("Usage: java MulticastServerTool multicastAddress port interval bindAddress");
            System.exit(1);
            return;
        }
    }
}

