/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;

public class HTMLParser {
    private final List<String> _images = new ArrayList<String>();
    private final List<String> _links = new ArrayList<String>();

    public HTMLParser(Reader reader) throws IOException {
        DefaultParser defaultParser = new DefaultParser();
        HTMLEditorKit.Parser parser = defaultParser.getParser();
        parser.parse(reader, new HTMLCallback(), true);
    }

    public List<String> getImages() {
        return this._images;
    }

    public List<String> getLinks() {
        return this._links;
    }

    private class HTMLCallback
    extends HTMLEditorKit.ParserCallback {
        private HTMLCallback() {
        }

        @Override
        public void handleComment(char[] data, int pos) {
        }

        @Override
        public void handleEndTag(HTML.Tag tag, int pos) {
        }

        @Override
        public void handleError(String errorMsg, int pos) {
        }

        @Override
        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet attributes, int pos) {
            String src;
            if (tag.equals(HTML.Tag.A)) {
                String href = (String)attributes.getAttribute(HTML.Attribute.HREF);
                if (href != null) {
                    HTMLParser.this._links.add(href);
                }
            } else if (tag.equals(HTML.Tag.IMG) && (src = (String)attributes.getAttribute(HTML.Attribute.SRC)) != null) {
                HTMLParser.this._images.add(src);
            }
        }

        @Override
        public void handleStartTag(HTML.Tag tag, MutableAttributeSet attributes, int pos) {
            String src;
            if (tag.equals(HTML.Tag.A)) {
                String href = (String)attributes.getAttribute(HTML.Attribute.HREF);
                if (href != null) {
                    HTMLParser.this._links.add(href);
                }
            } else if (tag.equals(HTML.Tag.IMG) && (src = (String)attributes.getAttribute(HTML.Attribute.SRC)) != null) {
                HTMLParser.this._images.add(src);
            }
        }

        @Override
        public void handleText(char[] data, int pos) {
        }
    }

    private static class DefaultParser
    extends HTMLEditorKit {
        private DefaultParser() {
        }

        @Override
        public HTMLEditorKit.Parser getParser() {
            return super.getParser();
        }
    }
}

