/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.transport;

import com.liferay.util.transport.DatagramHandler;
import com.liferay.util.transport.Transport;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MulticastTransport
extends Thread
implements Transport {
    private static final Log _log = LogFactory.getLog(MulticastTransport.class);
    private InetAddress _address;
    private boolean _connected;
    private final DatagramHandler _handler;
    private final String _host;
    private final byte[] _inboundBuffer = new byte[4096];
    private final DatagramPacket _inboundPacket = new DatagramPacket(this._inboundBuffer, this._inboundBuffer.length);
    private final byte[] _outboundBuffer = new byte[4096];
    private final DatagramPacket _outboundPacket = new DatagramPacket(this._outboundBuffer, this._outboundBuffer.length);
    private final int _port;
    private MulticastSocket _socket;

    public MulticastTransport(DatagramHandler handler, String host, int port) {
        super("MulticastListener-" + host + port);
        this.setDaemon(true);
        this._handler = handler;
        this._host = host;
        this._port = port;
    }

    @Override
    public synchronized void connect() throws IOException {
        if (this._socket == null) {
            this._socket = new MulticastSocket(this._port);
        } else if (this._socket.isConnected() && this._socket.isBound()) {
            return;
        }
        this._address = InetAddress.getByName(this._host);
        this._socket.joinGroup(this._address);
        this._connected = true;
        this.start();
    }

    @Override
    public synchronized void disconnect() {
        if (this._address != null) {
            try {
                this._socket.leaveGroup(this._address);
                this._address = null;
            }
            catch (IOException ioe) {
                _log.error((Object)"Unable to leave group", (Throwable)ioe);
            }
        }
        this._connected = false;
        this.interrupt();
        this._socket.close();
    }

    @Override
    public boolean isConnected() {
        return this._connected;
    }

    @Override
    public void run() {
        try {
            while (this._connected) {
                this._socket.receive(this._inboundPacket);
                this._handler.process(this._inboundPacket);
            }
        }
        catch (IOException ioe) {
            if (!this._connected) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Unable to disconnect", (Throwable)ioe);
                }
                return;
            }
            _log.error((Object)"Unable to process ", (Throwable)ioe);
            this._socket.disconnect();
            this._connected = false;
            this._handler.errorReceived(ioe);
        }
    }

    public synchronized void sendMessage(byte[] bytes) throws IOException {
        this._outboundPacket.setData(bytes);
        this._outboundPacket.setAddress(this._address);
        this._outboundPacket.setPort(this._port);
        this._socket.send(this._outboundPacket);
    }

    @Override
    public synchronized void sendMessage(String message) throws IOException {
        this.sendMessage(message.getBytes());
    }
}

