/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.dao.orm;

import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.dao.orm.WildcardMode;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class CustomSQL {
    public static final String DB2_FUNCTION_IS_NOT_NULL = "CAST(? AS VARCHAR(32672)) IS NOT NULL";
    public static final String DB2_FUNCTION_IS_NULL = "CAST(? AS VARCHAR(32672)) IS NULL";
    public static final String INFORMIX_FUNCTION_IS_NOT_NULL = "NOT lportal.isnull(?)";
    public static final String INFORMIX_FUNCTION_IS_NULL = "lportal.isnull(?)";
    public static final String MYSQL_FUNCTION_IS_NOT_NULL = "IFNULL(?, '1') = '0'";
    public static final String MYSQL_FUNCTION_IS_NULL = "IFNULL(?, '1') = '1'";
    public static final String SYBASE_FUNCTION_IS_NOT_NULL = "CONVERT(VARCHAR,?) IS NOT NULL";
    public static final String SYBASE_FUNCTION_IS_NULL = "CONVERT(VARCHAR,?) IS NULL";
    private static final boolean _CUSTOM_SQL_AUTO_ESCAPE_WILDCARDS_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get((String)"custom.sql.auto.escape.wildcards.enabled"));
    private static final String _GROUP_BY_CLAUSE = " GROUP BY ";
    private static final String _ORDER_BY_CLAUSE = " ORDER BY ";
    private static final String _OWNER_USER_ID_AND_OR_CONNECTOR = "[$OWNER_USER_ID_AND_OR_CONNECTOR$]";
    private static final String _OWNER_USER_ID_CONDITION_DEFAULT = "userId = ?";
    private static final String _OWNER_USER_ID_KEYWORD = "[$OWNER_USER_ID$]";
    private static final String _STATUS_CONDITION_DEFAULT = "status = ?";
    private static final String _STATUS_CONDITION_EMPTY = "-1 = ?";
    private static final String _STATUS_CONDITION_INVERSE = "status != ?";
    private static final String _STATUS_KEYWORD = "[$STATUS$]";
    private static final Log _log = LogFactoryUtil.getLog(CustomSQL.class);
    private String _functionIsNotNull;
    private String _functionIsNull;
    private volatile Map<String, String> _sqlPool = Collections.emptyMap();
    private boolean _vendorDB2;
    private boolean _vendorHSQL;
    private boolean _vendorInformix;
    private boolean _vendorMySQL;
    private boolean _vendorOracle;
    private boolean _vendorPostgreSQL;
    private boolean _vendorSybase;

    public CustomSQL() throws SQLException {
        this.reloadCustomSQL();
    }

    public String appendCriteria(String sql, String criteria) {
        int pos;
        if (Validator.isNull((String)criteria)) {
            return sql;
        }
        if (!criteria.startsWith(" ")) {
            criteria = " ".concat(criteria);
        }
        if (!criteria.endsWith(" ")) {
            criteria = criteria.concat(" ");
        }
        if ((pos = sql.indexOf(_GROUP_BY_CLAUSE)) != -1) {
            return sql.substring(0, pos + 1).concat(criteria).concat(sql.substring(pos + 1));
        }
        pos = sql.indexOf(_ORDER_BY_CLAUSE);
        if (pos != -1) {
            return sql.substring(0, pos + 1).concat(criteria).concat(sql.substring(pos + 1));
        }
        return sql.concat(criteria);
    }

    public String get(String id) {
        return this._sqlPool.get(id);
    }

    public String get(String id, QueryDefinition<?> queryDefinition) {
        return this.get(id, queryDefinition, "");
    }

    public String get(String id, QueryDefinition<?> queryDefinition, String tableName) {
        String sql = this.get(id);
        if (!Validator.isBlank((String)tableName) && !tableName.endsWith(".")) {
            tableName = tableName.concat(".");
        }
        sql = queryDefinition.getStatus() == -1 ? sql.replace(_STATUS_KEYWORD, _STATUS_CONDITION_EMPTY) : (queryDefinition.isExcludeStatus() ? sql.replace(_STATUS_KEYWORD, tableName.concat(_STATUS_CONDITION_INVERSE)) : sql.replace(_STATUS_KEYWORD, tableName.concat(_STATUS_CONDITION_DEFAULT)));
        if (queryDefinition.getOwnerUserId() > 0L) {
            if (queryDefinition.isIncludeOwner()) {
                StringBundler sb = new StringBundler(7);
                sb.append("(");
                sb.append(tableName);
                sb.append(_OWNER_USER_ID_CONDITION_DEFAULT);
                sb.append(" AND ");
                sb.append(tableName);
                sb.append(_STATUS_CONDITION_INVERSE);
                sb.append(")");
                sql = sql.replace(_OWNER_USER_ID_KEYWORD, sb.toString());
                sql = sql.replace(_OWNER_USER_ID_AND_OR_CONNECTOR, " OR ");
            } else {
                sql = sql.replace(_OWNER_USER_ID_KEYWORD, tableName.concat(_OWNER_USER_ID_CONDITION_DEFAULT));
                sql = sql.replace(_OWNER_USER_ID_AND_OR_CONNECTOR, " AND ");
            }
        } else {
            sql = sql.replace(_OWNER_USER_ID_KEYWORD, "");
            sql = sql.replace(_OWNER_USER_ID_AND_OR_CONNECTOR, "");
        }
        return sql;
    }

    public boolean isVendorDB2() {
        return this._vendorDB2;
    }

    public boolean isVendorHSQL() {
        return this._vendorHSQL;
    }

    public boolean isVendorInformix() {
        return this._vendorInformix;
    }

    public boolean isVendorMySQL() {
        return this._vendorMySQL;
    }

    public boolean isVendorOracle() {
        return this._vendorOracle;
    }

    public boolean isVendorPostgreSQL() {
        return this._vendorPostgreSQL;
    }

    public boolean isVendorSybase() {
        return this._vendorSybase;
    }

    public String[] keywords(String keywords) {
        return this.keywords(keywords, true, WildcardMode.SURROUND);
    }

    public String[] keywords(String keywords, boolean lowerCase) {
        return this.keywords(keywords, lowerCase, WildcardMode.SURROUND);
    }

    public String[] keywords(String keywords, boolean lowerCase, WildcardMode wildcardMode) {
        if (Validator.isNull((String)keywords)) {
            return new String[]{null};
        }
        if (_CUSTOM_SQL_AUTO_ESCAPE_WILDCARDS_ENABLED) {
            keywords = this._escapeWildCards(keywords);
        }
        if (lowerCase) {
            keywords = StringUtil.toLowerCase((String)keywords);
        }
        keywords = keywords.trim();
        ArrayList<String> keywordsList = new ArrayList<String>();
        for (int i = 0; i < keywords.length(); ++i) {
            String keyword;
            int pos;
            char c = keywords.charAt(i);
            if (c == '\"') {
                pos = i + 1;
                if ((i = keywords.indexOf(34, pos)) == -1) {
                    i = keywords.length();
                }
                if (i <= pos) continue;
                keyword = keywords.substring(pos, i);
                keywordsList.add(this.insertWildcard(keyword, wildcardMode));
                continue;
            }
            while (Character.isWhitespace(c)) {
                c = keywords.charAt(++i);
            }
            pos = i;
            while (!Character.isWhitespace(c) && ++i != keywords.length()) {
                c = keywords.charAt(i);
            }
            keyword = keywords.substring(pos, i);
            keywordsList.add(this.insertWildcard(keyword, wildcardMode));
        }
        return keywordsList.toArray(new String[0]);
    }

    public String[] keywords(String keywords, WildcardMode wildcardMode) {
        return this.keywords(keywords, true, wildcardMode);
    }

    public String[] keywords(String[] keywordsArray) {
        return this.keywords(keywordsArray, true);
    }

    public String[] keywords(String[] keywordsArray, boolean lowerCase) {
        if (ArrayUtil.isEmpty((Object[])keywordsArray)) {
            return new String[]{null};
        }
        if (lowerCase) {
            for (int i = 0; i < keywordsArray.length; ++i) {
                keywordsArray[i] = StringUtil.lowerCase((String)keywordsArray[i]);
            }
        }
        return keywordsArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadCustomSQL() throws SQLException {
        PortalUtil.initCustomSQL();
        Connection con = DataAccess.getConnection();
        String functionIsNull = PortalUtil.getCustomSQLFunctionIsNull();
        String functionIsNotNull = PortalUtil.getCustomSQLFunctionIsNotNull();
        try {
            if (Validator.isNotNull((String)functionIsNull) && Validator.isNotNull((String)functionIsNotNull)) {
                this._functionIsNull = functionIsNull;
                this._functionIsNotNull = functionIsNotNull;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("functionIsNull is manually set to " + functionIsNull));
                    _log.debug((Object)("functionIsNotNull is manually set to " + functionIsNotNull));
                }
            } else if (con != null) {
                DatabaseMetaData metaData = con.getMetaData();
                String dbName = GetterUtil.getString((String)metaData.getDatabaseProductName());
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Database name " + dbName));
                }
                if (dbName.startsWith("DB2")) {
                    this._vendorDB2 = true;
                    this._functionIsNull = DB2_FUNCTION_IS_NULL;
                    this._functionIsNotNull = DB2_FUNCTION_IS_NOT_NULL;
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Detected DB2 with database name " + dbName));
                    }
                } else if (dbName.startsWith("HSQL")) {
                    this._vendorHSQL = true;
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Detected HSQL with database name " + dbName));
                    }
                } else if (dbName.startsWith("Informix")) {
                    this._vendorInformix = true;
                    this._functionIsNull = INFORMIX_FUNCTION_IS_NULL;
                    this._functionIsNotNull = INFORMIX_FUNCTION_IS_NOT_NULL;
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Detected Informix with database name " + dbName));
                    }
                } else if (dbName.startsWith("MySQL")) {
                    this._vendorMySQL = true;
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Detected MySQL with database name " + dbName));
                    }
                } else if (dbName.startsWith("Sybase") || dbName.equals("ASE")) {
                    this._vendorSybase = true;
                    this._functionIsNull = SYBASE_FUNCTION_IS_NULL;
                    this._functionIsNotNull = SYBASE_FUNCTION_IS_NOT_NULL;
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Detected Sybase with database name " + dbName));
                    }
                } else if (dbName.startsWith("Oracle")) {
                    this._vendorOracle = true;
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Detected Oracle with database name " + dbName));
                    }
                } else if (dbName.startsWith("PostgreSQL")) {
                    this._vendorPostgreSQL = true;
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Detected PostgreSQL with database name " + dbName));
                    }
                } else if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Unable to detect database with name " + dbName));
                }
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        finally {
            DataAccess.cleanUp((Connection)con);
        }
        try {
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            String[] configs = this.getConfigs();
            HashMap<String, String> sqlPool = new HashMap<String, String>();
            for (String config : configs) {
                this._read(classLoader, config, sqlPool);
            }
            this._sqlPool = sqlPool;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public String removeGroupBy(String sql) {
        int x = sql.indexOf(_GROUP_BY_CLAUSE);
        if (x != -1) {
            int y = sql.indexOf(_ORDER_BY_CLAUSE);
            sql = y == -1 ? sql.substring(0, x) : sql.substring(0, x) + sql.substring(y);
        }
        return sql;
    }

    public String removeOrderBy(String sql) {
        int pos = sql.indexOf(_ORDER_BY_CLAUSE);
        if (pos != -1) {
            sql = sql.substring(0, pos);
        }
        return sql;
    }

    public String replaceAndOperator(String sql, boolean andOperator) {
        String andOrConnector = "OR";
        String andOrNullCheck = "AND ? IS NOT NULL";
        if (andOperator) {
            andOrConnector = "AND";
            andOrNullCheck = "OR ? IS NULL";
        }
        sql = StringUtil.replace((String)sql, (String[])new String[]{"[$AND_OR_CONNECTOR$]", "[$AND_OR_NULL_CHECK$]"}, (String[])new String[]{andOrConnector, andOrNullCheck});
        if (this._vendorPostgreSQL) {
            sql = StringUtil.replace((String)sql, (String[])new String[]{"Date >= ? AND ? IS NOT NULL", "Date <= ? AND ? IS NOT NULL", "Date >= ? OR ? IS NULL", "Date <= ? OR ? IS NULL"}, (String[])new String[]{"Date >= ? AND CAST(? AS TIMESTAMP) IS NOT NULL", "Date <= ? AND CAST(? AS TIMESTAMP) IS NOT NULL", "Date >= ? OR CAST(? AS TIMESTAMP) IS NULL", "Date <= ? OR CAST(? AS TIMESTAMP) IS NULL"});
        }
        return this.replaceIsNull(sql);
    }

    public String replaceGroupBy(String sql, String groupBy) {
        if (groupBy == null) {
            return sql;
        }
        int x = sql.indexOf(_GROUP_BY_CLAUSE);
        if (x != -1) {
            int y = sql.indexOf(_ORDER_BY_CLAUSE);
            if (y == -1) {
                sql = sql.substring(0, x + _GROUP_BY_CLAUSE.length());
                sql = sql.concat(groupBy);
            } else {
                sql = sql.substring(0, x + _GROUP_BY_CLAUSE.length()).concat(groupBy).concat(sql.substring(y));
            }
        } else {
            int y = sql.indexOf(_ORDER_BY_CLAUSE);
            if (y == -1) {
                sql = sql.concat(_GROUP_BY_CLAUSE).concat(groupBy);
            } else {
                StringBundler sb = new StringBundler(4);
                sb.append(sql.substring(0, y));
                sb.append(_GROUP_BY_CLAUSE);
                sb.append(groupBy);
                sb.append(sql.substring(y));
                sql = sb.toString();
            }
        }
        return sql;
    }

    public String replaceIsNull(String sql) {
        if (Validator.isNotNull((String)this._functionIsNull)) {
            sql = StringUtil.replace((String)sql, (String[])new String[]{"? IS NULL", "? IS NOT NULL"}, (String[])new String[]{this._functionIsNull, this._functionIsNotNull});
        }
        return sql;
    }

    public String replaceKeywords(String sql, String field, boolean last, int[] values) {
        if (values != null && values.length == 1) {
            return sql;
        }
        StringBundler oldSqlSB = new StringBundler(4);
        oldSqlSB.append("(");
        oldSqlSB.append(field);
        oldSqlSB.append(" = ?)");
        if (!last) {
            oldSqlSB.append(" [$AND_OR_CONNECTOR$]");
        }
        if (ArrayUtil.isEmpty((int[])values)) {
            return StringUtil.replace((String)sql, (String)oldSqlSB.toString(), (String)"");
        }
        StringBundler newSqlSB = new StringBundler(values.length * 4 + 3);
        newSqlSB.append("(");
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                newSqlSB.append(" OR ");
            }
            newSqlSB.append("(");
            newSqlSB.append(field);
            newSqlSB.append(" = ?)");
        }
        newSqlSB.append(")");
        if (!last) {
            newSqlSB.append(" [$AND_OR_CONNECTOR$]");
        }
        return StringUtil.replace((String)sql, (String)oldSqlSB.toString(), (String)newSqlSB.toString());
    }

    public String replaceKeywords(String sql, String field, boolean last, long[] values) {
        if (values != null && values.length == 1) {
            return sql;
        }
        StringBundler oldSqlSB = new StringBundler(4);
        oldSqlSB.append("(");
        oldSqlSB.append(field);
        oldSqlSB.append(" = ?)");
        if (!last) {
            oldSqlSB.append(" [$AND_OR_CONNECTOR$]");
        }
        if (ArrayUtil.isEmpty((long[])values)) {
            return StringUtil.replace((String)sql, (String)oldSqlSB.toString(), (String)"");
        }
        StringBundler newSqlSB = new StringBundler(values.length * 4 + 3);
        newSqlSB.append("(");
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                newSqlSB.append(" OR ");
            }
            newSqlSB.append("(");
            newSqlSB.append(field);
            newSqlSB.append(" = ?)");
        }
        newSqlSB.append(")");
        if (!last) {
            newSqlSB.append(" [$AND_OR_CONNECTOR$]");
        }
        return StringUtil.replace((String)sql, (String)oldSqlSB.toString(), (String)newSqlSB.toString());
    }

    public String replaceKeywords(String sql, String field, String operator, boolean last, String[] values) {
        if (values != null && values.length <= 1) {
            return sql;
        }
        StringBundler oldSqlSB = new StringBundler(6);
        oldSqlSB.append("(");
        oldSqlSB.append(field);
        oldSqlSB.append(" ");
        oldSqlSB.append(operator);
        oldSqlSB.append(" ? [$AND_OR_NULL_CHECK$])");
        if (!last) {
            oldSqlSB.append(" [$AND_OR_CONNECTOR$]");
        }
        StringBundler newSqlSB = new StringBundler(values.length * 6 + 2);
        newSqlSB.append("(");
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                newSqlSB.append(" OR ");
            }
            newSqlSB.append("(");
            newSqlSB.append(field);
            newSqlSB.append(" ");
            newSqlSB.append(operator);
            newSqlSB.append(" ? [$AND_OR_NULL_CHECK$])");
        }
        newSqlSB.append(")");
        if (!last) {
            newSqlSB.append(" [$AND_OR_CONNECTOR$]");
        }
        return StringUtil.replace((String)sql, (String)oldSqlSB.toString(), (String)newSqlSB.toString());
    }

    public String replaceOrderBy(String sql, OrderByComparator<?> obc) {
        if (obc == null) {
            return sql;
        }
        String orderBy = obc.getOrderBy();
        int pos = sql.indexOf(_ORDER_BY_CLAUSE);
        if (pos != -1 && pos < sql.length()) {
            sql = sql.substring(0, pos + _ORDER_BY_CLAUSE.length());
            sql = sql.concat(orderBy);
        } else {
            sql = sql.concat(_ORDER_BY_CLAUSE).concat(orderBy);
        }
        return sql;
    }

    protected String[] getConfigs() {
        ClassLoader classLoader = CustomSQL.class.getClassLoader();
        if (PortalClassLoaderUtil.isPortalClassLoader((ClassLoader)classLoader)) {
            Properties propsUtil = PortalUtil.getPortalProperties();
            return StringUtil.split((String)propsUtil.getProperty("custom.sql.configs"));
        }
        if (classLoader.getResource("portlet.properties") != null) {
            Configuration configuration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)classLoader, (String)"portlet");
            return (String[])ArrayUtil.append((Object[])StringUtil.split((String)configuration.get("custom.sql.configs")), (Object[])new String[]{"custom-sql/default.xml", "META-INF/custom-sql/default.xml"});
        }
        return new String[]{"custom-sql/default.xml", "META-INF/custom-sql/default.xml"};
    }

    protected String insertWildcard(String keyword, WildcardMode wildcardMode) {
        if (wildcardMode == WildcardMode.LEADING) {
            return "%".concat(keyword);
        }
        if (wildcardMode == WildcardMode.SURROUND) {
            return StringUtil.quote((String)keyword, (String)"%");
        }
        if (wildcardMode == WildcardMode.TRAILING) {
            return keyword.concat("%");
        }
        throw new IllegalArgumentException("Invalid wildcard mode " + wildcardMode);
    }

    @Deprecated
    protected void read(ClassLoader classLoader, String source) {
    }

    protected String transform(String sql) {
        sql = PortalUtil.transformCustomSQL((String)sql);
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(sql));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if ((line = line.trim()).startsWith(")")) {
                    sb.setIndex(sb.index() - 1);
                }
                sb.append(line);
                if (line.endsWith("(")) continue;
                sb.append(" ");
            }
        }
        catch (IOException ioe) {
            return sql;
        }
        return sb.toString();
    }

    private String _escapeWildCards(String keywords) {
        if (!this.isVendorMySQL() && !this.isVendorOracle()) {
            return keywords;
        }
        StringBuilder sb = new StringBuilder(keywords);
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (c == '\\') {
                ++i;
                continue;
            }
            if (c != '_' && c != '%') continue;
            sb.insert(i, '\\');
            ++i;
        }
        return sb.toString();
    }

    private void _read(ClassLoader classLoader, String source, Map<String, String> sqlPool) throws Exception {
        try (InputStream is = classLoader.getResourceAsStream(source);){
            if (is == null) {
                return;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Loading " + source));
            }
            Document document = UnsecureSAXReaderUtil.read((InputStream)is);
            Element rootElement = document.getRootElement();
            for (Element sqlElement : rootElement.elements("sql")) {
                String file = sqlElement.attributeValue("file");
                if (Validator.isNotNull((String)file)) {
                    this._read(classLoader, file, sqlPool);
                    continue;
                }
                String id = sqlElement.attributeValue("id");
                String content = this.transform(sqlElement.getText());
                content = this.replaceIsNull(content);
                sqlPool.put(id, content);
            }
        }
    }
}

