/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.xml;

import com.liferay.util.xml.ElementComparator;
import com.liferay.util.xml.XMLElementComparator;
import com.liferay.util.xml.descriptor.XMLDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class XMLMerger {
    private final XMLDescriptor _descriptor;

    public XMLMerger(XMLDescriptor descriptor) {
        this._descriptor = descriptor;
    }

    public XMLElementComparator getElementComparator() {
        return new XMLElementComparator(this._descriptor);
    }

    public Document merge(Document masterDocument, Document slaveDocument) {
        Document mergedDocument = (Document)masterDocument.clone();
        Element mergedRootElement = mergedDocument.getRootElement();
        Element slaveRootElement = slaveDocument.getRootElement();
        for (Element slaveElement : slaveRootElement.elements()) {
            Element clonedSlaveElement = (Element)slaveElement.clone();
            clonedSlaveElement.detach();
            mergedRootElement.add(clonedSlaveElement);
        }
        this.organizeXML(mergedDocument);
        return mergedDocument;
    }

    public void organizeXML(Document document) {
        Element rootElement = document.getRootElement();
        this._orderChildren(rootElement, this._descriptor.getRootChildrenOrder());
        this._mergeDuplicateElements(rootElement, this.getElementComparator());
    }

    private void _addChildren(Element firstElement, Collection<Element> childElements) {
        List elements = firstElement.elements();
        for (Element childElement : childElements) {
            elements.add((Element)childElement.clone());
        }
        this._orderChildren(firstElement, this._descriptor.getChildrenOrder(firstElement));
    }

    private boolean _containsObjectEqualTo(Element element, List<Element> elements, ElementComparator elementComparator) {
        for (Element curElement : elements) {
            if (elementComparator.compare(element, curElement) != 0) continue;
            return true;
        }
        return false;
    }

    private Element _findObjectEqualTo(Element element, List<Element> elements, ElementComparator elementComparator) {
        for (Element curElement : elements) {
            if (elementComparator.compare(element, curElement) != 0) continue;
            return curElement;
        }
        return element;
    }

    private void _mergeDuplicateElements(Element element, ElementComparator elementComparator) {
        List childElements = element.elements();
        if (childElements.isEmpty()) {
            return;
        }
        ArrayList<Element> originalElements = new ArrayList<Element>();
        ArrayList<Element> duplicateElements = new ArrayList<Element>();
        for (Element childElement : childElements) {
            if (this._containsObjectEqualTo(childElement, originalElements, elementComparator)) {
                if (this._descriptor.canJoinChildren(childElement)) {
                    Element firstElement = this._findObjectEqualTo(childElement, originalElements, elementComparator);
                    this._addChildren(firstElement, childElement.elements());
                }
                duplicateElements.add(childElement);
            } else {
                originalElements.add(childElement);
            }
            this._orderChildren(childElement, this._descriptor.getChildrenOrder(childElement));
        }
        for (Element duplicateElement : duplicateElements) {
            duplicateElement.detach();
        }
        for (Element childElement : originalElements) {
            this._mergeDuplicateElements(childElement, elementComparator);
        }
    }

    private void _orderChildren(Element parentElement, String[] orderedChildrenNames) {
        if (orderedChildrenNames == null) {
            return;
        }
        ArrayList elements = new ArrayList();
        for (String orderedChildrenName : orderedChildrenNames) {
            elements.addAll(parentElement.elements(orderedChildrenName));
        }
        for (Element element : elements) {
            element.detach();
            parentElement.add(element);
        }
    }
}

