/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.ant;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.util.ant.AntUtil;
import com.liferay.util.ant.DeleteTask;
import com.liferay.util.xml.XMLSafeReader;
import java.io.File;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.axis.tools.ant.wsdl.Java2WsdlAntTask;
import org.apache.axis.tools.ant.wsdl.NamespaceMapping;
import org.apache.axis.tools.ant.wsdl.Wsdl2javaAntTask;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class Java2WsddTask {
    public static String[] generateWsdd(String className, String classPath, String serviceName) throws Exception {
        java.nio.file.Path tempDirPath = Files.createTempDirectory(Paths.get(SystemProperties.get((String)"java.io.tmpdir"), new String[0]), null, new FileAttribute[0]);
        File tempDir = tempDirPath.toFile();
        tempDir.mkdir();
        String wsdlFileName = tempDir + "/service.wsdl";
        int pos = className.lastIndexOf(".");
        String packagePath = className.substring(0, pos);
        String[] packagePaths = StringUtil.split((String)packagePath, (char)'.');
        String namespace = "urn:";
        for (int i = packagePaths.length - 1; i >= 0; --i) {
            namespace = namespace + packagePaths[i];
            if (i <= 0) continue;
            namespace = namespace + ".";
        }
        String location = "http://localhost/services/" + serviceName;
        String mappingPackage = packagePath.substring(0, packagePath.lastIndexOf(".")) + ".ws";
        Project project = AntUtil.getProject();
        Java2WsdlAntTask java2Wsdl = new Java2WsdlAntTask();
        NamespaceMapping mapping = new NamespaceMapping();
        mapping.setNamespace(namespace);
        mapping.setPackage(mappingPackage);
        java2Wsdl.setProject(project);
        java2Wsdl.setClassName(className);
        if (Validator.isNotNull((String)classPath)) {
            java2Wsdl.setClasspath(new Path(project, classPath));
        }
        java2Wsdl.setOutput(new File(wsdlFileName));
        java2Wsdl.setLocation(location);
        java2Wsdl.setNamespace(namespace);
        java2Wsdl.addMapping(mapping);
        java2Wsdl.execute();
        Wsdl2javaAntTask wsdl2Java = new Wsdl2javaAntTask();
        wsdl2Java.setProject(project);
        wsdl2Java.setURL(wsdlFileName);
        wsdl2Java.setOutput(tempDir);
        wsdl2Java.setServerSide(true);
        wsdl2Java.setTestCase(false);
        wsdl2Java.setVerbose(false);
        wsdl2Java.execute();
        String packagePathWithSlashes = StringUtil.replace((String)packagePath, (char)'.', (char)'/');
        File deployFile = new File(StringBundler.concat((String[])new String[]{String.valueOf(tempDir), "/", packagePathWithSlashes, "/deploy.wsdd"}));
        String deployContent = new String(Files.readAllBytes(deployFile.toPath()));
        deployContent = StringUtil.replace((String)deployContent, (String)StringBundler.concat((String[])new String[]{packagePath, ".", serviceName, "SoapBindingImpl"}), (String)className);
        deployContent = Java2WsddTask._format(deployContent);
        File undeployFile = new File(StringBundler.concat((String[])new String[]{String.valueOf(tempDir), "/", packagePathWithSlashes, "/undeploy.wsdd"}));
        String undeployContent = new String(Files.readAllBytes(undeployFile.toPath()));
        undeployContent = Java2WsddTask._format(undeployContent);
        DeleteTask.deleteDirectory(tempDir);
        return new String[]{deployContent, undeployContent};
    }

    private static void _addElements(Element element, Map<String, Element> elements) {
        for (Map.Entry<String, Element> entry : elements.entrySet()) {
            Element childElement = entry.getValue();
            element.add(childElement);
        }
    }

    private static String _format(String content) throws Exception {
        content = Java2WsddTask._stripComments(content);
        SAXReader saxReader = new SAXReader();
        Document document = saxReader.read((Reader)((Object)new XMLSafeReader(content)));
        Element rootElement = document.getRootElement();
        Element serviceElement = rootElement.element("service");
        TreeMap<String, Element> arrayMappingElements = new TreeMap<String, Element>();
        TreeMap<String, Element> typeMappingElements = new TreeMap<String, Element>();
        TreeMap<String, Element> operationElements = new TreeMap<String, Element>();
        TreeMap<String, Element> parameterElements = new TreeMap<String, Element>();
        List elements = serviceElement.elements();
        for (Element element : elements) {
            String elementName = element.getName();
            if (elementName.equals("arrayMapping")) {
                element.detach();
                arrayMappingElements.put(Java2WsddTask._formattedString((Node)element), element);
                continue;
            }
            if (elementName.equals("operation")) {
                element.detach();
                List parameters = element.elements("parameter");
                StringBundler sb = new StringBundler(2 * parameters.size() + 2);
                String name = element.attributeValue("name");
                sb.append(name);
                sb.append("_METHOD_");
                for (Element parameterElement : parameters) {
                    String type = parameterElement.attributeValue("type");
                    sb.append(type);
                    sb.append("_PARAMETER_");
                }
                operationElements.put(sb.toString(), element);
                continue;
            }
            if (elementName.equals("parameter")) {
                Object[] values;
                Attribute valueAttribute;
                element.detach();
                String name = element.attributeValue("name");
                if (name.equals("allowedMethods")) {
                    valueAttribute = element.attribute("value");
                    values = StringUtil.split((String)valueAttribute.getValue(), (char)' ');
                    Arrays.sort(values);
                    valueAttribute.setValue(StringUtil.merge((Object[])values, (String)" "));
                } else if (name.equals("schemaUnqualified")) {
                    valueAttribute = element.attribute("value");
                    values = StringUtil.split((String)valueAttribute.getValue());
                    Arrays.sort(values);
                    valueAttribute.setValue(StringUtil.merge((Object[])values));
                }
                parameterElements.put(name, element);
                continue;
            }
            if (!elementName.equals("typeMapping")) continue;
            element.detach();
            typeMappingElements.put(Java2WsddTask._formattedString((Node)element), element);
        }
        Java2WsddTask._addElements(serviceElement, arrayMappingElements);
        Java2WsddTask._addElements(serviceElement, typeMappingElements);
        Java2WsddTask._addElements(serviceElement, operationElements);
        Java2WsddTask._addElements(serviceElement, parameterElements);
        content = StringUtil.replace((String)Java2WsddTask._formattedString((Node)document), (String)"\"/>", (String)"\" />");
        return content;
    }

    private static String _formattedString(Node node) throws Exception {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        OutputFormat outputFormat = OutputFormat.createPrettyPrint();
        outputFormat.setExpandEmptyElements(false);
        outputFormat.setIndent("\t");
        outputFormat.setLineSeparator("\n");
        outputFormat.setTrimText(true);
        XMLWriter xmlWriter = new XMLWriter((OutputStream)unsyncByteArrayOutputStream, outputFormat);
        xmlWriter.write(node);
        String content = unsyncByteArrayOutputStream.toString("UTF-8");
        if (content.endsWith("\n\n")) {
            content = content.substring(0, content.length() - 2);
        }
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        while (content.contains(" \n")) {
            content = StringUtil.replace((String)content, (String)" \n", (String)"\n");
        }
        if (content.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>")) {
            content = StringUtil.replaceFirst((String)content, (String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>", (String)"<?xml version=\"1.0\"?>");
        }
        return content;
    }

    private static String _stripComments(String text) {
        return StringUtil.stripBetween((String)text, (String)"<!--", (String)"-->");
    }
}

