/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.xml;

import com.liferay.util.xml.AttributeComparator;
import java.util.Comparator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class ElementComparator
implements Comparator<Element> {
    @Override
    public int compare(Element el1, Element el2) {
        String el2Text;
        String el2Name;
        String el1Name = el1.getName();
        if (!el1Name.equals(el2Name = el2.getName())) {
            return el1Name.compareTo(el2Name);
        }
        String el1Text = el1.getTextTrim();
        if (!el1Text.equals(el2Text = el2.getTextTrim())) {
            return el1Text.compareTo(el2Text);
        }
        List el1Attributes = el1.attributes();
        List el2Attributes = el2.attributes();
        if (el1Attributes.size() < el2Attributes.size()) {
            return -1;
        }
        if (el1Attributes.size() > el2Attributes.size()) {
            return 1;
        }
        for (Attribute attr : el1Attributes) {
            int value = this._compare(el2Attributes, attr, new AttributeComparator());
            if (value == 0) continue;
            return value;
        }
        List el1Elements = el1.elements();
        List el2Elements = el2.elements();
        if (el1Elements.size() < el2Elements.size()) {
            return -1;
        }
        if (el1Elements.size() > el2Elements.size()) {
            return 1;
        }
        for (Element el : el1Elements) {
            int value = this._compare(el2Elements, el, new ElementComparator());
            if (value == 0) continue;
            return value;
        }
        return 0;
    }

    private int _compare(List<Attribute> list, Attribute object, Comparator<Attribute> comparator) {
        int firstValue = -1;
        for (int i = 0; i < list.size(); ++i) {
            Attribute o = list.get(i);
            int value = comparator.compare(object, o);
            if (i == 0) {
                firstValue = value;
            }
            if (value != 0) continue;
            return 0;
        }
        return firstValue;
    }

    private int _compare(List<Element> list, Element object, Comparator<Element> comparator) {
        int firstValue = -1;
        for (int i = 0; i < list.size(); ++i) {
            Element o = list.get(i);
            int value = comparator.compare(object, o);
            if (i == 0) {
                firstValue = value;
            }
            if (value != 0) continue;
            return 0;
        }
        return firstValue;
    }
}

