/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.servlet;

import com.liferay.petra.encryptor.Encryptor;
import com.liferay.petra.encryptor.EncryptorException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Validator;
import java.security.Key;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class EncryptedServletRequest
extends HttpServletRequestWrapper {
    private final Key _key;
    private final Map<String, String[]> _params;

    public EncryptedServletRequest(HttpServletRequest request, Key key) {
        super(request);
        this._key = key;
        this._params = new HashMap<String, String[]>();
        Map parameters = request.getParameterMap();
        for (Map.Entry entry : parameters.entrySet()) {
            String name = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            for (int i = 0; i < values.length; ++i) {
                if (!Validator.isNotNull((String)values[i])) continue;
                try {
                    values[i] = Encryptor.decrypt((Key)this._key, (String)values[i]);
                    continue;
                }
                catch (EncryptorException ee) {
                    values[i] = "";
                }
            }
            this._params.put(name, values);
        }
    }

    public String getParameter(String name) {
        Object[] values = this._params.get(name);
        if (ArrayUtil.isNotEmpty((Object[])values)) {
            return values[0];
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this._params);
    }

    public String[] getParameterValues(String name) {
        return this._params.get(name);
    }
}

