/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.xml;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.xml.Element;
import java.lang.reflect.Method;
import java.util.List;

public class BeanToXMLUtil {
    private static final Log _log = LogFactoryUtil.getLog(BeanToXMLUtil.class);

    public static void addBean(Object object, Element parentEl) {
        Class<?> clazz = object.getClass();
        String classNameWithoutPackage = BeanToXMLUtil.getClassNameWithoutPackage(clazz.getName());
        Element el = parentEl.addElement(classNameWithoutPackage);
        BeanToXMLUtil.addFields(object, el);
    }

    public static void addFields(Object object, Element parentEl) {
        Method[] methods;
        Class<?> clazz = object.getClass();
        for (Method method : methods = clazz.getMethods()) {
            String methodName = method.getName();
            if (!methodName.startsWith("get") || methodName.equals("getClass")) continue;
            String memberName = StringUtil.removeSubstring((String)methodName, (String)"get");
            memberName = TextFormatter.format((String)memberName, (int)8);
            memberName = TextFormatter.format((String)memberName, (int)10);
            try {
                Object returnValue = method.invoke(object, new Object[0]);
                if (returnValue instanceof List) {
                    List list = (List)returnValue;
                    Element listEl = parentEl.addElement(memberName);
                    for (Object curObject : list) {
                        BeanToXMLUtil.addBean(curObject, listEl);
                    }
                    continue;
                }
                BeanToXMLUtil._add(parentEl, memberName, returnValue.toString());
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)exception.getMessage());
            }
        }
    }

    public static String getClassNameWithoutPackage(String className) {
        String[] classNameArray = StringUtil.split((String)className, (char)'.');
        String classNameWithoutPackage = classNameArray[classNameArray.length - 1];
        classNameWithoutPackage = TextFormatter.format((String)classNameWithoutPackage, (int)8);
        classNameWithoutPackage = TextFormatter.format((String)classNameWithoutPackage, (int)10);
        return classNameWithoutPackage;
    }

    private static Element _add(Element element, String name, String text) {
        Element childElement = element.addElement(name);
        childElement.addText(GetterUtil.getString((String)text));
        return childElement;
    }
}

