/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.storage.bundlefile;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.osgi.container.ModuleContainerAdaptor;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.eclipse.osgi.storage.bundlefile.DirZipBundleEntry;
import org.eclipse.osgi.storage.bundlefile.MRUBundleFileList;
import org.eclipse.osgi.storage.bundlefile.ZipBundleEntry;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.FrameworkListener;

public class ZipBundleFile
extends BundleFile {
    private final ReentrantLock openLock = new ReentrantLock();
    private final Condition refCondition = this.openLock.newCondition();
    private final MRUBundleFileList mruList;
    private final BundleInfo.Generation generation;
    private final Debug debug;
    private volatile ZipFile zipFile;
    private volatile boolean closed = true;
    private int referenceCount = 0;
    private static final Field _bufField;

    public ZipBundleFile(File basefile, BundleInfo.Generation generation, MRUBundleFileList mruList, Debug debug) throws IOException {
        super(basefile);
        if (!BundleFile.secureAction.exists(basefile)) {
            throw new IOException(NLS.bind(Msg.ADAPTER_FILEEXIST_EXCEPTION, basefile));
        }
        this.debug = debug;
        this.generation = generation;
        this.closed = true;
        this.mruList = mruList;
    }

    private boolean lockOpen() {
        try {
            return this.getZipFile(true) != null;
        }
        catch (IOException e) {
            ModuleRevision r;
            if (this.generation != null && (r = this.generation.getRevision()) != null) {
                ModuleContainerAdaptor.ContainerEvent eventType = ModuleContainerAdaptor.ContainerEvent.ERROR;
                if (!r.getRevisions().getModuleRevisions().contains(r)) {
                    eventType = ModuleContainerAdaptor.ContainerEvent.INFO;
                }
                this.generation.getBundleInfo().getStorage().getAdaptor().publishContainerEvent(eventType, r.getRevisions().getModule(), e, new FrameworkListener[0]);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZipFile getZipFile(boolean keepLock) throws IOException {
        this.openLock.lock();
        try {
            if (this.closed) {
                boolean needBackPressure = this.mruListAdd();
                if (needBackPressure) {
                    this.openLock.unlock();
                    try {
                        this.mruListApplyBackPressure();
                    }
                    finally {
                        this.openLock.lock();
                    }
                }
                if (this.closed) {
                    if (needBackPressure) {
                        this.mruListAdd();
                    }
                    this.zipFile = BundleFile.secureAction.getZipFile(this.basefile);
                    this.closed = false;
                }
            } else {
                this.mruListUse();
            }
            ZipFile zipFile = this.zipFile;
            return zipFile;
        }
        finally {
            if (!keepLock || this.closed) {
                this.openLock.unlock();
            }
        }
    }

    private ZipEntry getZipEntry(String path) {
        ZipEntry dirEntry;
        ZipEntry entry;
        if (path.length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if ((entry = this.zipFile.getEntry(path)) != null && entry.getSize() == 0L && !entry.isDirectory() && (dirEntry = this.zipFile.getEntry(path + '/')) != null) {
            entry = dirEntry;
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File extractDirectory(String dirName) {
        if (!this.lockOpen()) {
            return null;
        }
        try {
            Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
            while (entries.hasMoreElements()) {
                String entryPath = entries.nextElement().getName();
                if (!entryPath.startsWith(dirName) || entryPath.endsWith("/")) continue;
                this.getFile(entryPath, false);
            }
            File file = this.getExtractFile(dirName);
            return file;
        }
        finally {
            this.openLock.unlock();
        }
    }

    private File getExtractFile(String entryName) {
        if (this.generation == null) {
            return null;
        }
        String path = ".cp";
        String name = entryName.replace('/', File.separatorChar);
        path = name.length() > 1 && name.charAt(0) == File.separatorChar ? path.concat(name) : path + File.separator + name;
        return this.generation.getExtractFile(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File getFile(String entry, boolean nativeCode) {
        block17: {
            if (!this.lockOpen()) {
                return null;
            }
            ZipEntry zipEntry = this.getZipEntry(entry);
            if (zipEntry == null) {
                File file = null;
                this.openLock.unlock();
                return file;
            }
            File nested = this.getExtractFile(zipEntry.getName());
            if (nested == null) break block17;
            if (nested.exists()) {
                if (this.debug.DEBUG_BUNDLE_FILE) {
                    Debug.println("File already present: " + nested.getPath());
                }
                if (nested.isDirectory()) {
                    this.extractDirectory(zipEntry.getName());
                }
            } else if (zipEntry.getName().endsWith("/")) {
                nested.mkdirs();
                if (!nested.isDirectory()) {
                    if (!this.debug.DEBUG_BUNDLE_FILE) throw new IOException(NLS.bind(Msg.ADAPTOR_DIRECTORY_CREATE_EXCEPTION, nested.getAbsolutePath()));
                    Debug.println("Unable to create directory: " + nested.getPath());
                    throw new IOException(NLS.bind(Msg.ADAPTOR_DIRECTORY_CREATE_EXCEPTION, nested.getAbsolutePath()));
                }
                this.extractDirectory(zipEntry.getName());
            } else {
                InputStream in = this.zipFile.getInputStream(zipEntry);
                if (in == null) {
                    File file = null;
                    this.openLock.unlock();
                    return file;
                }
                this.generation.storeContent(nested, in, nativeCode);
            }
            File file = nested;
            this.openLock.unlock();
            return file;
        }
        try {
            return null;
        }
        finally {
            this.openLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsDir(String dir) {
        if (!this.lockOpen()) {
            return false;
        }
        try {
            if (dir == null) {
                boolean bl = false;
                return bl;
            }
            if (dir.length() == 0) {
                boolean bl = true;
                return bl;
            }
            if (dir.charAt(0) == '/') {
                if (dir.length() == 1) {
                    boolean bl = true;
                    return bl;
                }
                dir = dir.substring(1);
            }
            if (dir.length() > 0 && dir.charAt(dir.length() - 1) != '/') {
                dir = dir + '/';
            }
            Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                String entryPath = zipEntry.getName();
                if (!entryPath.startsWith(dir)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.openLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BundleEntry getEntry(String path) {
        if (!this.lockOpen()) {
            return null;
        }
        try {
            ZipEntry zipEntry = this.getZipEntry(path);
            if (zipEntry == null) {
                if ((path.length() == 0 || path.charAt(path.length() - 1) == '/') && this.containsDir(path)) {
                    DirZipBundleEntry dirZipBundleEntry = new DirZipBundleEntry(this, path);
                    return dirZipBundleEntry;
                }
                BundleEntry bundleEntry = null;
                return bundleEntry;
            }
            ZipBundleEntry zipBundleEntry = new ZipBundleEntry(zipEntry, this);
            return zipBundleEntry;
        }
        finally {
            this.openLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<String> getEntryPaths(String path, boolean recurse) {
        if (!this.lockOpen()) {
            return null;
        }
        try {
            if (path == null) {
                throw new NullPointerException();
            }
            if (path.length() > 0 && path.charAt(0) == '/') {
                path = path.substring(1);
            }
            if (path.length() > 0 && path.charAt(path.length() - 1) != '/') {
                path = path + "/";
            }
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                String entryPath = zipEntry.getName();
                if (!entryPath.startsWith(path) || path.length() >= entryPath.length()) continue;
                this.getEntryPaths(path, entryPath.substring(path.length()), recurse, result);
            }
            Enumeration<String> enumeration = result.size() == 0 ? null : Collections.enumeration(result);
            return enumeration;
        }
        finally {
            this.openLock.unlock();
        }
    }

    private void getEntryPaths(String path, String entry, boolean recurse, LinkedHashSet<String> entries) {
        if (entry.length() == 0) {
            return;
        }
        int slash = entry.indexOf(47);
        if (slash == -1) {
            entries.add(path + entry);
        } else {
            path = path + entry.substring(0, slash + 1);
            entries.add(path);
            if (recurse) {
                this.getEntryPaths(path, entry.substring(slash + 1), true, entries);
            }
        }
    }

    @Override
    public void close() throws IOException {
        block8: {
            this.openLock.lock();
            try {
                if (this.closed) break block8;
                if (this.referenceCount > 0 && this.isMruListClosing()) {
                    try {
                        this.refCondition.await(1000L, TimeUnit.MICROSECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.referenceCount != 0 || this.closed) {
                        return;
                    }
                }
                this.closed = true;
                this.zipFile.close();
                this.mruListRemove();
                this.zipFile = null;
            }
            finally {
                this.openLock.unlock();
            }
        }
    }

    private boolean isMruListClosing() {
        return this.mruList != null && this.mruList.isClosing(this);
    }

    private boolean isMruEnabled() {
        return this.mruList != null && this.mruList.isEnabled();
    }

    private void mruListRemove() {
        if (this.mruList != null) {
            this.mruList.remove(this);
        }
    }

    private void mruListUse() {
        if (this.mruList != null) {
            this.mruList.use(this);
        }
    }

    private void mruListApplyBackPressure() {
        if (this.mruList != null) {
            this.mruList.applyBackpressure();
        }
    }

    private boolean mruListAdd() {
        if (this.mruList != null) {
            return this.mruList.add(this);
        }
        return false;
    }

    @Override
    public void open() throws IOException {
        this.getZipFile(false);
    }

    void incrementReference() {
        this.openLock.lock();
        try {
            ++this.referenceCount;
        }
        finally {
            this.openLock.unlock();
        }
    }

    void decrementReference() {
        this.openLock.lock();
        try {
            this.referenceCount = Math.max(0, this.referenceCount - 1);
            if (this.referenceCount == 0) {
                this.refCondition.signal();
            }
        }
        finally {
            this.openLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream getInputStream(ZipEntry entry) throws IOException {
        if (!this.lockOpen()) {
            throw new IOException("Failed to open zip file.");
        }
        try {
            InputStream zipStream = this.zipFile.getInputStream(entry);
            if (this.isMruEnabled()) {
                zipStream = new ZipBundleEntryInputStream(zipStream);
            }
            InputStream inputStream = zipStream;
            return inputStream;
        }
        finally {
            this.openLock.unlock();
        }
    }

    static {
        Field bufField = null;
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.startsWith("1.8.")) {
            try {
                bufField = InflaterInputStream.class.getDeclaredField("buf");
                bufField.setAccessible(true);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        _bufField = bufField;
    }

    private class ZipBundleEntryInputStream
    extends FilterInputStream {
        private boolean streamClosed;

        public ZipBundleEntryInputStream(InputStream stream) {
            super(stream);
            this.streamClosed = false;
            ZipBundleFile.this.incrementReference();
        }

        @Override
        public int available() throws IOException {
            try {
                return super.available();
            }
            catch (IOException e) {
                throw this.enrichExceptionWithBaseFile(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            catch (IOException e) {
                throw this.enrichExceptionWithBaseFile(e);
            }
            finally {
                if (_bufField != null && this.in instanceof InflaterInputStream) {
                    try {
                        _bufField.set(this.in, null);
                    }
                    catch (ReflectiveOperationException reflectiveOperationException) {}
                }
                ZipBundleEntryInputStream zipBundleEntryInputStream = this;
                synchronized (zipBundleEntryInputStream) {
                    if (this.streamClosed) {
                        return;
                    }
                    this.streamClosed = true;
                }
                ZipBundleFile.this.decrementReference();
            }
        }

        @Override
        public int read() throws IOException {
            try {
                return super.read();
            }
            catch (IOException e) {
                throw this.enrichExceptionWithBaseFile(e);
            }
        }

        @Override
        public int read(byte[] var0, int var1, int var2) throws IOException {
            try {
                return super.read(var0, var1, var2);
            }
            catch (IOException e) {
                throw this.enrichExceptionWithBaseFile(e);
            }
        }

        @Override
        public int read(byte[] var0) throws IOException {
            try {
                return super.read(var0);
            }
            catch (IOException e) {
                throw this.enrichExceptionWithBaseFile(e);
            }
        }

        @Override
        public void reset() throws IOException {
            try {
                super.reset();
            }
            catch (IOException e) {
                throw this.enrichExceptionWithBaseFile(e);
            }
        }

        @Override
        public long skip(long var0) throws IOException {
            try {
                return super.skip(var0);
            }
            catch (IOException e) {
                throw this.enrichExceptionWithBaseFile(e);
            }
        }

        private IOException enrichExceptionWithBaseFile(IOException e) {
            return new IOException(ZipBundleFile.this.getBaseFile().toString(), e);
        }
    }
}

