/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.container;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.container.ModuleRevision;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleRevisions;

public final class ModuleRevisions
implements BundleRevisions {
    private final Module module;
    private final ModuleContainer container;
    private final Deque<ModuleRevision> revisions = new ConcurrentLinkedDeque<ModuleRevision>();
    private volatile ModuleRevision uninstalledCurrent;

    ModuleRevisions(Module module, ModuleContainer container) {
        this.module = module;
        this.container = container;
    }

    public Module getModule() {
        return this.module;
    }

    ModuleContainer getContainer() {
        return this.container;
    }

    @Override
    public Bundle getBundle() {
        return this.module.getBundle();
    }

    @Override
    public List<BundleRevision> getRevisions() {
        return new ArrayList<BundleRevision>(this.revisions);
    }

    public List<ModuleRevision> getModuleRevisions() {
        return new ArrayList<ModuleRevision>(this.revisions);
    }

    ModuleRevision getCurrentRevision() {
        ModuleRevision moduleRevision = this.uninstalledCurrent;
        if (moduleRevision == null) {
            moduleRevision = this.revisions.peek();
        }
        return moduleRevision;
    }

    ModuleRevision addRevision(ModuleRevision revision) {
        this.revisions.push(revision);
        return revision;
    }

    boolean removeRevision(ModuleRevision revision) {
        try {
            boolean bl = this.revisions.remove(revision);
            return bl;
        }
        finally {
            this.module.cleanup(revision);
        }
    }

    boolean isUninstalled() {
        return this.uninstalledCurrent != null;
    }

    void uninstall() {
        ModuleRevision moduleRevision = this.revisions.peek();
        if (moduleRevision == null) {
            throw new IllegalStateException("Revisions is empty on uninstall!");
        }
        this.uninstalledCurrent = moduleRevision;
    }

    public String toString() {
        return "moduleID=" + this.module.getId();
    }
}

