/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.loader.sources;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.container.ModuleWiring;
import org.eclipse.osgi.framework.util.KeyedElement;
import org.eclipse.osgi.internal.framework.EquinoxBundle;
import org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.SystemBundleLoader;
import org.eclipse.osgi.internal.loader.sources.SingleSourcePackage;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.service.packageadmin.PackageAdmin;

public abstract class PackageSource
implements KeyedElement {
    protected final String id;

    public PackageSource(String id) {
        this.id = id.intern();
    }

    public String getId() {
        return this.id;
    }

    public abstract SingleSourcePackage[] getSuppliers();

    @Override
    public boolean compare(KeyedElement other) {
        return this.id.equals(((PackageSource)other).getId());
    }

    @Override
    public int getKeyHashCode() {
        return this.id.hashCode();
    }

    @Override
    public Object getKey() {
        return this.id;
    }

    public boolean isNullSource() {
        return false;
    }

    public abstract Class<?> loadClass(String var1) throws ClassNotFoundException;

    public abstract URL getResource(String var1);

    public abstract Enumeration<URL> getResources(String var1) throws IOException;

    public boolean hasCommonSource(PackageSource other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        SingleSourcePackage[] suppliers1 = this.getSuppliers();
        SingleSourcePackage[] suppliers2 = other.getSuppliers();
        if (suppliers1 == null || suppliers2 == null) {
            return false;
        }
        for (int i = 0; i < suppliers1.length; ++i) {
            for (int j = 0; j < suppliers2.length; ++j) {
                if (!suppliers2[j].equals(suppliers1[i])) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.id).append(" -> ");
        SingleSourcePackage[] suppliers = this.getSuppliers();
        if (suppliers == null) {
            return builder.append(String.valueOf(null)).toString();
        }
        builder.append('[');
        for (int i = 0; i < suppliers.length; ++i) {
            if (i > 0) {
                builder.append(',');
            }
            builder.append(suppliers[i].getLoader());
        }
        builder.append(']');
        return builder.toString();
    }

    public abstract Collection<String> listResources(String var1, String var2);

    public static boolean isServiceAssignableTo(Bundle registrant, Bundle client, String className, Class<?> serviceClass, EquinoxContainer container) {
        Bundle systemBundle;
        SystemBundleLoader systemLoader;
        if (registrant == client) {
            return true;
        }
        if (className.startsWith("java.")) {
            return true;
        }
        BundleLoader producerBL = PackageSource.getBundleLoader(registrant);
        if (producerBL == null) {
            return false;
        }
        BundleLoader consumerBL = PackageSource.getBundleLoader(client);
        if (consumerBL == null) {
            return false;
        }
        String pkgName = BundleLoader.getPackageName(className);
        PackageSource consumerSource = consumerBL.getPackageSource(pkgName);
        if (consumerSource == null) {
            return true;
        }
        if (container.isBootDelegationPackage(pkgName) && (systemLoader = (SystemBundleLoader)PackageSource.getBundleLoader(systemBundle = container.getStorage().getModuleContainer().getModule(0L).getBundle())).isExportedPackage(pkgName)) {
            return true;
        }
        PackageSource producerSource = producerBL.getPackageSource(pkgName);
        if (producerSource == null) {
            Bundle bundle;
            if (serviceClass != null && ServiceFactory.class.isAssignableFrom(serviceClass) && (bundle = container.getPackageAdmin().getBundle(serviceClass)) != null && bundle != registrant) {
                return true;
            }
            producerSource = PackageSource.getPackageSource(serviceClass, pkgName, container.getPackageAdmin());
            if (producerSource == null) {
                return false;
            }
        }
        return producerSource.hasCommonSource(consumerSource);
    }

    private static PackageSource getPackageSource(Class<?> serviceClass, String pkgName, PackageAdmin packageAdmin) {
        if (serviceClass == null) {
            return null;
        }
        Bundle serviceBundle = packageAdmin.getBundle(serviceClass);
        if (serviceBundle == null) {
            return null;
        }
        BundleLoader producerBL = PackageSource.getBundleLoader(serviceBundle);
        if (producerBL == null) {
            return null;
        }
        PackageSource producerSource = producerBL.getPackageSource(pkgName);
        if (producerSource != null) {
            return producerSource;
        }
        Class<?>[] interfaces = serviceClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            producerSource = PackageSource.getPackageSource(interfaces[i], pkgName, packageAdmin);
            if (producerSource == null) continue;
            return producerSource;
        }
        return PackageSource.getPackageSource(serviceClass.getSuperclass(), pkgName, packageAdmin);
    }

    private static BundleLoader getBundleLoader(Bundle bundle) {
        ModuleRevision producer = ((EquinoxBundle)bundle).getModule().getCurrentRevision();
        ModuleWiring producerWiring = producer.getWiring();
        return producerWiring == null ? null : (BundleLoader)producerWiring.getModuleLoader();
    }
}

