/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.io.IOException;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.scr.impl.logger.ScrLogger;
import org.apache.felix.scr.impl.manager.ComponentActivator;
import org.apache.felix.scr.impl.manager.ComponentHolder;
import org.apache.felix.scr.impl.metadata.TargetedPID;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.cm.ConfigurationPermission;
import org.osgi.service.cm.ManagedService;

public abstract class RegionConfigurationSupport {
    private final ScrLogger logger;
    private final ServiceReference<ConfigurationAdmin> caReference;
    private final BundleContext caBundleContext;
    private final Long bundleId;
    private final AtomicInteger referenceCount = new AtomicInteger(1);
    private volatile ServiceRegistration<ConfigurationListener> m_registration;

    public RegionConfigurationSupport(ScrLogger logger, ServiceReference<ConfigurationAdmin> reference) {
        this.logger = logger;
        this.caReference = reference;
        Bundle bundle = reference.getBundle();
        this.bundleId = bundle.getBundleId();
        this.caBundleContext = bundle.getBundleContext();
    }

    public void start() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.description", "Declarative Services Configuration Support Listener");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        Object serviceDelegator = System.getSecurityManager() != null ? new ConfigurationListener(){

            public void configurationEvent(final ConfigurationEvent event) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Void run() {
                        RegionConfigurationSupport.this.configurationEvent(event);
                        return null;
                    }
                });
            }
        } : new ConfigurationListener(){

            public void configurationEvent(ConfigurationEvent event) {
                RegionConfigurationSupport.this.configurationEvent(event);
            }
        };
        this.m_registration = this.caBundleContext.registerService(ConfigurationListener.class, serviceDelegator, props);
    }

    public Long getBundleId() {
        return this.bundleId;
    }

    public boolean reference() {
        if (this.referenceCount.get() == 0) {
            return false;
        }
        this.referenceCount.incrementAndGet();
        return true;
    }

    public boolean dereference() {
        if (this.referenceCount.decrementAndGet() == 0) {
            this.m_registration.unregister();
            this.m_registration = null;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean configureComponentHolder(ComponentHolder<?> holder) {
        if (!holder.getComponentMetadata().isConfigurationIgnored()) {
            BundleContext bundleContext = holder.getActivator().getBundleContext();
            if (bundleContext == null) {
                return false;
            }
            List<String> confPids = holder.getComponentMetadata().getConfigurationPid();
            ConfigurationAdmin ca = this.getConfigAdmin(bundleContext);
            boolean missingConfiguration = false;
            for (String confPid : confPids) {
                Collection<Configuration> factory = this.findFactoryConfigurations(ca, confPid, bundleContext.getBundle());
                if (!factory.isEmpty()) {
                    boolean created = false;
                    for (Configuration config : factory) {
                        this.logger.log(4, "Configuring holder {0} with factory configuration {1}, change count {2}", null, holder, config, config.getChangeCount());
                        if (!this.checkBundleLocation(config, bundleContext.getBundle())) continue;
                        long changeCount = config.getChangeCount();
                        ServiceReference<ManagedService> ref = this.getManagedServiceReference(bundleContext);
                        created |= holder.configurationUpdated(new TargetedPID(config.getPid()), new TargetedPID(config.getFactoryPid()), config.getProcessedProperties(ref), changeCount);
                    }
                    if (created) continue;
                    missingConfiguration = true;
                    continue;
                }
                Configuration singleton = this.findSingletonConfiguration(ca, confPid, bundleContext.getBundle());
                if (singleton != null) {
                    this.logger.log(4, "Configuring holder {0} with configuration {1}, change count {2}", null, holder, singleton, singleton.getChangeCount());
                    if (singleton != null && this.checkBundleLocation(singleton, bundleContext.getBundle())) {
                        long changeCount = singleton.getChangeCount();
                        ServiceReference<ManagedService> ref = this.getManagedServiceReference(bundleContext);
                        holder.configurationUpdated(new TargetedPID(singleton.getPid()), null, singleton.getProcessedProperties(ref), changeCount);
                        continue;
                    }
                    missingConfiguration = true;
                    continue;
                }
                missingConfiguration = true;
            }
            if (missingConfiguration) {
                boolean bl = false;
                return bl;
            }
            boolean bl = !confPids.isEmpty();
            return bl;
            finally {
                try {
                    bundleContext.ungetService(this.caReference);
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
        return false;
    }

    public void configurationEvent(ConfigurationEvent event) {
        TargetedPID pid = new TargetedPID(event.getPid());
        String rawFactoryPid = event.getFactoryPid();
        TargetedPID factoryPid = rawFactoryPid == null ? null : new TargetedPID(rawFactoryPid);
        Collection<ComponentHolder<?>> holders = this.getComponentHolders(factoryPid != null ? factoryPid : pid);
        this.logger.log(4, "configurationEvent: Handling {0} of Configuration PID={1} for component holders {2}", null, this.getEventType(event), pid, holders);
        block5: for (ComponentHolder<?> componentHolder : holders) {
            if (componentHolder.getComponentMetadata().isConfigurationIgnored()) continue;
            switch (event.getType()) {
                case 2: {
                    if (factoryPid == null && this.configureComponentHolder(componentHolder)) continue block5;
                    componentHolder.configurationDeleted(pid, factoryPid);
                    break;
                }
                case 1: {
                    ConfigurationInfo configInfo;
                    BundleContext bundleContext;
                    ComponentActivator activator = componentHolder.getActivator();
                    if (activator == null || (bundleContext = activator.getBundleContext()) == null) break;
                    TargetedPID targetedPid = factoryPid == null ? pid : factoryPid;
                    TargetedPID oldTargetedPID = componentHolder.getConfigurationTargetedPID(pid, factoryPid);
                    if (factoryPid == null && !targetedPid.equals(oldTargetedPID) && !targetedPid.bindsStronger(oldTargetedPID) || (configInfo = this.getConfigurationInfo(pid, targetedPid, componentHolder, bundleContext)) == null || !this.checkBundleLocation(configInfo.getBundleLocation(), bundleContext.getBundle())) continue block5;
                    componentHolder.configurationUpdated(pid, factoryPid, configInfo.getProps(), configInfo.getChangeCount());
                    break;
                }
                case 3: {
                    TargetedPID oldTargetedPID;
                    BundleContext bundleContext;
                    ComponentActivator activator = componentHolder.getActivator();
                    if (activator == null || (bundleContext = activator.getBundleContext()) == null) break;
                    TargetedPID targetedPid = factoryPid == null ? pid : factoryPid;
                    if (targetedPid.equals(oldTargetedPID = componentHolder.getConfigurationTargetedPID(pid, factoryPid))) {
                        ConfigurationInfo configInfo = this.getConfigurationInfo(pid, targetedPid, componentHolder, bundleContext);
                        if (configInfo == null) continue block5;
                        this.logger.log(4, "LocationChanged event, same targetedPID {0}, location now {1}, change count {2}", null, targetedPid, configInfo.getBundleLocation(), configInfo.getChangeCount());
                        if (configInfo.getProps() == null) {
                            throw new IllegalStateException("Existing Configuration with pid " + pid + " has had its properties set to null and location changed.  We expected a delete event first.");
                        }
                        if (this.checkBundleLocation(configInfo.getBundleLocation(), bundleContext.getBundle())) continue block5;
                        componentHolder.configurationDeleted(pid, factoryPid);
                        this.configureComponentHolder(componentHolder);
                        break;
                    }
                    boolean better = targetedPid.bindsStronger(oldTargetedPID);
                    if (better) {
                        ConfigurationInfo configInfo = this.getConfigurationInfo(pid, targetedPid, componentHolder, bundleContext);
                        if (configInfo == null) continue block5;
                        this.logger.log(4, "LocationChanged event, better targetedPID {0} compared to {1}, location now {2}, change count {3}", null, targetedPid, oldTargetedPID, configInfo.getBundleLocation(), configInfo.getChangeCount());
                        if (configInfo.getProps() == null) break;
                        if (!this.checkBundleLocation(configInfo.getBundleLocation(), bundleContext.getBundle())) continue block5;
                        if (oldTargetedPID != null) {
                            componentHolder.configurationDeleted(pid, factoryPid);
                        }
                        componentHolder.configurationUpdated(pid, factoryPid, configInfo.getProps(), configInfo.getChangeCount());
                        break;
                    }
                    this.logger.log(4, "LocationChanged event, worse targetedPID {0} compared to {1}, do nothing", null, targetedPid, oldTargetedPID);
                    break;
                }
                default: {
                    this.logger.log(2, "Unknown ConfigurationEvent type {0}", null, event.getType());
                }
            }
        }
    }

    protected abstract Collection<ComponentHolder<?>> getComponentHolders(TargetedPID var1);

    private String getEventType(ConfigurationEvent event) {
        switch (event.getType()) {
            case 1: {
                return "UPDATED";
            }
            case 2: {
                return "DELETED";
            }
            case 3: {
                return "LOCATION CHANGED";
            }
        }
        return "Unkown event type: " + event.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ConfigurationInfo getConfigurationInfo(TargetedPID pid, TargetedPID targetedPid, ComponentHolder<?> componentHolder, BundleContext bundleContext) {
        try {
            ConfigurationAdmin ca = this.getConfigAdmin(bundleContext);
            try {
                Configuration[] configs = ca.listConfigurations(this.filter(pid.getRawPid()));
                if (configs == null) return null;
                if (configs.length <= 0) return null;
                Configuration config = configs[0];
                ServiceReference<ManagedService> ref = this.getManagedServiceReference(bundleContext);
                ConfigurationInfo configurationInfo = new ConfigurationInfo(config.getProcessedProperties(ref), config.getBundleLocation(), config.getChangeCount());
                return configurationInfo;
            }
            catch (IOException e) {
                this.logger.log(2, "Failed reading configuration for pid={0}", e, pid);
                return null;
            }
            catch (InvalidSyntaxException e) {
                this.logger.log(2, "Failed reading configuration for pid={0}", e, pid);
                return null;
            }
            finally {
                bundleContext.ungetService(this.caReference);
            }
        }
        catch (IllegalStateException ise) {
            this.logger.log(2, "Bundle in unexpected state", ise);
        }
        return null;
    }

    private ServiceReference<ManagedService> getManagedServiceReference(BundleContext bundleContext) {
        try {
            Collection refs = bundleContext.getServiceReferences(ManagedService.class, "(&(service.bundleid=" + String.valueOf(bundleContext.getBundle().getBundleId()) + ")(!(service.pid=*)))");
            if (!refs.isEmpty()) {
                return (ServiceReference)refs.iterator().next();
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        return bundleContext.registerService(ManagedService.class, (Object)new ManagedService(){

            public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
            }
        }, null).getReference();
    }

    private String filter(String rawPid) {
        return "(service.pid=" + rawPid + ")";
    }

    public Configuration findSingletonConfiguration(ConfigurationAdmin ca, String pid, Bundle bundle) {
        String filter = this.getTargetedPidFilter(pid, bundle, "service.pid");
        Configuration[] cfg = this.findConfigurations(ca, filter);
        if (cfg == null) {
            return null;
        }
        String longest = null;
        Configuration best = null;
        for (Configuration config : cfg) {
            if (!this.checkBundleLocation(config, bundle)) continue;
            String testPid = config.getPid();
            if (longest != null && testPid.length() <= longest.length()) continue;
            longest = testPid;
            best = config;
        }
        return best;
    }

    private Collection<Configuration> findFactoryConfigurations(ConfigurationAdmin ca, String factoryPid, Bundle bundle) {
        String filter = this.getTargetedPidFilter(factoryPid, bundle, "service.factoryPid");
        Configuration[] configs = this.findConfigurations(ca, filter);
        if (configs == null) {
            return Collections.emptyList();
        }
        HashMap<String, Configuration> configsByPid = new HashMap<String, Configuration>();
        for (Configuration config : configs) {
            if (!this.checkBundleLocation(config, bundle)) continue;
            Configuration oldConfig = (Configuration)configsByPid.get(config.getPid());
            if (oldConfig == null) {
                configsByPid.put(config.getPid(), config);
                continue;
            }
            String newPid = config.getFactoryPid();
            String oldPid = oldConfig.getFactoryPid();
            if (newPid.length() <= oldPid.length()) continue;
            configsByPid.put(config.getPid(), config);
        }
        return configsByPid.values();
    }

    private boolean checkBundleLocation(Configuration config, Bundle bundle) {
        if (config == null) {
            return false;
        }
        String configBundleLocation = config.getBundleLocation();
        return this.checkBundleLocation(configBundleLocation, bundle);
    }

    private boolean checkBundleLocation(String configBundleLocation, Bundle bundle) {
        boolean result = configBundleLocation == null ? true : (configBundleLocation.startsWith("?") ? bundle.hasPermission((Object)new ConfigurationPermission(configBundleLocation, "target")) : configBundleLocation.equals(bundle.getLocation()));
        this.logger.log(4, "checkBundleLocation: location {0}, returning {1}", null, configBundleLocation, result);
        return result;
    }

    private Configuration[] findConfigurations(ConfigurationAdmin ca, String filter) {
        try {
            return ca.listConfigurations(filter);
        }
        catch (IOException ioe) {
            this.logger.log(2, "Problem listing configurations for filter={0}", ioe, filter);
        }
        catch (InvalidSyntaxException ise) {
            this.logger.log(1, "Invalid Configuration selection filter {0}", ise, filter);
        }
        return null;
    }

    private String getTargetedPidFilter(String pid, Bundle bundle, String key) {
        String bsn = bundle.getSymbolicName();
        String version = bundle.getVersion().toString();
        String location = RegionConfigurationSupport.escape(bundle.getLocation());
        StringBuilder sb = new StringBuilder();
        sb.append("(|(");
        sb.append(key);
        sb.append('=');
        sb.append(pid);
        sb.append(")(");
        sb.append(key);
        sb.append('=');
        sb.append(pid);
        sb.append('|');
        sb.append(bsn);
        sb.append(")(");
        sb.append(key);
        sb.append('=');
        sb.append(pid);
        sb.append('|');
        sb.append(bsn);
        sb.append('|');
        sb.append(version);
        sb.append(")(");
        sb.append(key);
        sb.append('=');
        sb.append(pid);
        sb.append('|');
        sb.append(bsn);
        sb.append('|');
        sb.append(version);
        sb.append('|');
        sb.append(location);
        sb.append("))");
        return sb.toString();
    }

    static final String escape(String value) {
        StringBuilder sb = null;
        int index = 0;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '(': 
                case ')': 
                case '*': 
                case '\\': {
                    if (sb == null) {
                        sb = new StringBuilder();
                    }
                    sb.append(value, index, i);
                    sb.append('\\');
                    sb.append(c);
                    index = i + 1;
                }
            }
        }
        if (sb == null) {
            return value;
        }
        if (index < value.length()) {
            sb.append(value, index, value.length());
        }
        return sb.toString();
    }

    private ConfigurationAdmin getConfigAdmin(BundleContext bundleContext) {
        return (ConfigurationAdmin)bundleContext.getService(this.caReference);
    }

    private static class CMProtectionDomain
    extends ProtectionDomain {
        private final Bundle bundle;

        CMProtectionDomain(Bundle bundle) {
            super(null, null);
            this.bundle = bundle;
        }

        @Override
        public boolean implies(Permission permission) {
            try {
                return this.bundle.hasPermission((Object)permission);
            }
            catch (IllegalStateException e) {
                return false;
            }
        }
    }

    private static class CMDomainCombiner
    implements DomainCombiner {
        private final CMProtectionDomain domain;

        CMDomainCombiner(Bundle bundle) {
            this.domain = new CMProtectionDomain(bundle);
        }

        @Override
        public ProtectionDomain[] combine(ProtectionDomain[] arg0, ProtectionDomain[] arg1) {
            return new ProtectionDomain[]{this.domain};
        }
    }

    private static class ConfigurationInfo {
        private final Dictionary<String, Object> props;
        private final String bundleLocation;
        private final long changeCount;

        public ConfigurationInfo(Dictionary<String, Object> props, String bundleLocation, long changeCount) {
            this.props = props;
            this.bundleLocation = bundleLocation;
            this.changeCount = changeCount;
        }

        public long getChangeCount() {
            return this.changeCount;
        }

        public Dictionary<String, Object> getProps() {
            return this.props;
        }

        public String getBundleLocation() {
            return this.bundleLocation;
        }
    }
}

