/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.scr.impl.ComponentActorThread;
import org.apache.felix.scr.impl.ComponentRegistryKey;
import org.apache.felix.scr.impl.inject.ComponentMethods;
import org.apache.felix.scr.impl.inject.ComponentMethodsImpl;
import org.apache.felix.scr.impl.logger.ComponentLogger;
import org.apache.felix.scr.impl.logger.ScrLogger;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.manager.ComponentActivator;
import org.apache.felix.scr.impl.manager.ComponentHolder;
import org.apache.felix.scr.impl.manager.ConfigurableComponentHolder;
import org.apache.felix.scr.impl.manager.DependencyManager;
import org.apache.felix.scr.impl.manager.RegionConfigurationSupport;
import org.apache.felix.scr.impl.manager.ScrConfiguration;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.metadata.TargetedPID;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentException;
import org.osgi.service.component.runtime.ServiceComponentRuntime;

public class ComponentRegistry {
    private static String PROP_CHANGECOUNT = "service.changecount";
    private final Map<ComponentRegistryKey, ComponentHolder<?>> m_componentHoldersByName;
    private final Map<String, Set<ComponentHolder<?>>> m_componentHoldersByPid;
    private final Map<Long, AbstractComponentManager<?>> m_componentsById;
    private long m_componentCounter = -1L;
    private final Map<ServiceReference<?>, List<Entry<?, ?>>> m_missingDependencies = new HashMap();
    private final ScrLogger m_logger;
    private final ScrConfiguration m_configuration;
    private final ThreadLocal<List<ServiceReference<?>>> circularInfos = new ThreadLocal<List<ServiceReference<?>>>(){

        @Override
        protected List<ServiceReference<?>> initialValue() {
            return new ArrayList();
        }
    };
    private final ConcurrentMap<Long, RegionConfigurationSupport> bundleToRcsMap = new ConcurrentHashMap<Long, RegionConfigurationSupport>();
    private final Object changeCountLock = new Object();
    private volatile long changeCount;
    private volatile Timer timer;
    private volatile ServiceRegistration<ServiceComponentRuntime> registration;

    public ComponentRegistry(ScrConfiguration scrConfiguration, ScrLogger logger) {
        this.m_configuration = scrConfiguration;
        this.m_logger = logger;
        this.m_componentHoldersByName = new HashMap();
        this.m_componentHoldersByPid = new HashMap();
        this.m_componentsById = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long registerComponentId(AbstractComponentManager<?> componentManager) {
        long componentId;
        Map<Long, AbstractComponentManager<?>> map = this.m_componentsById;
        synchronized (map) {
            componentId = ++this.m_componentCounter;
            this.m_componentsById.put(componentId, componentManager);
        }
        return componentId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void unregisterComponentId(long componentId) {
        Map<Long, AbstractComponentManager<?>> map = this.m_componentsById;
        synchronized (map) {
            this.m_componentsById.remove(componentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ComponentRegistryKey checkComponentName(Bundle bundle, String name) {
        boolean present;
        ComponentRegistryKey key = new ComponentRegistryKey(bundle, name);
        ComponentHolder<?> existingRegistration = null;
        Map<ComponentRegistryKey, ComponentHolder<?>> map = this.m_componentHoldersByName;
        synchronized (map) {
            present = this.m_componentHoldersByName.containsKey(key);
            if (!present) {
                this.m_componentHoldersByName.put(key, null);
            } else {
                existingRegistration = this.m_componentHoldersByName.get(key);
            }
        }
        if (present) {
            String message = "The component name '" + name + "' has already been registered";
            if (existingRegistration != null) {
                Bundle cBundle = existingRegistration.getActivator().getBundleContext().getBundle();
                ComponentMetadata cMeta = existingRegistration.getComponentMetadata();
                StringBuilder buf = new StringBuilder(message);
                buf.append(" by Bundle ").append(cBundle.getBundleId());
                if (cBundle.getSymbolicName() != null) {
                    buf.append(" (").append(cBundle.getSymbolicName()).append(")");
                }
                buf.append(" as Component of Class ").append(cMeta.getImplementationClassName());
                message = buf.toString();
            }
            throw new ComponentException(message);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void registerComponentHolder(ComponentRegistryKey key, ComponentHolder<?> componentHolder) {
        this.m_logger.log(4, "Registering component with pid {0} for bundle {1}", null, componentHolder.getComponentMetadata().getConfigurationPid(), key.getBundleId());
        Map<Object, Object> map = this.m_componentHoldersByName;
        synchronized (map) {
            if (this.m_componentHoldersByName.get(key) != null) {
                throw new ComponentException("The component name '{0}" + componentHolder.getComponentMetadata().getName() + "' has already been registered.");
            }
            this.m_componentHoldersByName.put(key, componentHolder);
        }
        map = this.m_componentHoldersByPid;
        synchronized (map) {
            List<String> configurationPids = componentHolder.getComponentMetadata().getConfigurationPid();
            for (String configurationPid : configurationPids) {
                Set<ComponentHolder<?>> set = this.m_componentHoldersByPid.get(configurationPid);
                if (set == null) {
                    set = new HashSet();
                    this.m_componentHoldersByPid.put(configurationPid, set);
                }
                set.add(componentHolder);
            }
        }
        this.updateChangeCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ComponentHolder<?> getComponentHolder(Bundle bundle, String name) {
        Map<ComponentRegistryKey, ComponentHolder<?>> map = this.m_componentHoldersByName;
        synchronized (map) {
            return this.m_componentHoldersByName.get(new ComponentRegistryKey(bundle, name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Collection<ComponentHolder<?>> getComponentHoldersByPid(TargetedPID targetedPid) {
        String pid = targetedPid.getServicePid();
        HashSet componentHoldersUsingPid = new HashSet();
        Map<String, Set<ComponentHolder<?>>> map = this.m_componentHoldersByPid;
        synchronized (map) {
            Set<ComponentHolder<?>> set = this.m_componentHoldersByPid.get(pid);
            if (set != null) {
                for (ComponentHolder<?> holder : set) {
                    Bundle bundle = holder.getActivator().getBundleContext().getBundle();
                    if (!targetedPid.matchesTarget(bundle)) continue;
                    componentHoldersUsingPid.add(holder);
                }
            }
        }
        return componentHoldersUsingPid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<ComponentHolder<?>> getComponentHolders() {
        ArrayList all = new ArrayList();
        Map<ComponentRegistryKey, ComponentHolder<?>> map = this.m_componentHoldersByName;
        synchronized (map) {
            all.addAll(this.m_componentHoldersByName.values());
        }
        return all;
    }

    public final List<ComponentHolder<?>> getComponentHolders(Bundle ... bundles) {
        List<ComponentHolder<?>> all = this.getComponentHolders();
        ArrayList holders = new ArrayList();
        for (ComponentHolder<?> holder : all) {
            ComponentActivator activator = holder.getActivator();
            if (activator == null) continue;
            try {
                Bundle holderBundle = activator.getBundleContext().getBundle();
                for (Bundle b : bundles) {
                    if (b != holderBundle) continue;
                    holders.add(holder);
                }
            }
            catch (IllegalStateException illegalStateException) {
            }
        }
        return holders;
    }

    final void unregisterComponentHolder(Bundle bundle, String name) {
        this.unregisterComponentHolder(new ComponentRegistryKey(bundle, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void unregisterComponentHolder(ComponentRegistryKey key) {
        ComponentHolder<?> component;
        Map<Object, Object> map = this.m_componentHoldersByName;
        synchronized (map) {
            component = this.m_componentHoldersByName.remove(key);
        }
        if (component != null) {
            this.m_logger.log(4, "Unregistering component with pid {0} for bundle {1}", null, component.getComponentMetadata().getConfigurationPid(), key.getBundleId());
            map = this.m_componentHoldersByPid;
            synchronized (map) {
                List<String> configurationPids = component.getComponentMetadata().getConfigurationPid();
                for (String configurationPid : configurationPids) {
                    Set<ComponentHolder<?>> componentsForPid = this.m_componentHoldersByPid.get(configurationPid);
                    if (componentsForPid == null) continue;
                    componentsForPid.remove(component);
                    if (componentsForPid.size() != 0) continue;
                    this.m_componentHoldersByPid.remove(configurationPid);
                }
            }
            this.updateChangeCount();
        }
    }

    public <S> ComponentHolder<S> createComponentHolder(ComponentActivator activator, ComponentMetadata metadata, ComponentLogger logger) {
        return new DefaultConfigurableComponentHolder(activator, metadata, logger);
    }

    public <T> boolean enterCreate(ServiceReference<T> serviceReference) {
        List<ServiceReference<?>> info = this.circularInfos.get();
        if (info.contains(serviceReference)) {
            this.m_logger.log(1, "Circular reference detected trying to get service {0}\n stack of references: {1}", new Exception("stack trace"), serviceReference, new Info(info));
            return true;
        }
        this.m_logger.log(4, "getService  {0}: stack of references: {1}", null, serviceReference, info);
        info.add(serviceReference);
        return false;
    }

    public <T> void leaveCreate(ServiceReference<T> serviceReference) {
        List<ServiceReference<?>> info = this.circularInfos.get();
        if (info != null) {
            if (!info.isEmpty() && info.iterator().next().equals(serviceReference)) {
                this.circularInfos.remove();
            } else {
                info.remove(serviceReference);
            }
        }
    }

    public synchronized <T> void missingServicePresent(final ServiceReference<T> serviceReference, ComponentActorThread actor) {
        final List<Entry<?, ?>> dependencyManagers = this.m_missingDependencies.remove(serviceReference);
        if (dependencyManagers != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    for (Entry entry : dependencyManagers) {
                        entry.getDm().invokeBindMethodLate(serviceReference, entry.getTrackingCount());
                    }
                    ComponentRegistry.this.m_logger.log(4, "Ran {0} asynchronously", null, this);
                }

                public String toString() {
                    return "Late binding task of reference " + serviceReference + " for dependencyManagers " + dependencyManagers;
                }
            };
            this.m_logger.log(4, "Scheduling runnable {0} asynchronously", null, runnable);
            actor.schedule(runnable);
        }
    }

    public synchronized <S, T> void registerMissingDependency(DependencyManager<S, T> dependencyManager, ServiceReference<T> serviceReference, int trackingCount) {
        if (serviceReference.getProperty("component.name") == null || serviceReference.getProperty("component.id") == null) {
            this.m_logger.log(4, "Missing service {0} for dependency manager {1} is not a DS service, cannot resolve circular dependency", null, serviceReference, dependencyManager);
            return;
        }
        List<Entry<?, ?>> dependencyManagers = this.m_missingDependencies.get(serviceReference);
        if (dependencyManagers == null) {
            dependencyManagers = new ArrayList();
            this.m_missingDependencies.put(serviceReference, dependencyManagers);
        }
        dependencyManagers.add(new Entry(dependencyManager, trackingCount));
        this.m_logger.log(4, "Dependency managers {0} waiting for missing service {1}", null, dependencyManagers, serviceReference);
    }

    public RegionConfigurationSupport registerRegionConfigurationSupport(ServiceReference<ConfigurationAdmin> reference) {
        RegionConfigurationSupport trialRcs = new RegionConfigurationSupport(this.m_logger, reference){

            @Override
            protected Collection<ComponentHolder<?>> getComponentHolders(TargetedPID pid) {
                return ComponentRegistry.this.getComponentHoldersByPid(pid);
            }
        };
        return this.registerRegionConfigurationSupport(trialRcs);
    }

    public RegionConfigurationSupport registerRegionConfigurationSupport(RegionConfigurationSupport trialRcs) {
        Long bundleId = trialRcs.getBundleId();
        RegionConfigurationSupport existing = null;
        RegionConfigurationSupport previous = null;
        while (true) {
            if ((existing = this.bundleToRcsMap.putIfAbsent(bundleId, trialRcs)) == null) {
                trialRcs.start();
                return trialRcs;
            }
            if (existing == previous) {
                return existing;
            }
            if (existing.reference()) {
                previous = existing;
                continue;
            }
            previous = null;
        }
    }

    public void unregisterRegionConfigurationSupport(RegionConfigurationSupport rcs) {
        if (rcs.dereference()) {
            this.bundleToRcsMap.remove(rcs.getBundleId());
        }
    }

    public Dictionary<String, Object> getServiceRegistrationProperties() {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put(PROP_CHANGECOUNT, this.changeCount);
        return props;
    }

    public void setRegistration(ServiceRegistration<ServiceComponentRuntime> reg) {
        this.registration = reg;
    }

    public void updateChangeCount() {
    }

    private static class Entry<S, T> {
        private final DependencyManager<S, T> dm;
        private final int trackingCount;

        private Entry(DependencyManager<S, T> dm, int trackingCount) {
            this.dm = dm;
            this.trackingCount = trackingCount;
        }

        public DependencyManager<S, T> getDm() {
            return this.dm;
        }

        public int getTrackingCount() {
            return this.trackingCount;
        }

        public String toString() {
            return this.dm.toString() + "@" + this.trackingCount;
        }
    }

    private class Info {
        private final List<ServiceReference<?>> info;

        public Info(List<ServiceReference<?>> info) {
            this.info = info;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (ServiceReference<?> sr : this.info) {
                sb.append("ServiceReference: ").append(sr).append("\n");
                List entries = (List)ComponentRegistry.this.m_missingDependencies.get(sr);
                if (entries == null) continue;
                for (Entry entry : entries) {
                    sb.append("    Dependency: ").append(entry.getDm()).append("\n");
                }
            }
            return sb.toString();
        }
    }

    static class DefaultConfigurableComponentHolder<S>
    extends ConfigurableComponentHolder<S> {
        public DefaultConfigurableComponentHolder(ComponentActivator activator, ComponentMetadata metadata, ComponentLogger logger) {
            super(activator, metadata, logger);
        }

        @Override
        protected ComponentMethods<S> createComponentMethods() {
            return new ComponentMethodsImpl();
        }
    }
}

