/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import org.apache.felix.scr.impl.helper.SimpleLogger;
import org.apache.felix.scr.impl.manager.ComponentContextImpl;
import org.apache.felix.scr.impl.manager.SingleRefPair;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SinglePrototypeRefPair<S, T>
extends SingleRefPair<S, T> {
    private final ServiceObjects<T> serviceObjects;

    public SinglePrototypeRefPair(BundleContext context, ServiceReference<T> ref) {
        super(ref);
        this.serviceObjects = context.getServiceObjects(ref);
    }

    @Override
    public ServiceObjects<T> getServiceObjects() {
        return this.serviceObjects;
    }

    @Override
    public String toString() {
        return "[SinglePrototypeRefPair: ref: [" + this.getRef() + "] service: [" + this.getServiceObject(null) + "]]";
    }

    @Override
    public boolean getServiceObject(ComponentContextImpl<S> key, BundleContext context, SimpleLogger logger) {
        Object service = key.getComponentServiceObjectsHelper().getPrototypeRefInstance(this.getRef(), this.serviceObjects);
        if (service == null) {
            this.setFailed();
            logger.log(2, "Could not get service from serviceobjects for ref {0}", new Object[]{this.getRef()}, null);
            return false;
        }
        if (!this.setServiceObject(key, service)) {
            this.serviceObjects.ungetService(service);
        }
        return true;
    }
}

