/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.felix.scr.impl.ComponentActorThread;
import org.apache.felix.scr.impl.ComponentRegistry;
import org.apache.felix.scr.impl.ComponentRegistryKey;
import org.apache.felix.scr.impl.helper.ConfigAdminTracker;
import org.apache.felix.scr.impl.helper.SimpleLogger;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.manager.ComponentActivator;
import org.apache.felix.scr.impl.manager.ComponentHolder;
import org.apache.felix.scr.impl.manager.DependencyManager;
import org.apache.felix.scr.impl.manager.ExtendedServiceEvent;
import org.apache.felix.scr.impl.manager.ExtendedServiceListener;
import org.apache.felix.scr.impl.manager.RegionConfigurationSupport;
import org.apache.felix.scr.impl.manager.ScrConfiguration;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.parser.KXml2SAXParser;
import org.apache.felix.scr.impl.xml.XmlHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentException;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class BundleComponentActivator
implements ComponentActivator {
    private final ComponentRegistry m_componentRegistry;
    private final Bundle m_bundle;
    private final BundleContext m_context;
    private final List<ComponentHolder<?>> m_holders = new ArrayList();
    private final ServiceTracker<LogService, LogService> m_logService;
    private final ComponentActorThread m_componentActor;
    private final AtomicBoolean m_active = new AtomicBoolean(true);
    private final CountDownLatch m_closeLatch = new CountDownLatch(1);
    private final ScrConfiguration m_configuration;
    private final ConfigAdminTracker configAdminTracker;
    private final Map<String, ListenerInfo> listenerMap = new HashMap<String, ListenerInfo>();
    private final SimpleLogger m_logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServiceListener(String classNameFilter, Filter eventFilter, ExtendedServiceListener<ExtendedServiceEvent> listener) {
        ListenerInfo listenerInfo;
        Map<String, ListenerInfo> map = this.listenerMap;
        synchronized (map) {
            this.log(4, "classNameFilter: " + classNameFilter + " event filter: " + eventFilter, null, null, null);
            listenerInfo = this.listenerMap.get(classNameFilter);
            if (listenerInfo == null) {
                listenerInfo = new ListenerInfo();
                this.listenerMap.put(classNameFilter, listenerInfo);
                try {
                    this.m_context.addServiceListener((ServiceListener)listenerInfo, classNameFilter);
                }
                catch (InvalidSyntaxException e) {
                    throw (IllegalArgumentException)new IllegalArgumentException("invalid class name filter").initCause(e);
                }
            }
        }
        listenerInfo.add(eventFilter, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServiceListener(String className, Filter filter, ExtendedServiceListener<ExtendedServiceEvent> listener) {
        Map<String, ListenerInfo> map = this.listenerMap;
        synchronized (map) {
            ListenerInfo listenerInfo = this.listenerMap.get(className);
            if (listenerInfo != null && listenerInfo.remove(filter, listener)) {
                this.listenerMap.remove(className);
                this.m_context.removeServiceListener((ServiceListener)listenerInfo);
            }
        }
    }

    public BundleComponentActivator(SimpleLogger logger, ComponentRegistry componentRegistry, ComponentActorThread componentActor, BundleContext context, ScrConfiguration configuration) throws ComponentException {
        this.m_logger = logger;
        this.m_componentRegistry = componentRegistry;
        this.m_componentActor = componentActor;
        this.m_context = context;
        this.m_bundle = context.getBundle();
        this.m_logService = new ServiceTracker(context, "org.osgi.service.log.LogService", null);
        this.m_logService.open();
        this.m_configuration = configuration;
        this.log(4, "BundleComponentActivator : Bundle [{0}] active", new Object[]{this.m_bundle.getBundleId()}, null, null, null);
        String descriptorLocations = (String)this.m_bundle.getHeaders().get("Service-Component");
        if (descriptorLocations == null) {
            throw new ComponentException("Service-Component entry not found in the manifest");
        }
        this.initialize(descriptorLocations);
        ConfigAdminTracker tracker = null;
        for (ComponentHolder<?> holder : this.m_holders) {
            if (holder.getComponentMetadata().isConfigurationIgnored()) continue;
            tracker = new ConfigAdminTracker(this);
            break;
        }
        this.configAdminTracker = tracker;
    }

    protected void initialize(String descriptorLocations) {
        this.log(4, "BundleComponentActivator : Bundle [{0}] descriptor locations {1}", new Object[]{this.m_bundle.getBundleId(), descriptorLocations}, null, null, null);
        StringTokenizer st = new StringTokenizer(descriptorLocations, ", ");
        while (st.hasMoreTokens()) {
            String descriptorLocation = st.nextToken();
            URL[] descriptorURLs = BundleComponentActivator.findDescriptors(this.m_bundle, descriptorLocation);
            if (descriptorURLs.length == 0) {
                this.log(1, "Component descriptor entry ''{0}'' not found", new Object[]{descriptorLocation}, null, null, null);
                continue;
            }
            for (URL descriptorURL : descriptorURLs) {
                this.loadDescriptor(descriptorURL);
            }
        }
    }

    void initialEnable() {
        for (ComponentHolder<?> componentHolder : this.m_holders) {
            this.log(4, "BundleComponentActivator : Bundle [{0}] May enable component holder {1}", new Object[]{this.m_bundle.getBundleId(), componentHolder.getComponentMetadata().getName()}, null, null, null);
            if (componentHolder.getComponentMetadata().isEnabled()) {
                this.log(4, "BundleComponentActivator : Bundle [{0}] Enabling component holder {1}", new Object[]{this.m_bundle.getBundleId(), componentHolder.getComponentMetadata().getName()}, null, null, null);
                try {
                    componentHolder.enableComponents(false);
                }
                catch (Throwable t) {
                    try {
                        componentHolder.disableComponents(false);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.log(1, "BundleComponentActivator : Bundle [{0}] Unexpected failure enabling component holder {1}", new Object[]{this.m_bundle.getBundleId(), componentHolder.getComponentMetadata().getName()}, null, null, t);
                }
                continue;
            }
            this.log(4, "BundleComponentActivator : Bundle [{0}] Will not enable component holder {1}", new Object[]{this.m_bundle.getBundleId(), componentHolder.getComponentMetadata().getName()}, null, null, null);
        }
    }

    static URL[] findDescriptors(Bundle bundle, String descriptorLocation) {
        String filePattern;
        String path;
        if (bundle == null || descriptorLocation == null || descriptorLocation.trim().length() == 0) {
            return new URL[0];
        }
        int lios = descriptorLocation.lastIndexOf("/");
        if (lios > 0) {
            path = descriptorLocation.substring(0, lios);
            filePattern = descriptorLocation.substring(lios + 1);
        } else {
            path = "/";
            filePattern = descriptorLocation;
        }
        Enumeration entries = bundle.findEntries(path, filePattern, false);
        if (entries == null || !entries.hasMoreElements()) {
            return new URL[0];
        }
        ArrayList urls = new ArrayList();
        while (entries.hasMoreElements()) {
            urls.add(entries.nextElement());
        }
        return urls.toArray(new URL[urls.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDescriptor(URL descriptorURL) {
        String descriptorLocation = descriptorURL.getPath();
        InputStream stream = null;
        try {
            stream = descriptorURL.openStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            XmlHandler handler = new XmlHandler(this.m_bundle, this, this.getConfiguration().isFactoryEnabled(), this.getConfiguration().keepInstances());
            KXml2SAXParser parser = new KXml2SAXParser(in);
            parser.parseXML(handler);
            Iterator<ComponentMetadata> iterator = handler.getComponentMetadataList().iterator();
            while (iterator.hasNext()) {
                ComponentMetadata o;
                ComponentMetadata metadata = o = iterator.next();
                ComponentRegistryKey key = null;
                try {
                    if (metadata.getName() != null) {
                        key = this.m_componentRegistry.checkComponentName(this.m_bundle, metadata.getName());
                    }
                    metadata.validate(this);
                    ComponentHolder holder = this.m_componentRegistry.createComponentHolder(this, metadata);
                    this.m_componentRegistry.registerComponentHolder(key, holder);
                    this.m_holders.add(holder);
                    this.log(4, "BundleComponentActivator : Bundle [{0}] ComponentHolder created for {1}", new Object[]{this.m_bundle.getBundleId(), metadata.getName()}, null, null, null);
                }
                catch (Throwable t) {
                    this.log(1, "Cannot register Component", metadata, null, t);
                    if (key == null) continue;
                    this.m_componentRegistry.unregisterComponentHolder(key);
                }
            }
        }
        catch (IOException ex) {
            this.log(1, "Problem reading descriptor entry ''{0}''", new Object[]{descriptorLocation}, null, null, ex);
        }
        catch (Exception ex) {
            this.log(1, "General problem with descriptor entry ''{0}''", new Object[]{descriptorLocation}, null, null, ex);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose(int reason) {
        if (this.m_active.compareAndSet(true, false)) {
            this.log(4, "BundleComponentActivator : Bundle [{0}] will destroy {1} instances", new Object[]{this.m_bundle.getBundleId(), this.m_holders.size()}, null, null, null);
            for (ComponentHolder<?> holder : this.m_holders) {
                try {
                    holder.disposeComponents(reason);
                }
                catch (Exception e) {
                    this.log(1, "BundleComponentActivator : Exception invalidating", holder.getComponentMetadata(), null, e);
                }
                finally {
                    this.m_componentRegistry.unregisterComponentHolder(this.m_bundle, holder.getComponentMetadata().getName());
                }
            }
            if (this.configAdminTracker != null) {
                this.configAdminTracker.dispose();
            }
            this.log(4, "BundleComponentActivator : Bundle [{0}] STOPPED", new Object[]{this.m_bundle.getBundleId()}, null, null, null);
            this.m_logService.close();
            this.m_closeLatch.countDown();
        } else {
            try {
                this.m_closeLatch.await(this.m_configuration.lockTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public boolean isActive() {
        return this.m_active.get();
    }

    @Override
    public BundleContext getBundleContext() {
        return this.m_context;
    }

    @Override
    public ScrConfiguration getConfiguration() {
        return this.m_configuration;
    }

    @Override
    public void enableComponent(String name) {
        List<ComponentHolder<?>> holder = this.getSelectedComponents(name);
        for (ComponentHolder<?> aHolder : holder) {
            try {
                this.log(4, "Enabling Component", aHolder.getComponentMetadata(), null, null);
                aHolder.enableComponents(true);
            }
            catch (Throwable t) {
                this.log(1, "Cannot enable component", aHolder.getComponentMetadata(), null, t);
            }
        }
    }

    @Override
    public void disableComponent(String name) {
        List<ComponentHolder<?>> holder = this.getSelectedComponents(name);
        for (ComponentHolder<?> aHolder : holder) {
            try {
                this.log(4, "Disabling Component", aHolder.getComponentMetadata(), null, null);
                aHolder.disableComponents(true);
            }
            catch (Throwable t) {
                this.log(1, "Cannot disable component", aHolder.getComponentMetadata(), null, t);
            }
        }
    }

    private List<ComponentHolder<?>> getSelectedComponents(String name) {
        if (name == null) {
            return this.m_holders;
        }
        ComponentHolder<?> componentHolder = this.m_componentRegistry.getComponentHolder(this.m_bundle, name);
        if (componentHolder != null) {
            return Collections.singletonList(componentHolder);
        }
        return Collections.emptyList();
    }

    @Override
    public long registerComponentId(AbstractComponentManager<?> componentManager) {
        return this.m_componentRegistry.registerComponentId(componentManager);
    }

    @Override
    public void unregisterComponentId(AbstractComponentManager<?> componentManager) {
        this.m_componentRegistry.unregisterComponentId(componentManager.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(Runnable task) {
        if (this.isActive()) {
            ComponentActorThread cat = this.m_componentActor;
            if (cat != null) {
                cat.schedule(task);
            } else {
                this.log(4, "Component Actor Thread not running, calling synchronously", null, null, null);
                try {
                    BundleComponentActivator bundleComponentActivator = this;
                    synchronized (bundleComponentActivator) {
                        task.run();
                    }
                }
                catch (Throwable t) {
                    this.log(2, "Unexpected problem executing task", null, null, t);
                }
            }
        } else {
            this.log(2, "BundleComponentActivator is not active; not scheduling {0}", new Object[]{task}, null, null, null);
        }
    }

    @Override
    public boolean isLogEnabled(int level) {
        return this.m_configuration.getLogLevel() >= level;
    }

    @Override
    public void log(int level, String pattern, Object[] arguments, ComponentMetadata metadata, Long componentId, Throwable ex) {
        if (this.isLogEnabled(level)) {
            String message = MessageFormat.format(pattern, arguments);
            this.log(level, message, metadata, componentId, ex);
        }
    }

    @Override
    public void log(int level, String message, ComponentMetadata metadata, Long componentId, Throwable ex) {
        if (this.isLogEnabled(level)) {
            ServiceTracker<LogService, LogService> logService;
            if (metadata != null) {
                message = componentId != null ? "[" + metadata.getName() + "(" + componentId + ")] " + message : "[" + metadata.getName() + "] " + message;
            }
            if ((logService = this.m_logService) != null) {
                Object logger = logService.getService();
                if (logger != null) {
                    Class<?> clazz = logger.getClass();
                    try {
                        Method method = clazz.getDeclaredMethod("log", Integer.class, String.class, Throwable.class);
                        method.invoke(logger, level, message, ex);
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.m_logger.log(level, message, ex);
            } else {
                this.m_logger.log(level, message, ex);
            }
        }
    }

    @Override
    public <T> boolean enterCreate(ServiceReference<T> serviceReference) {
        return this.m_componentRegistry.enterCreate(serviceReference);
    }

    @Override
    public <T> void leaveCreate(ServiceReference<T> serviceReference) {
        this.m_componentRegistry.leaveCreate(serviceReference);
    }

    @Override
    public <T> void missingServicePresent(ServiceReference<T> serviceReference) {
        this.m_componentRegistry.missingServicePresent(serviceReference, this.m_componentActor);
    }

    @Override
    public <S, T> void registerMissingDependency(DependencyManager<S, T> dependencyManager, ServiceReference<T> serviceReference, int trackingCount) {
        this.m_componentRegistry.registerMissingDependency(dependencyManager, serviceReference, trackingCount);
    }

    @Override
    public RegionConfigurationSupport setRegionConfigurationSupport(ServiceReference<ConfigurationAdmin> reference) {
        RegionConfigurationSupport rcs = this.m_componentRegistry.registerRegionConfigurationSupport(reference);
        for (ComponentHolder<?> holder : this.m_holders) {
            rcs.configureComponentHolder(holder);
        }
        return rcs;
    }

    @Override
    public void unsetRegionConfigurationSupport(RegionConfigurationSupport rcs) {
        this.m_componentRegistry.unregisterRegionConfigurationSupport(rcs);
    }

    private static class ListenerInfo
    implements ServiceListener {
        private Map<Filter, List<ExtendedServiceListener<ExtendedServiceEvent>>> filterMap = new HashMap<Filter, List<ExtendedServiceListener<ExtendedServiceEvent>>>();

        private ListenerInfo() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceChanged(ServiceEvent event) {
            Map<Filter, List<ExtendedServiceListener<ExtendedServiceEvent>>> filterMap;
            ServiceReference ref = event.getServiceReference();
            ExtendedServiceEvent extEvent = null;
            ExtendedServiceEvent endMatchEvent = null;
            ListenerInfo listenerInfo = this;
            synchronized (listenerInfo) {
                filterMap = this.filterMap;
            }
            for (Map.Entry entry : filterMap.entrySet()) {
                Filter filter = (Filter)entry.getKey();
                if (filter == null || filter.match(ref)) {
                    if (extEvent == null) {
                        extEvent = new ExtendedServiceEvent(event);
                    }
                    for (ExtendedServiceListener forwardTo : (List)entry.getValue()) {
                        forwardTo.serviceChanged(extEvent);
                    }
                    continue;
                }
                if (event.getType() != 2) continue;
                if (endMatchEvent == null) {
                    endMatchEvent = new ExtendedServiceEvent(8, ref);
                }
                for (ExtendedServiceListener forwardTo : (List)entry.getValue()) {
                    forwardTo.serviceChanged(endMatchEvent);
                }
            }
            if (extEvent != null) {
                extEvent.activateManagers();
            }
            if (endMatchEvent != null) {
                endMatchEvent.activateManagers();
            }
        }

        public synchronized void add(Filter filter, ExtendedServiceListener<ExtendedServiceEvent> listener) {
            this.filterMap = new HashMap<Filter, List<ExtendedServiceListener<ExtendedServiceEvent>>>(this.filterMap);
            List<ExtendedServiceListener<ExtendedServiceEvent>> listeners = this.filterMap.get(filter);
            if (listeners == null) {
                listeners = Collections.singletonList(listener);
            } else {
                listeners = new ArrayList<ExtendedServiceListener<ExtendedServiceEvent>>(listeners);
                listeners.add(listener);
            }
            this.filterMap.put(filter, listeners);
        }

        public synchronized boolean remove(Filter filter, ExtendedServiceListener<ExtendedServiceEvent> listener) {
            List<ExtendedServiceListener<ExtendedServiceEvent>> listeners = this.filterMap.get(filter);
            if (listeners != null) {
                this.filterMap = new HashMap<Filter, List<ExtendedServiceListener<ExtendedServiceEvent>>>(this.filterMap);
                listeners = new ArrayList<ExtendedServiceListener<ExtendedServiceEvent>>(listeners);
                listeners.remove(listener);
                if (listeners.isEmpty()) {
                    this.filterMap.remove(filter);
                } else {
                    this.filterMap.put(filter, listeners);
                }
            }
            return this.filterMap.isEmpty();
        }
    }
}

