/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.utils.version;

import java.util.WeakHashMap;
import org.apache.felix.utils.version.VersionCleaner;
import org.osgi.framework.Version;

public final class VersionTable {
    private static final WeakHashMap<String, Version> _versions = new WeakHashMap();

    public static Version getVersion(int major, int minor, int micro) {
        return VersionTable.getVersion(major, minor, micro, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version getVersion(int major, int minor, int micro, String qualifier) {
        String key = major + "." + minor + "." + micro;
        if (qualifier != null && qualifier.length() != 0) {
            key = key + "." + qualifier;
        }
        WeakHashMap<String, Version> weakHashMap = _versions;
        synchronized (weakHashMap) {
            Version version = _versions.get(key);
            if (version == null) {
                version = new Version(major, minor, micro, qualifier);
                _versions.put(key, version);
            }
            return version;
        }
    }

    public static Version getVersion(String version) {
        return VersionTable.getVersion(version, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version getVersion(String versionString, boolean clean) {
        if (clean) {
            versionString = VersionCleaner.clean(versionString);
        }
        WeakHashMap<String, Version> weakHashMap = _versions;
        synchronized (weakHashMap) {
            Version version = _versions.get(versionString);
            if (version == null) {
                version = Version.parseVersion((String)versionString);
                _versions.put(versionString, version);
            }
            return version;
        }
    }

    private VersionTable() {
    }
}

