/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.utils.version;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class VersionCleaner {
    private static final Pattern _fuzzyVersion = Pattern.compile("(\\d+)(\\.(\\d+)(\\.(\\d+))?)?([^a-zA-Z0-9](.*))?", 32);

    public static String clean(String version) {
        if (version == null || version.length() == 0) {
            return "0.0.0";
        }
        String clean = VersionCleaner._fastSyntax(version);
        if (clean != null) {
            return clean;
        }
        StringBuffer result = new StringBuffer();
        Matcher matcher = _fuzzyVersion.matcher(version);
        if (matcher.matches()) {
            String major = matcher.group(1);
            String minor = matcher.group(3);
            String micro = matcher.group(5);
            String qualifier = matcher.group(7);
            if (major != null) {
                result.append(major);
                if (minor != null) {
                    result.append(".");
                    result.append(minor);
                    if (micro != null) {
                        result.append(".");
                        result.append(micro);
                        if (qualifier != null) {
                            result.append(".");
                            VersionCleaner._cleanupModifier(result, qualifier);
                        }
                    } else if (qualifier != null) {
                        result.append(".0.");
                        VersionCleaner._cleanupModifier(result, qualifier);
                    } else {
                        result.append(".0");
                    }
                } else if (qualifier != null) {
                    result.append(".0.0.");
                    VersionCleaner._cleanupModifier(result, qualifier);
                } else {
                    result.append(".0.0");
                }
            }
        } else {
            result.append("0.0.0.");
            VersionCleaner._cleanupModifier(result, version);
        }
        return result.toString();
    }

    private static void _cleanupModifier(StringBuffer result, String modifier) {
        for (int i = 0; i < modifier.length(); ++i) {
            char c = modifier.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '-') {
                result.append(c);
                continue;
            }
            result.append('_');
        }
    }

    private static String _fastSyntax(String version) {
        int state = 0;
        int l = version.length();
        for (int i = 0; i < l; ++i) {
            char c = version.charAt(i);
            if (state == 0 || state == 2 || state == 4) {
                if (c < '0' || c > '9') {
                    return null;
                }
                ++state;
                continue;
            }
            if (state == 1 || state == 3 || state == 5) {
                if (c == '.') {
                    ++state;
                    continue;
                }
                if (c >= '0' && c <= '9') continue;
                return null;
            }
            if (state != 6 || c != '.') continue;
            return null;
        }
        if (state == 0 || state == 1) {
            return version + ".0.0";
        }
        if (state == 2 || state == 3) {
            return version + ".0";
        }
        return version;
    }
}

