/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.felix.cm.impl.Log;

public class UpdateThread
implements Runnable {
    private final ThreadGroup workerThreadGroup;
    private final String workerBaseName;
    private final BlockingDeque<Runnable> updateTasks = new LinkedBlockingDeque<Runnable>();
    private volatile Thread worker;
    private final AccessControlContext acc;

    public UpdateThread(ThreadGroup tg, String name) {
        this.workerThreadGroup = tg;
        this.workerBaseName = name;
        this.acc = AccessController.getContext();
    }

    @Override
    public void run() {
        try {
            Runnable task;
            while ((task = this.updateTasks.take()) != this) {
                try {
                    Thread.currentThread().setName(this.workerBaseName + " (" + task + ")");
                    Log.logger.log(4, "Running task {0}", new Object[]{task});
                    this.run0(task);
                }
                catch (Throwable t) {
                    Log.logger.log(1, "Unexpected problem executing task", t);
                }
                finally {
                    Thread.currentThread().setName(this.workerBaseName);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void run0(final Runnable task) throws Throwable {
        if (System.getSecurityManager() != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        task.run();
                        return null;
                    }
                }, this.acc);
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        } else {
            task.run();
        }
    }

    synchronized void start() {
        if (this.worker == null) {
            Thread workerThread = new Thread(this.workerThreadGroup, this, this.workerBaseName);
            workerThread.setDaemon(true);
            workerThread.start();
            this.worker = workerThread;
        }
    }

    synchronized void terminate() {
        if (this.worker != null) {
            Thread workerThread = this.worker;
            this.worker = null;
            this.updateTasks.offerFirst(this);
            try {
                workerThread.join(5000L);
                if (workerThread.isAlive()) {
                    Log.logger.log(1, "Worker thread {0} did not terminate within 5 seconds; trying to kill", new Object[]{this.workerBaseName});
                    workerThread.interrupt();
                }
            }
            catch (InterruptedException ie) {
                workerThread.interrupt();
            }
        }
    }

    void schedule(Runnable update) {
        Log.logger.log(4, "Scheduling task {0}", new Object[]{update});
        this.updateTasks.offer(update);
    }
}

