/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.spifly;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.aries.spifly.BundleDescriptor;
import org.apache.aries.spifly.ConsumerBundleTrackerCustomizer;
import org.apache.aries.spifly.ConsumerHeaderProcessor;
import org.apache.aries.spifly.ConsumerRestriction;
import org.apache.aries.spifly.Pair;
import org.apache.aries.spifly.ProviderBundleTrackerCustomizer;
import org.apache.aries.spifly.WeavingData;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public abstract class BaseActivator
implements BundleActivator {
    private static final Set<WeavingData> NON_WOVEN_BUNDLE = Collections.emptySet();
    private static final Logger logger = Logger.getLogger(BaseActivator.class.getName());
    public static BaseActivator activator;
    private BundleContext bundleContext;
    private BundleTracker consumerBundleTracker;
    private BundleTracker providerBundleTracker;
    private final ConcurrentMap<Bundle, Set<WeavingData>> bundleWeavingData = new ConcurrentHashMap<Bundle, Set<WeavingData>>();
    private final ConcurrentMap<String, SortedMap<Long, Pair<Bundle, Map<String, Object>>>> registeredProviders = new ConcurrentHashMap<String, SortedMap<Long, Pair<Bundle, Map<String, Object>>>>();
    private final ConcurrentMap<Bundle, Map<ConsumerRestriction, List<BundleDescriptor>>> consumerRestrictions = new ConcurrentHashMap<Bundle, Map<ConsumerRestriction, List<BundleDescriptor>>>();

    public synchronized void start(BundleContext context, String consumerHeaderName) throws Exception {
        this.bundleContext = context;
        this.providerBundleTracker = new BundleTracker(context, 32, (BundleTrackerCustomizer)new ProviderBundleTrackerCustomizer(this, context.getBundle()));
        this.providerBundleTracker.open();
        this.consumerBundleTracker = new BundleTracker(context, 60, (BundleTrackerCustomizer)new ConsumerBundleTrackerCustomizer(this, consumerHeaderName));
        this.consumerBundleTracker.open();
        for (Bundle bundle : context.getBundles()) {
            this.addConsumerWeavingData(bundle, consumerHeaderName);
        }
        activator = this;
    }

    public void addConsumerWeavingData(Bundle bundle, String consumerHeaderName) throws Exception {
        if (this.bundleWeavingData.containsKey(bundle)) {
            return;
        }
        HashMap<String, List<String>> allHeaders = new HashMap<String, List<String>>();
        if (consumerHeaderName != null) {
            allHeaders.put(consumerHeaderName, this.getAllHeaders(consumerHeaderName, bundle));
        }
        allHeaders.put("Require-Capability", this.getAllHeaders("Require-Capability", bundle));
        HashSet<WeavingData> wd = new HashSet<WeavingData>();
        for (Map.Entry entry : allHeaders.entrySet()) {
            String headerName = (String)entry.getKey();
            for (String headerVal : (List)entry.getValue()) {
                wd.addAll(ConsumerHeaderProcessor.processHeader(headerName, headerVal));
            }
        }
        if (!wd.isEmpty()) {
            this.bundleWeavingData.put(bundle, Collections.unmodifiableSet(wd));
            for (WeavingData w : wd) {
                this.registerConsumerBundle(bundle, w.getArgRestrictions(), w.getAllowedBundles());
            }
        } else {
            this.bundleWeavingData.put(bundle, NON_WOVEN_BUNDLE);
        }
    }

    private List<String> getAllHeaders(String headerName, Bundle bundle) {
        BundleWiring wiring;
        ArrayList<Bundle> bundlesFragments = new ArrayList<Bundle>();
        bundlesFragments.add(bundle);
        BundleRevision rev = (BundleRevision)bundle.adapt(BundleRevision.class);
        if (rev != null && (wiring = rev.getWiring()) != null) {
            for (BundleWire wire : wiring.getProvidedWires("osgi.wiring.host")) {
                bundlesFragments.add(wire.getRequirement().getRevision().getBundle());
            }
        }
        ArrayList<String> l = new ArrayList<String>();
        for (Bundle bf : bundlesFragments) {
            String header = (String)bf.getHeaders("").get(headerName);
            if (header == null) continue;
            l.add(header);
        }
        return l;
    }

    public void removeWeavingData(Bundle bundle) {
        this.bundleWeavingData.remove(bundle);
    }

    public synchronized void stop(BundleContext context) throws Exception {
        activator = null;
        this.consumerBundleTracker.close();
        this.providerBundleTracker.close();
    }

    public boolean isLogEnabled(Level level) {
        return logger.isLoggable(level);
    }

    public void log(int level, String message) {
        this.log(level, message, null);
    }

    public void log(Level level, String message) {
        this.log(level, message, null);
    }

    public void log(int level, String message, Throwable th) {
        Level levelObject = Level.ALL.intValue() == level ? Level.ALL : (Level.CONFIG.intValue() == level ? Level.CONFIG : (Level.FINE.intValue() == level ? Level.FINE : (Level.FINER.intValue() == level ? Level.FINER : (Level.FINEST.intValue() == level ? Level.FINEST : (Level.INFO.intValue() == level ? Level.INFO : (Level.SEVERE.intValue() == level ? Level.SEVERE : (Level.WARNING.intValue() == level ? Level.WARNING : Level.OFF)))))));
        this.log(levelObject, message, th);
    }

    public void log(Level level, String message, Throwable th) {
        logger.log(level, message, th);
    }

    public Set<WeavingData> getWeavingData(Bundle b) {
        Set wd = (Set)this.bundleWeavingData.get(b);
        if (wd == null) {
            return null;
        }
        if (wd.size() == 0) {
            return null;
        }
        return wd;
    }

    public void registerProviderBundle(String registrationClassName, Bundle bundle, Map<String, Object> customAttributes) {
        registrationClassName = registrationClassName.trim();
        this.registeredProviders.putIfAbsent(registrationClassName, Collections.synchronizedSortedMap(new TreeMap()));
        SortedMap map = (SortedMap)this.registeredProviders.get(registrationClassName);
        map.put(bundle.getBundleId(), new Pair<Bundle, Map<String, Object>>(bundle, customAttributes));
    }

    public void unregisterProviderBundle(Bundle bundle) {
        for (Map value : this.registeredProviders.values()) {
            Iterator it = value.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!((Bundle)((Pair)entry.getValue()).getLeft()).equals(bundle)) continue;
                it.remove();
            }
        }
    }

    public Collection<Bundle> findProviderBundles(String name) {
        SortedMap map = (SortedMap)this.registeredProviders.get(name);
        if (map == null) {
            return Collections.emptyList();
        }
        ArrayList<Bundle> bundles = new ArrayList<Bundle>(map.size());
        for (Pair value : map.values()) {
            bundles.add((Bundle)value.getLeft());
        }
        return bundles;
    }

    public Map<String, Object> getCustomBundleAttributes(String name, Bundle b) {
        SortedMap map = (SortedMap)this.registeredProviders.get(name);
        if (map == null) {
            return Collections.emptyMap();
        }
        Pair data = (Pair)map.get(b.getBundleId());
        if (data == null) {
            return Collections.emptyMap();
        }
        return (Map)data.getRight();
    }

    public void registerConsumerBundle(Bundle consumerBundle, Set<ConsumerRestriction> restrictions, List<BundleDescriptor> allowedBundles) {
        this.consumerRestrictions.putIfAbsent(consumerBundle, new HashMap());
        Map map = (Map)this.consumerRestrictions.get(consumerBundle);
        for (ConsumerRestriction restriction : restrictions) {
            map.put(restriction, allowedBundles);
        }
    }

    public Collection<Bundle> findConsumerRestrictions(Bundle consumer, String className, String methodName, Map<Pair<Integer, String>, String> args) {
        Map restrictions = (Map)this.consumerRestrictions.get(consumer);
        if (restrictions == null) {
            return null;
        }
        for (Map.Entry entry : restrictions.entrySet()) {
            if (!((ConsumerRestriction)entry.getKey()).matches(className, methodName, args)) continue;
            return this.getBundles((List)entry.getValue(), className, methodName, args);
        }
        return Collections.emptySet();
    }

    private Collection<Bundle> getBundles(List<BundleDescriptor> descriptors, String className, String methodName, Map<Pair<Integer, String>, String> args) {
        if (descriptors == null) {
            return null;
        }
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        for (Bundle b : this.bundleContext.getBundles()) {
            for (BundleDescriptor desc : descriptors) {
                if (desc.getBundleID() != -1L) {
                    if (b.getBundleId() != desc.getBundleID()) continue;
                    bundles.add(b);
                    continue;
                }
                if (desc.getFilter() != null) {
                    String type;
                    Hashtable<String, Object> d = new Hashtable<String, Object>();
                    if (ServiceLoader.class.getName().equals(className) && "load".equals(methodName) && (type = args.get(new Pair<Integer, String>(0, Class.class.getName()))) != null) {
                        d.put("osgi.serviceloader", type);
                        d.putAll(this.getCustomBundleAttributes(type, b));
                    }
                    if (!desc.getFilter().match(d)) continue;
                    bundles.add(b);
                    continue;
                }
                if (!b.getSymbolicName().equals(desc.getSymbolicName()) || desc.getVersion() != null && !b.getVersion().equals((Object)desc.getVersion())) continue;
                bundles.add(b);
            }
        }
        return bundles;
    }
}

