/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Writer;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.gradle.internal.hash.HashUtil;
import org.gradle.internal.hash.HashValue;
import org.gradle.internal.resource.metadata.DefaultExternalResourceMetaData;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transport.http.HttpClientHelper;
import org.gradle.internal.resource.transport.http.HttpClientResponse;
import org.gradle.internal.resource.transport.http.HttpResourceAccessor;
import org.gradle.internal.resource.transport.http.HttpResponseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiferayHttpResourceAccessor
extends HttpResourceAccessor {
    private static final String _FILES_CACHE_DIR_NAME = "caches/modules-2/files-2.1";
    private static final String[] _REPOSITORY_URL_PROPERTY_KEYS = new String[]{"repository.private.url", "repository.url"};
    private static final String[] _REPOSITORY_URLS = new String[]{"http://cdn.repository.liferay.com/nexus/content/groups/public/", "http://repository.liferay.com/nexus/content/groups/public/", "http://repository-cdn.liferay.com/nexus/content/groups/public/", "https://cdn.lfrs.sl/repository.liferay.com/nexus/content/groups/public/", "https://repository.liferay.com/nexus/content/groups/public/", "https://repository-cdn.liferay.com/nexus/content/groups/public/"};
    private static final Logger _logger = LoggerFactory.getLogger(LiferayHttpResourceAccessor.class);

    public LiferayHttpResourceAccessor(HttpClientHelper httpClientHelper) {
        super(httpClientHelper);
    }

    public ExternalResourceMetaData getMetaData(URI uri, boolean revalidate) {
        if (!this._isForcedCacheEnabled()) {
            return super.getMetaData(uri, revalidate);
        }
        String location = this._getLocation(uri);
        if (StringUtils.isBlank((String)location)) {
            return super.getMetaData(uri, revalidate);
        }
        File cachedArtifactFile = this._getCachedArtifactFile(location);
        if (cachedArtifactFile == null) {
            return super.getMetaData(uri, revalidate);
        }
        HashValue hashValue = HashUtil.sha1((File)cachedArtifactFile);
        return new DefaultExternalResourceMetaData(uri, cachedArtifactFile.lastModified(), cachedArtifactFile.length(), null, hashValue.asHexString(), hashValue);
    }

    public HttpResponseResource openResource(URI uri, boolean revalidate) {
        if (!this._isForcedCacheEnabled()) {
            return super.openResource(uri, revalidate);
        }
        String location = this._getLocation(uri);
        if (StringUtils.isBlank((String)location)) {
            return super.openResource(uri, revalidate);
        }
        HttpResponseResource httpResponseResource = null;
        try {
            if (StringUtils.endsWithIgnoreCase((String)location, (String)"/maven-metadata.xml")) {
                httpResponseResource = this._getMavenMetadataResponseResource(uri, location);
            } else if (StringUtils.endsWithIgnoreCase((String)location, (String)".sha1")) {
                httpResponseResource = this._getSHA1ResponseResource(uri, location);
            }
        }
        catch (Exception e) {
            _logger.error(e.getMessage(), (Throwable)e);
        }
        if (httpResponseResource == null) {
            httpResponseResource = super.openResource(uri, revalidate);
        }
        return httpResponseResource;
    }

    private File _fetchCachedFile(File dir, String fileName) {
        File cachedFile = null;
        Iterator iterator = FileUtils.iterateFiles((File)dir, (IOFileFilter)new NameFileFilter(fileName), (IOFileFilter)TrueFileFilter.TRUE);
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (cachedFile != null && cachedFile.lastModified() >= file.lastModified()) continue;
            cachedFile = file;
        }
        return cachedFile;
    }

    private File _getCachedArtifactFile(String location) {
        File cachedFile;
        Object[] tokens = StringUtils.split((String)location, (char)'/');
        String fileName = tokens[tokens.length - 1];
        String group = StringUtils.join((Object[])tokens, (char)'.', (int)0, (int)(tokens.length - 3));
        Object module = tokens[tokens.length - 3];
        Object version = tokens[tokens.length - 2];
        File moduleDir = new File(this._getGradleUserHome(), "caches/modules-2/files-2.1/" + group + "/" + (String)module);
        File artifactDir = new File(moduleDir, (String)version);
        if (!artifactDir.exists()) {
            if (!StringUtils.endsWithIgnoreCase((String)version, (String)"-SNAPSHOT") || !StringUtils.startsWithIgnoreCase((String)fileName, (String)((String)module + "-"))) {
                return null;
            }
            int pos = fileName.lastIndexOf(46);
            version = fileName.substring(((String)module).length() + 1, pos);
            artifactDir = new File(moduleDir, (String)version);
            if (!artifactDir.exists()) {
                return null;
            }
        }
        if ((cachedFile = this._fetchCachedFile(artifactDir, fileName)) == null) {
            cachedFile = this._fetchCachedFile(artifactDir, (String)module + "-" + (String)version + "." + FilenameUtils.getExtension((String)fileName));
        }
        return cachedFile;
    }

    private File _getGradleUserHome() {
        String gradleUserHome = System.getProperty("gradle.user.home");
        if (StringUtils.isBlank((String)gradleUserHome)) {
            gradleUserHome = System.getenv("GRADLE_USER_HOME");
        }
        if (StringUtils.isBlank((String)gradleUserHome)) {
            gradleUserHome = System.getProperty("user.home") + "/.gradle";
        }
        return new File(gradleUserHome);
    }

    private String _getLocation(URI uri) {
        String location = uri.toString();
        for (String repositoryUrl : _REPOSITORY_URLS) {
            if (!location.startsWith(repositoryUrl)) continue;
            return location.substring(repositoryUrl.length());
        }
        for (String key : _REPOSITORY_URL_PROPERTY_KEYS) {
            String repositoryUrl = System.getProperty(key);
            if (repositoryUrl == null || repositoryUrl.isEmpty()) continue;
            if (repositoryUrl.charAt(repositoryUrl.length() - 1) != '/') {
                repositoryUrl = repositoryUrl + '/';
            }
            if (!location.startsWith(repositoryUrl)) continue;
            return location.substring(repositoryUrl.length());
        }
        return null;
    }

    private HttpResponseResource _getMavenMetadataResponseResource(URI uri, String location) throws Exception {
        File artifactDir;
        Object[] tokens = StringUtils.split((String)location, (char)'/');
        String group = null;
        Object module = null;
        String version = tokens[tokens.length - 2];
        if (StringUtils.endsWithIgnoreCase((String)version, (String)"-SNAPSHOT")) {
            group = StringUtils.join((Object[])tokens, (char)'.', (int)0, (int)(tokens.length - 3));
            module = tokens[tokens.length - 3];
        } else {
            group = StringUtils.join((Object[])tokens, (char)'.', (int)0, (int)(tokens.length - 2));
            module = version;
            version = null;
        }
        File moduleDir = new File(this._getGradleUserHome(), "caches/modules-2/files-2.1/" + group + "/" + (String)module);
        if (!moduleDir.exists()) {
            return null;
        }
        if (StringUtils.isNotBlank((String)version) && !(artifactDir = new File(moduleDir, version)).exists()) {
            return null;
        }
        Metadata metadata = new Metadata();
        metadata.setArtifactId((String)module);
        metadata.setGroupId(group);
        Versioning versioning = new Versioning();
        if (StringUtils.isNotBlank((String)version)) {
            metadata.setVersion(version);
        } else {
            SortedSet<ComparableVersion> moduleVersions = this._getModuleVersions(moduleDir, false);
            for (ComparableVersion moduleVersion : moduleVersions) {
                versioning.addVersion(moduleVersion.toString());
            }
        }
        versioning.setLatest(this._getModuleLatestVersion(moduleDir, false));
        versioning.setRelease(this._getModuleLatestVersion(moduleDir, true));
        metadata.setVersioning(versioning);
        MetadataXpp3Writer metadataXpp3Writer = new MetadataXpp3Writer();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        metadataXpp3Writer.write((OutputStream)byteArrayOutputStream, metadata);
        BasicCloseableHttpResponse closeableHttpResponse = new BasicCloseableHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200, null));
        closeableHttpResponse.setEntity((HttpEntity)new ByteArrayEntity(byteArrayOutputStream.toByteArray(), ContentType.APPLICATION_XML));
        closeableHttpResponse.setHeader("Content-Length", String.valueOf(byteArrayOutputStream.size()));
        HttpClientResponse httpClientResponse = new HttpClientResponse("GET", uri, (CloseableHttpResponse)closeableHttpResponse);
        return new HttpResponseResource("GET", uri, httpClientResponse);
    }

    private String _getModuleLatestVersion(File moduleDir, boolean excludeSnapshots) {
        SortedSet<ComparableVersion> moduleVersions = this._getModuleVersions(moduleDir, excludeSnapshots);
        if (moduleVersions.isEmpty()) {
            return null;
        }
        ComparableVersion moduleVersion = moduleVersions.last();
        return moduleVersion.toString();
    }

    private SortedSet<ComparableVersion> _getModuleVersions(File moduleDir, boolean excludeSnapshots) {
        String[] versions;
        TreeSet<ComparableVersion> moduleVersions = new TreeSet<ComparableVersion>();
        for (String version : versions = moduleDir.list((FilenameFilter)DirectoryFileFilter.DIRECTORY)) {
            if (excludeSnapshots && StringUtils.endsWithIgnoreCase((String)version, (String)"-SNAPSHOT")) continue;
            moduleVersions.add(new ComparableVersion(version));
        }
        return moduleVersions;
    }

    private HttpResponseResource _getSHA1ResponseResource(URI uri, String location) throws Exception {
        File cachedArtifactFile = this._getCachedArtifactFile(location = location.substring(0, location.length() - 5));
        if (cachedArtifactFile == null) {
            return null;
        }
        HashValue hashValue = HashUtil.sha1((File)cachedArtifactFile);
        String sha1 = hashValue.asHexString();
        BasicCloseableHttpResponse closeableHttpResponse = new BasicCloseableHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200, null));
        closeableHttpResponse.setEntity((HttpEntity)new StringEntity(sha1));
        closeableHttpResponse.setHeader("Content-Length", String.valueOf(sha1.length()));
        closeableHttpResponse.setHeader("Last-Modified", String.valueOf(cachedArtifactFile.lastModified()));
        HttpClientResponse httpClientResponse = new HttpClientResponse("GET", uri, (CloseableHttpResponse)closeableHttpResponse);
        return new HttpResponseResource("GET", uri, httpClientResponse);
    }

    private boolean _isForcedCacheEnabled() {
        return Boolean.getBoolean("forced.cache.enabled");
    }

    private static class BasicCloseableHttpResponse
    extends BasicHttpResponse
    implements CloseableHttpResponse {
        public BasicCloseableHttpResponse(StatusLine statusLine) {
            super(statusLine);
        }

        public void close() throws IOException {
        }
    }
}

