/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import org.gradle.internal.resource.connector.ResourceConnectorSpecification;
import org.gradle.internal.resource.transfer.DefaultExternalResourceConnector;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ExternalResourceConnector;
import org.gradle.internal.resource.transfer.ExternalResourceLister;
import org.gradle.internal.resource.transfer.ExternalResourceUploader;
import org.gradle.internal.resource.transport.http.DefaultHttpSettings;
import org.gradle.internal.resource.transport.http.HttpClientHelper;
import org.gradle.internal.resource.transport.http.HttpConnectorFactory;
import org.gradle.internal.resource.transport.http.HttpResourceAccessor;
import org.gradle.internal.resource.transport.http.HttpResourceLister;
import org.gradle.internal.resource.transport.http.HttpResourceUploader;
import org.gradle.internal.resource.transport.http.HttpSettings;
import org.gradle.internal.resource.transport.http.LiferayHttpResourceAccessor;
import org.gradle.internal.resource.transport.http.SslContextFactory;

public class LiferayHttpConnectorFactory
extends HttpConnectorFactory {
    private final SslContextFactory _sslContextFactory;

    public LiferayHttpConnectorFactory(SslContextFactory sslContextFactory) {
        super(sslContextFactory);
        this._sslContextFactory = sslContextFactory;
    }

    public ExternalResourceConnector createResourceConnector(ResourceConnectorSpecification resourceConnectorSpecification) {
        DefaultHttpSettings.Builder builder = DefaultHttpSettings.builder();
        builder.withAuthenticationSettings(resourceConnectorSpecification.getAuthentications());
        builder.withSslContextFactory(this._sslContextFactory);
        HttpSettings httpSettings = builder.build();
        HttpClientHelper httpClientHelper = new HttpClientHelper(httpSettings);
        LiferayHttpResourceAccessor httpResourceAccessor = new LiferayHttpResourceAccessor(httpClientHelper);
        HttpResourceLister httpResourceLister = new HttpResourceLister((HttpResourceAccessor)httpResourceAccessor);
        HttpResourceUploader httpResourceUploader = new HttpResourceUploader(httpClientHelper);
        return new DefaultExternalResourceConnector((ExternalResourceAccessor)httpResourceAccessor, (ExternalResourceLister)httpResourceLister, (ExternalResourceUploader)httpResourceUploader);
    }
}

