/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.fcm;

import com.liferay.mobile.fcm.Message;
import com.liferay.mobile.fcm.Status;
import com.liferay.mobile.fcm.StatusFactory;
import com.liferay.mobile.fcm.json.Json;
import java.io.Reader;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class Sender {
    public static final String AUTHORIZATION = "Authorization";
    public static final String URL = "https://fcm.googleapis.com/fcm/send";
    protected final OkHttpClient client;
    protected final MediaType contentType = MediaType.parse((String)"application/json");
    protected final String key;
    protected StatusFactory statusFactory = new StatusFactory();
    protected final String url;

    public Sender(String key) {
        this(key, URL);
    }

    public Status send(Message message) throws Exception {
        Request request = this.createRequest(message);
        Response response = this.client.newCall(request).execute();
        Reader body = response.body().charStream();
        Status status = this.statusFactory.createStatus(message, body);
        status.httpResponse(response);
        return status;
    }

    public String key() {
        return this.key;
    }

    public String url() {
        return this.url;
    }

    protected Sender(String key, String url) {
        this.client = new OkHttpClient();
        this.key = key;
        this.url = url;
    }

    protected Request createRequest(Message message) {
        RequestBody body = RequestBody.create((MediaType)this.contentType, (String)Json.toJson(message));
        return new Request.Builder().url(this.url).header(AUTHORIZATION, "key=" + this.key).post(body).build();
    }
}

