/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.fcm;

import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Notification {
    protected final String badge;
    protected final String body;
    @SerializedName(value="body_loc_key")
    protected final String bodyLocalizationKey;
    @SerializedName(value="body_loc_args")
    protected final List<String> bodyLocalizationArguments;
    @SerializedName(value="click_action")
    protected final String clickAction;
    protected final String color;
    protected final String icon;
    protected final String sound;
    protected final String tag;
    protected final String title;
    @SerializedName(value="title_loc_key")
    protected final String titleLocalizationKey;
    @SerializedName(value="title_loc_args")
    protected final List<String> titleLocalizationArguments;

    public String badge() {
        return this.badge;
    }

    public String body() {
        return this.body;
    }

    public String bodyLocalizationKey() {
        return this.bodyLocalizationKey;
    }

    public List<String> bodyLocalizationArguments() {
        return this.bodyLocalizationArguments;
    }

    public String clickAction() {
        return this.clickAction;
    }

    public String color() {
        return this.color;
    }

    public String icon() {
        return this.icon;
    }

    public String sound() {
        return this.sound;
    }

    public String tag() {
        return this.tag;
    }

    public String title() {
        return this.title;
    }

    public String titleLocalizationKey() {
        return this.titleLocalizationKey;
    }

    public List<String> titleLocalizationArguments() {
        return this.titleLocalizationArguments;
    }

    protected Notification(Builder builder) {
        this.badge = builder.badge;
        this.body = builder.body;
        this.bodyLocalizationKey = builder.bodyLocalizationKey;
        this.bodyLocalizationArguments = builder.bodyLocalizationArguments;
        this.clickAction = builder.clickAction;
        this.color = builder.color;
        this.icon = builder.icon;
        this.sound = builder.sound;
        this.tag = builder.tag;
        this.title = builder.title;
        this.titleLocalizationKey = builder.titleLocalizationKey;
        this.titleLocalizationArguments = builder.titleLocalizationArguments;
    }

    public static class Builder {
        String badge;
        String body;
        String bodyLocalizationKey;
        List<String> bodyLocalizationArguments;
        String clickAction;
        String color;
        String icon;
        String sound;
        String tag;
        String title;
        String titleLocalizationKey;
        List<String> titleLocalizationArguments;

        public Builder badge(int badge) {
            this.badge = String.valueOf(badge);
            return this;
        }

        public Builder body(String body) {
            this.body = body;
            return this;
        }

        public Builder bodyLocalizationKey(String bodyLocalizationKey) {
            this.bodyLocalizationKey = bodyLocalizationKey;
            return this;
        }

        public Builder bodyLocalizationArguments(String ... bodyLocalizationArguments) {
            return this.bodyLocalizationArguments(Arrays.asList(bodyLocalizationArguments));
        }

        public Builder bodyLocalizationArguments(List<String> bodyLocalizationArguments) {
            this.bodyLocalizationArguments = Collections.unmodifiableList(bodyLocalizationArguments);
            return this;
        }

        public Builder clickAction(String clickAction) {
            this.clickAction = clickAction;
            return this;
        }

        public Builder color(String color) {
            this.color = color;
            return this;
        }

        public Builder icon(String icon) {
            this.icon = icon;
            return this;
        }

        public Builder sound(String sound) {
            this.sound = sound;
            return this;
        }

        public Builder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder titleLocalizationKey(String titleLocalizationKey) {
            this.titleLocalizationKey = titleLocalizationKey;
            return this;
        }

        public Builder titleLocalizationArguments(String ... titleLocalizationArguments) {
            return this.titleLocalizationArguments(Arrays.asList(titleLocalizationArguments));
        }

        public Builder titleLocalizationArguments(List<String> titleLocalizationArguments) {
            this.titleLocalizationArguments = Collections.unmodifiableList(titleLocalizationArguments);
            return this;
        }

        public Notification build() {
            return new Notification(this);
        }
    }
}

