/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.fcm;

import com.google.gson.annotations.SerializedName;
import com.liferay.mobile.fcm.Condition;
import com.liferay.mobile.fcm.Notification;
import com.liferay.mobile.fcm.Topic;
import com.liferay.mobile.fcm.exception.ExceededTimeToLive;
import com.liferay.mobile.fcm.exception.IllegalNumberOfTokens;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Message {
    @SerializedName(value="collapse_key")
    protected final String collapseKey;
    protected final String condition;
    @SerializedName(value="content_available")
    protected final Boolean contentAvailable;
    protected final Object data;
    @SerializedName(value="dry_run")
    protected final Boolean dryRun;
    @SerializedName(value="registration_ids")
    protected final List<String> multicast;
    protected final Notification notification;
    protected final Priority priority;
    @SerializedName(value="restricted_package_name")
    protected final String restrictedPackageName;
    @SerializedName(value="time_to_live")
    protected final Integer timeToLive;
    protected final String to;

    public String collapseKey() {
        return this.collapseKey;
    }

    public String condition() {
        return this.condition;
    }

    public boolean contentAvailable() {
        if (this.contentAvailable == null) {
            return false;
        }
        return this.contentAvailable;
    }

    public Object data() {
        return this.data;
    }

    public boolean dryRun() {
        if (this.dryRun == null) {
            return false;
        }
        return this.dryRun;
    }

    public List<String> multicast() {
        return this.multicast;
    }

    public Notification notification() {
        return this.notification;
    }

    public Priority priority() {
        return this.priority;
    }

    public String restrictedPackageName() {
        return this.restrictedPackageName;
    }

    public String to() {
        return this.to;
    }

    public int timeToLive() {
        if (this.timeToLive == null) {
            return 0;
        }
        return this.timeToLive;
    }

    protected Message(Builder builder) {
        this.collapseKey = builder.collapseKey;
        this.condition = builder.condition;
        this.contentAvailable = builder.contentAvailable;
        this.data = builder.data;
        this.dryRun = builder.dryRun;
        this.multicast = builder.multicast;
        this.notification = builder.notification;
        this.priority = builder.priority;
        this.restrictedPackageName = builder.restrictedPackageName;
        this.to = builder.to;
        this.timeToLive = builder.timeToLive;
    }

    public static class Builder {
        String collapseKey;
        String condition;
        Boolean contentAvailable;
        Object data;
        Boolean dryRun;
        List<String> multicast;
        Notification notification;
        Priority priority;
        String restrictedPackageName;
        Integer timeToLive;
        String to;

        public Builder collapseKey(String collapseKey) {
            this.collapseKey = collapseKey;
            return this;
        }

        public Builder condition(Condition condition) {
            return this.condition(condition.condition());
        }

        public Builder condition(String condition) {
            this.condition = condition;
            return this;
        }

        public Builder contentAvailable(boolean contentAvailable) {
            this.contentAvailable = contentAvailable;
            return this;
        }

        public Builder data(Object data) {
            this.data = data;
            return this;
        }

        public Builder dryRun(boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public Builder priority(Priority priority) {
            this.priority = priority;
            return this;
        }

        public Builder restrictedPackageName(String restrictedPackageName) {
            this.restrictedPackageName = restrictedPackageName;
            return this;
        }

        public Builder to(Topic topic) {
            this.to(topic.path());
            return this;
        }

        public Builder to(String ... tokens) {
            if (tokens.length == 1) {
                this.to = tokens[0];
            } else {
                this.to(Arrays.asList(tokens));
            }
            return this;
        }

        public Builder to(List<String> tokens) {
            if (tokens.size() == 0 || tokens.size() > 1000) {
                throw new IllegalNumberOfTokens(tokens);
            }
            this.multicast = Collections.unmodifiableList(tokens);
            return this;
        }

        public Builder timeToLive(int timeToLive, TimeUnit unit) throws ExceededTimeToLive {
            long max;
            long duration = unit.toSeconds(timeToLive);
            if (duration > (max = TimeUnit.DAYS.toSeconds(28L))) {
                throw new ExceededTimeToLive(duration);
            }
            this.timeToLive = (int)duration;
            return this;
        }

        public Message build() {
            return new Message(this);
        }
    }

    public static enum Priority {
        NORMAL,
        HIGH;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

