/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gs.testFramework.core;

import com.liferay.gs.testFramework.core.ConfigurationOS;
import com.liferay.gs.testFramework.core.ReadProperties;
import java.io.File;

public class SeleniumReadPropertyKeys {
    public static int getNumberOfBrowserInParallel() {
        return Integer.parseInt(ReadProperties.getConfigurationOfPropertiesFile("number-of-browser-in-parallel", "4"));
    }

    public static int getNumberOfFailedTestsRetryTestExecution() {
        return Integer.parseInt(ReadProperties.getConfigurationOfPropertiesFile("number-of-failed-tests-retry-test-execution", "3"));
    }

    public static int getTimeOut() {
        return Integer.parseInt(ReadProperties.getConfigurationOfPropertiesFile("time-out", "10"));
    }

    public static String getDefaultPlatformName() {
        return ReadProperties.getConfigurationOfPropertiesFile("browser", "defaultGCHeadless");
    }

    public static String getUrlToHome() {
        return ReadProperties.getConfigurationOfPropertiesFile("environment", "http://localhost:8080");
    }

    public static String getDefaultUsername() {
        return ReadProperties.getConfigurationOfPropertiesFile("username", "test@liferay.com");
    }

    public static String getDefaultPassword() {
        return ReadProperties.getConfigurationOfPropertiesFile("password", "test");
    }

    public static String getLinkToLogOut() {
        return ReadProperties.getConfigurationOfPropertiesFile("link-to-logout", "/c/portal/logout");
    }

    public static String getDownloadSaveFilePath() {
        return ReadProperties.getConfigurationOfPropertiesFile("download-save-file-path", "default");
    }

    public static String getGeckoDriverPath() {
        String localPropertiesFile = System.getProperty("os.name").toLowerCase().contains("windows") ? "/SeleniumProperties/geckodriver.exe" : "/SeleniumProperties/geckodriver";
        File localFile = new File(SeleniumReadPropertyKeys.getProjectPath() + localPropertiesFile);
        String GECKODRIVER_PATH = localFile.exists() ? SeleniumReadPropertyKeys.getProjectPath() + localPropertiesFile : ConfigurationOS.getString("GeckoDriver_Path");
        return GECKODRIVER_PATH;
    }

    public static String getChromeDriverPath() {
        String localPropertiesFile = System.getProperty("os.name").toLowerCase().contains("windows") ? "/SeleniumProperties/chromedriver.exe" : "/SeleniumProperties/chromedriver";
        File localFile = new File(SeleniumReadPropertyKeys.getProjectPath() + localPropertiesFile);
        String CHROMEDRIVER_PATH = localFile.exists() ? SeleniumReadPropertyKeys.getProjectPath() + localPropertiesFile : ConfigurationOS.getString("ChromeDriver_Path");
        return CHROMEDRIVER_PATH;
    }

    public static String getSeleniumPropertyKeysFilePath() {
        String localPropertiesFile = "/SeleniumProperties/SeleniumPropertyKeys.properties";
        File localFile = new File(SeleniumReadPropertyKeys.getProjectPath() + localPropertiesFile);
        String DEFAULT_PROPERTIES_FILE_PATH = localFile.exists() ? SeleniumReadPropertyKeys.getProjectPath() + localPropertiesFile : ConfigurationOS.getString("SeleniumPropertyKeys");
        return DEFAULT_PROPERTIES_FILE_PATH;
    }

    private static String getProjectPath() {
        return System.getProperty("user.dir");
    }
}

