/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.osgi.internal;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.osgi.internal.OSGiEnvironment;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public final class FacesBundleUtil {
    private static final Logger logger;
    private static final boolean CURRENT_BUNDLE_DETECTED;
    private static final Long OSGI_FRAMEWORK_BUNDLE_ID;

    private FacesBundleUtil() {
        throw new AssertionError();
    }

    public static Collection<Bundle> getFacesBundles(Object context) {
        Map<Long, Object> facesBundles = null;
        if (CURRENT_BUNDLE_DETECTED && (facesBundles = (HashMap<Long, Bundle>)FacesBundleUtil.getServletContextAttribute(context, FacesBundleUtil.class.getName())) == null) {
            facesBundles = new HashMap<Long, Bundle>();
            Bundle wabBundle = FacesBundleUtil.getCurrentFacesWab(context);
            if (wabBundle != null) {
                if (!FacesBundleUtil.isCurrentBundleThickWab()) {
                    FacesBundleUtil.addRequiredBundlesRecurse(facesBundles, wabBundle);
                }
                facesBundles = Collections.unmodifiableMap(facesBundles);
                FacesBundleUtil.setServletContextAttribute(context, FacesBundleUtil.class.getName(), facesBundles);
            }
        }
        if (facesBundles == null) {
            facesBundles = Collections.emptyMap();
        }
        return facesBundles.values();
    }

    public static ClassLoader getFacesBundleWiringClassLoader(Bundle facesBundle) {
        BundleWiring bundleWiring;
        ClassLoader classLoader = null;
        if (facesBundle != null && (bundleWiring = (BundleWiring)facesBundle.adapt(BundleWiring.class)) != null) {
            classLoader = bundleWiring.getClassLoader();
        }
        return classLoader;
    }

    public static boolean isCurrentWarThinWab() {
        return CURRENT_BUNDLE_DETECTED && !FacesBundleUtil.isCurrentBundleThickWab();
    }

    public static boolean isWab(Bundle bundle) {
        String webContextPathHeader = null;
        if (bundle != null) {
            Dictionary headers = bundle.getHeaders();
            webContextPathHeader = (String)headers.get("Web-ContextPath");
        }
        return webContextPathHeader != null;
    }

    static Bundle getCurrentFacesWab(Object context) {
        BundleContext bundleContext = (BundleContext)FacesBundleUtil.getServletContextAttribute(context, "osgi-bundlecontext");
        Bundle bundle = null;
        if (bundleContext != null) {
            try {
                bundle = bundleContext.getBundle();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return bundle;
    }

    private static void addRequiredBundlesRecurse(Map<Long, Bundle> facesBundles, Bundle bundle) {
        List bundleWires;
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (bundleWiring != null && (bundleWires = bundleWiring.getRequiredWires("osgi.wiring.package")) != null) {
            for (BundleWire bundleWire : bundleWires) {
                Bundle providerBundle;
                Long key;
                BundleRevision provider = bundleWire.getProvider();
                if (provider == null || OSGI_FRAMEWORK_BUNDLE_ID.equals(key = Long.valueOf((providerBundle = provider.getBundle()).getBundleId())) || facesBundles.containsKey(key) || FacesBundleUtil.isIgnoredBundle(providerBundle.getSymbolicName()) || FacesBundleUtil.isFacesLibraryBundle(key) && FacesBundleUtil.isDynamicDependency(bundleWire)) continue;
                logger.debug("JSF module dependency: [{0}]", providerBundle.getSymbolicName());
                facesBundles.put(key, providerBundle);
                String symbolicName = bundle.getSymbolicName();
                if (FacesBundleUtil.isBridgeBundle(symbolicName, "impl")) {
                    Map<Long, Bundle> bridgeImplBundles = FacesBundleUtil.getBridgeImplBundles(providerBundle);
                    Set<Long> bridgeImplBundleKeys = bridgeImplBundles.keySet();
                    for (Long bridgeImplBundleKey : bridgeImplBundleKeys) {
                        Bundle bridgeImplBundle = bridgeImplBundles.get(bridgeImplBundleKey);
                        facesBundles.put(bridgeImplBundleKey, bridgeImplBundle);
                        FacesBundleUtil.addRequiredBundlesRecurse(facesBundles, bridgeImplBundle);
                    }
                }
                FacesBundleUtil.addRequiredBundlesRecurse(facesBundles, providerBundle);
            }
        }
    }

    private static String getBridgeBundleSymbolicName(String bundleSymbolicNameSuffix) {
        return "com.liferay.faces.bridge." + bundleSymbolicNameSuffix;
    }

    private static Map<Long, Bundle> getBridgeImplBundles(Bundle bridgeAPIBundle) {
        List bundleWires;
        TreeMap<Long, Bundle> bridgeImplBundles = new TreeMap<Long, Bundle>();
        BundleWiring bundleWiring = (BundleWiring)bridgeAPIBundle.adapt(BundleWiring.class);
        if (bundleWiring != null && (bundleWires = bundleWiring.getProvidedWires("osgi.wiring.package")) != null) {
            boolean bridgeImplFound = false;
            boolean bridgeExtFound = false;
            for (BundleWire bundleWire : bundleWires) {
                Bundle bundleDependingOnBridgeAPI = bundleWire.getRequirer().getBundle();
                String symbolicName = bundleDependingOnBridgeAPI.getSymbolicName();
                boolean bridgeImpl = FacesBundleUtil.isBridgeBundle(symbolicName, "impl");
                boolean bridgeExt = FacesBundleUtil.isBridgeBundle(symbolicName, "ext");
                if (!bridgeImpl && !bridgeExt) continue;
                bridgeImplBundles.putIfAbsent(bundleDependingOnBridgeAPI.getBundleId(), bundleDependingOnBridgeAPI);
                if (!bridgeExtFound) {
                    bridgeExtFound = bridgeExt;
                }
                if (!bridgeImplFound) {
                    bridgeImplFound = bridgeImpl;
                }
                if (!bridgeImplFound || !bridgeExtFound) continue;
                break;
            }
        }
        return Collections.unmodifiableMap(bridgeImplBundles);
    }

    private static Object getServletContextAttribute(Object context, String servletContextAttributeName) {
        Object servletContextAttributeValue = null;
        boolean isFacesContext = context instanceof FacesContext;
        if (isFacesContext || context instanceof ExternalContext) {
            ExternalContext externalContext;
            if (isFacesContext) {
                FacesContext facesContext = (FacesContext)context;
                externalContext = facesContext.getExternalContext();
            } else {
                externalContext = (ExternalContext)context;
            }
            Map applicationMap = externalContext.getApplicationMap();
            servletContextAttributeValue = applicationMap.get(servletContextAttributeName);
        } else if (context instanceof ServletContext) {
            ServletContext servletContext = (ServletContext)context;
            servletContextAttributeValue = servletContext.getAttribute(servletContextAttributeName);
        } else if (context instanceof Map) {
            Map applicationMap = (Map)context;
            servletContextAttributeValue = applicationMap.get(servletContextAttributeName);
        } else {
            FacesBundleUtil.throwIllegalContextClassException(context);
        }
        return servletContextAttributeValue;
    }

    private static boolean isBridgeBundle(String symbolicName, String bundleSymbolicNameSuffix) {
        String bridgeBundleSymbolicName = FacesBundleUtil.getBridgeBundleSymbolicName(bundleSymbolicNameSuffix);
        return symbolicName.equals(bridgeBundleSymbolicName);
    }

    private static boolean isCurrentBundleThickWab() {
        Bundle bundle = FrameworkUtil.getBundle(FacesBundleUtil.class);
        return FacesBundleUtil.isWab(bundle);
    }

    private static boolean isDynamicDependency(BundleWire bundleWire) {
        boolean dynamicDependency = false;
        BundleRequirement requirement = bundleWire.getRequirement();
        if (requirement != null) {
            Map directives = requirement.getDirectives();
            String resolution = (String)directives.get("resolution");
            dynamicDependency = "dynamic".equalsIgnoreCase(resolution);
        }
        return dynamicDependency;
    }

    private static boolean isFacesLibraryBundle(Long key) {
        return key < 0L;
    }

    private static boolean isIgnoredBundle(String symbolicName) {
        return symbolicName.startsWith("com.liferay.portal") || symbolicName.startsWith("com.liferay.util") || symbolicName.equals("com.sun.el.javax.el") || symbolicName.startsWith("jboss-classfilewriter") || symbolicName.startsWith("javax.servlet") || symbolicName.startsWith("javax.validation") || symbolicName.startsWith("org.apache.commons") || symbolicName.startsWith("org.apache.felix") || symbolicName.startsWith("org.apache.geronimo.specs") || symbolicName.startsWith("org.jboss.logging") || symbolicName.startsWith("org.jboss.weld") || symbolicName.startsWith("org.jsoup") || symbolicName.startsWith("org.osgi");
    }

    private static void setServletContextAttribute(Object context, String servletContextAttributeName, Object servletContextAttributeValue) {
        boolean isFacesContext = context instanceof FacesContext;
        if (isFacesContext || context instanceof ExternalContext) {
            ExternalContext externalContext;
            if (isFacesContext) {
                FacesContext facesContext = (FacesContext)context;
                externalContext = facesContext.getExternalContext();
            } else {
                externalContext = (ExternalContext)context;
            }
            Map applicationMap = externalContext.getApplicationMap();
            applicationMap.put(servletContextAttributeName, servletContextAttributeValue);
        } else if (context instanceof ServletContext) {
            ServletContext servletContext = (ServletContext)context;
            servletContext.setAttribute(servletContextAttributeName, servletContextAttributeValue);
        } else if (context instanceof Map) {
            Map applicationMap = (Map)context;
            applicationMap.put(servletContextAttributeName, servletContextAttributeValue);
        } else {
            FacesBundleUtil.throwIllegalContextClassException(context);
        }
    }

    private static void throwIllegalContextClassException(Object context) throws IllegalArgumentException {
        String contextClassName = "null";
        if (context != null) {
            contextClassName = context.getClass().getName();
        }
        throw new IllegalArgumentException("context [" + contextClassName + "] is not an instance of " + FacesContext.class.getName() + " or " + ExternalContext.class.getName() + " or " + ServletContext.class.getName());
    }

    static {
        Bundle currentBundle;
        logger = LoggerFactory.getLogger(FacesBundleUtil.class);
        OSGI_FRAMEWORK_BUNDLE_ID = 0L;
        boolean currentBundleDetected = false;
        if (OSGiEnvironment.isApiDetected() && (currentBundle = FrameworkUtil.getBundle(FacesBundleUtil.class)) != null) {
            currentBundleDetected = true;
        }
        CURRENT_BUNDLE_DETECTED = currentBundleDetected;
    }
}

