/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.model.internal;

import com.liferay.faces.util.internal.CloseableUtil;
import com.liferay.faces.util.model.UploadedFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class UploadedFileImpl
implements Serializable,
UploadedFile {
    private static final long serialVersionUID = 3983489321274295576L;
    private String absolutePath;
    private Map<String, Object> attributeMap;
    private String charSet;
    private String contentType;
    private String id;
    private Map<String, List<String>> headersMap;
    private String message;
    private String name;
    private long size;
    private UploadedFile.Status status;

    public UploadedFileImpl(String absolutePath, Map<String, Object> attributeMap, String charSet, String contentType, Map<String, List<String>> headersMap, String id, String message, String name, long size, UploadedFile.Status status) {
        this.absolutePath = absolutePath;
        this.attributeMap = attributeMap;
        this.charSet = charSet;
        this.contentType = contentType;
        this.id = id;
        this.headersMap = headersMap;
        this.message = message;
        this.name = name;
        this.size = size;
        this.status = status;
    }

    @Override
    public void delete() throws IOException {
        if (this.absolutePath != null) {
            File file = new File(this.absolutePath);
            file.delete();
        }
    }

    @Override
    public String getAbsolutePath() {
        return this.absolutePath;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributeMap;
    }

    @Override
    public byte[] getBytes() throws IOException {
        RandomAccessFile randomAccessFile = null;
        byte[] bytes = null;
        try {
            File file;
            if (this.absolutePath != null && (file = new File(this.absolutePath)).exists()) {
                randomAccessFile = new RandomAccessFile(file, "r");
                bytes = new byte[(int)randomAccessFile.length()];
                randomAccessFile.readFully(bytes);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            CloseableUtil.close(randomAccessFile);
        }
        return bytes;
    }

    @Override
    public String getCharSet() {
        return this.charSet;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getHeader(String name) {
        String header = null;
        List<String> headers = this.headersMap.get(name);
        if (headers != null && headers.size() > 0) {
            header = headers.get(0);
        }
        return header;
    }

    @Override
    public Collection<String> getHeaderNames() {
        return this.headersMap.keySet();
    }

    @Override
    public Collection<String> getHeaders(String name) {
        return this.headersMap.get(name);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        String absolutePath = this.getAbsolutePath();
        if (absolutePath == null) {
            return null;
        }
        return new FileInputStream(absolutePath);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public UploadedFile.Status getStatus() {
        return this.status;
    }

    public String toString() {
        return this.absolutePath;
    }

    @Override
    public void write(String fileName) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(fileName);
        ((OutputStream)outputStream).write(this.getBytes());
        ((OutputStream)outputStream).close();
    }
}

