/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.context.internal;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.osgi.internal.FacesBundlesHandlerResourceProviderOSGiImpl;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.ExternalContext;
import javax.faces.context.ExternalContextWrapper;

public class ExternalContextUtilOSGiImpl
extends ExternalContextWrapper {
    private static final Logger logger = LoggerFactory.getLogger(ExternalContextUtilOSGiImpl.class);
    private Map<String, Object> applicationMap;
    private Map<String, Set<String>> resourcePathsCache;
    private Map<String, URL> resourceURLCache;

    public ExternalContextUtilOSGiImpl(Object context) {
        this.applicationMap = new PortletContextMap(context);
        this.resourcePathsCache = new HashMap<String, Set<String>>();
        this.resourceURLCache = new HashMap<String, URL>();
    }

    public URL getResource(String path) throws MalformedURLException {
        FacesBundlesHandlerResourceProviderOSGiImpl facesBundlesHandler;
        List urls;
        if (path == null) {
            throw new NullPointerException();
        }
        URL resourceURL = this.resourceURLCache.get(path = this.fixPath(path));
        if (resourceURL != null) {
            return resourceURL;
        }
        String pathDir = path;
        String fileSpec = "*";
        int pos = path.lastIndexOf("/");
        if (pos > 0) {
            pathDir = path.substring(0, pos);
            fileSpec = path.substring(pos + 1);
        }
        if ((urls = (List)(facesBundlesHandler = new FacesBundlesHandlerResourceProviderOSGiImpl(pathDir, fileSpec)).handleFacesBundles(this.applicationMap, false)) != null && !urls.isEmpty()) {
            resourceURL = (URL)urls.get(0);
            this.resourceURLCache.put(path, resourceURL);
            return resourceURL;
        }
        return null;
    }

    public InputStream getResourceAsStream(String path) {
        logger.debug("path=[{}]", path);
        URL resourceURL = null;
        try {
            resourceURL = this.getResource(path);
        }
        catch (MalformedURLException e) {
            logger.error(e);
            return null;
        }
        if (resourceURL != null) {
            try {
                return resourceURL.openStream();
            }
            catch (IOException e) {
                logger.error(e);
                return null;
            }
        }
        return null;
    }

    public Set<String> getResourcePaths(String path) {
        if (path == null) {
            throw new NullPointerException();
        }
        Set<String> resourcePaths = this.resourcePathsCache.get(path = this.fixPath(path));
        if (resourcePaths != null) {
            return resourcePaths;
        }
        FacesBundlesHandlerResourceProviderOSGiImpl facesBundlesHandler = new FacesBundlesHandlerResourceProviderOSGiImpl(path, "*");
        List urls = (List)facesBundlesHandler.handleFacesBundles(this.applicationMap, false);
        if (urls != null && !urls.isEmpty()) {
            resourcePaths = new HashSet<String>();
            for (URL url : urls) {
                String urlPath = url.getPath();
                if (!urlPath.startsWith(path)) continue;
                resourcePaths.add(urlPath);
            }
            this.resourcePathsCache.put(path, resourcePaths);
            return resourcePaths;
        }
        return null;
    }

    public ExternalContext getWrapped() {
        return null;
    }

    private String fixPath(String path) {
        if (path.startsWith("/resources")) {
            path = "/META-INF" + path;
        } else if (path.startsWith("/WEB-INF")) {
            path = "/META-INF" + path.substring("/WEB-INF".length());
        }
        return path;
    }

    private static class PortletContextMap
    extends HashMap<String, Object> {
        private Object context;
        Method getAttributeMethod;

        public PortletContextMap(Object context) {
            this.context = context;
            Class<?> contextClass = context.getClass();
            try {
                this.getAttributeMethod = contextClass.getMethod("getAttribute", String.class);
            }
            catch (NoSuchMethodException e) {
                logger.error(e);
            }
        }

        @Override
        public Object get(Object key) {
            try {
                return this.getAttributeMethod.invoke(this.context, key);
            }
            catch (Exception e) {
                logger.error(e);
                return null;
            }
        }

        @Override
        public Object put(String key, Object value) {
            throw new UnsupportedOperationException();
        }
    }
}

