/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.config.internal;

import com.liferay.faces.util.config.WebConfig;
import com.liferay.faces.util.config.internal.ResourceReader;
import com.liferay.faces.util.config.internal.WebConfigImpl;
import com.liferay.faces.util.config.internal.WebConfigParser;
import com.liferay.faces.util.config.internal.WebConfigParserImpl;
import com.liferay.faces.util.config.internal.WebConfigScanner;
import com.liferay.faces.util.internal.CloseableUtil;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import javax.xml.parsers.SAXParser;

public class WebConfigScannerImpl
implements WebConfigScanner {
    private static final Logger logger = LoggerFactory.getLogger(WebConfigScannerImpl.class);
    private static final String WEB_XML_PATH = "/WEB-INF/web.xml";
    private static final String WEB_XML_LIFERAY_PATH = "/WEB-INF/liferay-web.xml";
    private ClassLoader classLoader;
    private boolean resolveEntities;
    private ResourceReader resourceReader;
    private SAXParser saxParser;

    public WebConfigScannerImpl(ClassLoader classLoader, ResourceReader resourceReader, SAXParser saxParser, boolean resolveEntities) {
        this.classLoader = classLoader;
        this.resourceReader = resourceReader;
        this.saxParser = saxParser;
        this.resolveEntities = resolveEntities;
    }

    @Override
    public WebConfig scan() throws IOException {
        WebConfigParser webConfigParser;
        Enumeration<URL> webFragmentURLs = this.classLoader.getResources("META-INF/web-fragment.xml");
        WebConfig webConfig = this.scanWebFragments(webFragmentURLs);
        InputStream inputStream = this.resourceReader.getResourceAsStream(WEB_XML_PATH);
        if (inputStream != null) {
            logger.debug("Processing web-app: [{0}]", WEB_XML_PATH);
            webConfigParser = this.newWebConfigParser();
            try {
                webConfig = webConfigParser.parse(inputStream, webConfig);
            }
            catch (IOException e) {
                logger.error(e);
                throw new IOException(e.getMessage());
            }
        }
        if ((inputStream = this.resourceReader.getResourceAsStream(WEB_XML_LIFERAY_PATH)) != null) {
            logger.debug("Processing web-app: [{0}]", WEB_XML_LIFERAY_PATH);
            webConfigParser = this.newWebConfigParser();
            try {
                webConfigParser.parse(inputStream, webConfig);
            }
            catch (IOException e) {
                logger.error(e);
                throw new IOException(e.getMessage());
            }
        }
        return webConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebConfig scanWebFragments(Enumeration<URL> webFragmentURLs) throws IOException {
        WebConfig webConfig = new WebConfigImpl();
        if (webFragmentURLs != null) {
            while (webFragmentURLs.hasMoreElements()) {
                URL webFragmentURL = webFragmentURLs.nextElement();
                InputStream inputStream = webFragmentURL.openStream();
                WebConfigParser webConfigParser = this.newWebConfigParser();
                try {
                    webConfig = webConfigParser.parse(inputStream, webConfig);
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                finally {
                    CloseableUtil.close(inputStream);
                }
            }
        }
        return webConfig;
    }

    protected WebConfigParser newWebConfigParser() {
        return new WebConfigParserImpl(this.saxParser, this.resolveEntities);
    }
}

