/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.config.internal;

import com.liferay.faces.util.config.ConfiguredServlet;
import com.liferay.faces.util.config.ConfiguredServletMapping;
import com.liferay.faces.util.config.MultiPartConfig;
import com.liferay.faces.util.config.WebConfig;
import com.liferay.faces.util.config.internal.ConfiguredServletImpl;
import com.liferay.faces.util.config.internal.ConfiguredServletMappingImpl;
import com.liferay.faces.util.config.internal.MultiPartConfigImpl;
import com.liferay.faces.util.config.internal.WebConfigImpl;
import com.liferay.faces.util.config.internal.WebConfigParser;
import com.liferay.faces.util.helper.LongHelper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.xml.internal.SAXHandlerBase;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WebConfigParserImpl
extends SAXHandlerBase
implements WebConfigParser {
    private static final Logger logger = LoggerFactory.getLogger(WebConfigParserImpl.class);
    private static final String CONTEXT_PARAM = "context-param";
    private static final String LOCATION = "location";
    private static final String MAX_FILE_SIZE = "max-file-size";
    private static final String MULTIPART_CONFIG = "multipart-config";
    private static final String PARAM_NAME = "param-name";
    private static final String PARAM_VALUE = "param-value";
    private static final String SERVLET = "servlet";
    private static final String SERVLET_CLASS = "servlet-class";
    private static final String SERVLET_MAPPING = "servlet-mapping";
    private static final String SERVLET_NAME = "servlet-name";
    private static final String URL_PATTERN = "url-pattern";
    private Map<String, String> configuredContextParams;
    private List<ConfiguredServlet> configuredServlets;
    private List<ConfiguredServletMapping> configuredServletMappings;
    private String location;
    private long maxFileSize;
    private MultiPartConfig multiPartConfig;
    private boolean parsingContextParam;
    private boolean parsingContextParamName;
    private boolean parsingContextParamValue;
    private boolean parsingLocation;
    private boolean parsingMaxFileSize;
    private boolean parsingMultiPartConfig;
    private boolean parsingServlet;
    private boolean parsingServletClass;
    private boolean parsingServletMapping;
    private boolean parsingServletName;
    private boolean parsingUrlPattern;
    private SAXParser saxParser;
    private String servletClass;
    private String servletName;
    private String paramName;
    private String paramValue;

    public WebConfigParserImpl(SAXParser saxParser, boolean resolveEntities) {
        super(resolveEntities);
        this.saxParser = saxParser;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.parsingServlet) {
            if (this.parsingServletClass) {
                this.servletClass = this.content.toString().trim();
                this.parsingServletClass = false;
            } else if (this.parsingServletName) {
                this.servletName = this.content.toString().trim();
                this.parsingServletName = false;
            } else if (this.parsingMultiPartConfig) {
                if (this.parsingLocation) {
                    this.location = this.content.toString().trim();
                    this.parsingLocation = false;
                } else if (this.parsingMaxFileSize) {
                    this.maxFileSize = LongHelper.toLong(this.content.toString().trim(), -1L);
                    this.parsingMaxFileSize = false;
                }
                if (MULTIPART_CONFIG.equals(qName)) {
                    this.multiPartConfig = new MultiPartConfigImpl(this.location, this.maxFileSize);
                    this.parsingMultiPartConfig = false;
                }
            }
            if (SERVLET.equals(qName)) {
                ConfiguredServletImpl configuredServlet = new ConfiguredServletImpl(this.servletName, this.servletClass, this.multiPartConfig);
                this.configuredServlets.add(configuredServlet);
                this.parsingServlet = false;
            }
        } else if (this.parsingServletMapping) {
            if (this.parsingServletName) {
                this.servletName = this.content.toString().trim();
                this.parsingServletName = false;
            } else if (this.parsingUrlPattern) {
                String urlPattern = this.content.toString().trim();
                ConfiguredServletMappingImpl configuredServletMapping = new ConfiguredServletMappingImpl(this.servletName, urlPattern, false);
                this.configuredServletMappings.add(configuredServletMapping);
                logger.trace("Added servletName=[{0}] urlPattern=[{1}] to configuredServletMappings", this.servletName, urlPattern);
                this.parsingUrlPattern = false;
            }
            if (SERVLET_MAPPING.equals(qName)) {
                this.parsingServletMapping = false;
            }
        } else if (this.parsingContextParam) {
            if (this.parsingContextParamName) {
                this.paramName = this.content.toString().trim();
                this.parsingContextParamName = false;
            } else if (this.parsingContextParamValue) {
                this.paramValue = this.content.toString().trim();
                this.parsingContextParamValue = false;
            }
            if (CONTEXT_PARAM.equals(qName)) {
                this.configuredContextParams.put(this.paramName, this.paramValue);
                this.paramName = null;
                this.paramValue = null;
                this.parsingContextParam = false;
            }
        }
        this.content = null;
    }

    @Override
    public WebConfig parse(InputStream inputStream, WebConfig webConfig) throws IOException {
        Map<String, String> configuredContextParams = webConfig.getConfiguredContextParams();
        this.configuredContextParams = new HashMap<String, String>(configuredContextParams);
        List<ConfiguredServlet> configuredServlets = webConfig.getConfiguredServlets();
        this.configuredServlets = new ArrayList<ConfiguredServlet>(configuredServlets);
        List<ConfiguredServletMapping> configuredServletMappings = webConfig.getConfiguredServletMappings();
        this.configuredServletMappings = new ArrayList<ConfiguredServletMapping>(configuredServletMappings);
        try {
            this.saxParser.parse(inputStream, (DefaultHandler)this);
            webConfig = new WebConfigImpl(this.configuredContextParams, this.configuredServlets, this.configuredServletMappings);
            this.saxParser.reset();
            return webConfig;
        }
        catch (SAXException e) {
            logger.error(e);
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void startElement(String uri, String localName, String elementName, Attributes attributes) throws SAXException {
        logger.trace("localName=[{0}]", localName);
        this.content = new StringBuilder();
        if (localName.equals(SERVLET)) {
            this.parsingServlet = true;
        } else if (localName.equals(SERVLET_CLASS)) {
            this.parsingServletClass = true;
        } else if (localName.equals(SERVLET_MAPPING)) {
            this.parsingServletMapping = true;
        } else if (localName.equals(SERVLET_NAME)) {
            this.parsingServletName = true;
        } else if (localName.equals(URL_PATTERN)) {
            this.parsingUrlPattern = true;
        } else if (localName.equals(MULTIPART_CONFIG)) {
            this.parsingMultiPartConfig = true;
        } else if (localName.equals(LOCATION)) {
            this.parsingLocation = true;
        } else if (localName.equals(MAX_FILE_SIZE)) {
            this.parsingMaxFileSize = true;
        } else if (localName.equals(CONTEXT_PARAM)) {
            this.parsingContextParam = true;
        } else if (localName.equals(PARAM_NAME)) {
            this.parsingContextParamName = true;
        } else if (localName.equals(PARAM_VALUE)) {
            this.parsingContextParamValue = true;
        }
    }
}

