/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.config.internal;

import com.liferay.faces.util.config.internal.FacesConfigDescriptor;
import com.liferay.faces.util.config.internal.FacesConfigDescriptorImpl;
import com.liferay.faces.util.config.internal.FacesConfigDescriptorParser;
import com.liferay.faces.util.config.internal.Ordering;
import com.liferay.faces.util.config.internal.OrderingImpl;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.xml.internal.SAXHandlerBase;
import com.liferay.faces.util.xml.internal.SAXParseCompleteException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FacesConfigDescriptorParserImpl
extends SAXHandlerBase
implements FacesConfigDescriptorParser {
    private static final Logger logger = LoggerFactory.getLogger(FacesConfigDescriptorParserImpl.class);
    private static final String ABSOLUTE_ORDERING = "absolute-ordering";
    private static final String AFTER = "after";
    private static final String BEFORE = "before";
    private static final String FACES_CONFIG = "faces-config";
    private static final String ORDERING = "ordering";
    private static final String OTHERS = "others";
    private String facesConfigName;
    private List<String> afterNames;
    private List<String> beforeNames;
    private boolean isWebInfFacesConfig;
    private List<String> absoluteOrdering;
    private Ordering ordering;
    private boolean parsingAbsoluteOrdering;
    private boolean parsingAfter;
    private boolean parsingBefore;
    private boolean parsingFacesConfig;
    private boolean parsingName = false;
    private boolean parsingOrdering;
    private boolean parsingOthers;
    private SAXParser saxParser;

    public FacesConfigDescriptorParserImpl(SAXParser saxParser, boolean resolveEntities) {
        super(resolveEntities);
        this.saxParser = saxParser;
        this.afterNames = new ArrayList<String>();
        this.ordering = new OrderingImpl();
        this.beforeNames = new ArrayList<String>();
    }

    @Override
    public void endElement(String uri, String localName, String elementName) throws SAXException {
        if (this.parsingFacesConfig) {
            if (this.parsingName && !this.parsingAbsoluteOrdering && !this.parsingOrdering) {
                this.facesConfigName = this.content.toString().trim();
                this.parsingName = false;
            } else if (this.parsingAbsoluteOrdering) {
                if (this.parsingName) {
                    if (this.content != null) {
                        String name = this.content.toString().trim();
                        this.absoluteOrdering.add(name);
                    }
                    this.parsingName = false;
                } else if (this.parsingOthers) {
                    this.absoluteOrdering.add(Ordering.OTHERS);
                    this.parsingOthers = false;
                } else if (localName.equals(ABSOLUTE_ORDERING)) {
                    this.parsingAbsoluteOrdering = false;
                }
            } else if (this.parsingOrdering) {
                if (this.parsingBefore) {
                    String beforeName = null;
                    if (this.parsingName || this.parsingOthers) {
                        if (this.parsingOthers) {
                            beforeName = Ordering.OTHERS;
                            this.beforeNames.add(beforeName);
                            this.parsingOthers = false;
                        } else {
                            if (this.content != null) {
                                beforeName = this.content.toString().trim();
                                this.beforeNames.add(beforeName);
                            }
                            this.parsingName = false;
                        }
                    } else if (localName.equals(BEFORE)) {
                        this.parsingBefore = false;
                        if (this.content != null) {
                            logger.warn("Stray content found when parsing FacesConfig named " + this.facesConfigName + ". -> Ordering -> before -> content found: " + this.content + " ... probably belongs inside of a 'name' tag.");
                            logger.warn("Assuming '" + this.content + "' is a name ...");
                            beforeName = this.content.toString().trim();
                            this.beforeNames.add(beforeName);
                        }
                    }
                }
                if (this.parsingAfter) {
                    String afterName = null;
                    if (this.parsingName || this.parsingOthers) {
                        if (this.parsingOthers) {
                            afterName = Ordering.OTHERS;
                            this.afterNames.add(afterName);
                            this.parsingOthers = false;
                        } else {
                            if (this.content != null) {
                                afterName = this.content.toString().trim();
                                this.afterNames.add(afterName);
                            }
                            this.parsingName = false;
                        }
                    } else if (localName.equals(AFTER)) {
                        this.parsingAfter = false;
                        if (this.content != null) {
                            logger.warn("Stray content found when parsing FacesConfig named " + this.facesConfigName + ". -> Ordering -> after -> content found: " + this.content + " ... probably belongs inside of a 'name' tag.");
                            logger.warn("Assuming '" + this.content + "' is a name ...");
                            afterName = this.content.toString().trim();
                            this.afterNames.add(afterName);
                        }
                    }
                }
                if (localName.equals(ORDERING)) {
                    this.parsingOrdering = false;
                }
            } else {
                if (localName.equals(FACES_CONFIG)) {
                    this.parsingFacesConfig = false;
                    throw new SAXParseCompleteException();
                }
                super.endElement(uri, localName, elementName);
            }
        }
        this.content = null;
    }

    public boolean isWebInfFacesConfig() {
        return this.isWebInfFacesConfig;
    }

    @Override
    public FacesConfigDescriptor parse(InputStream inputStream, String path) throws IOException {
        try {
            this.isWebInfFacesConfig = path.contains("/WEB-INF/faces-config.xml");
            try {
                this.saxParser.parse(inputStream, (DefaultHandler)this);
            }
            catch (SAXParseCompleteException sAXParseCompleteException) {
                // empty catch block
            }
            if (this.ordering != null) {
                EnumMap<Ordering.Path, String[]> routes = this.ordering.getRoutes();
                EnumMap<Ordering.Path, String[]> routesToSet = new EnumMap<Ordering.Path, String[]>(Ordering.Path.class);
                if (this.beforeNames.size() > 0) {
                    Object[] befores = this.beforeNames.toArray(new String[this.beforeNames.size()]);
                    if (this.beforeNames.size() > 1) {
                        Arrays.sort(befores);
                    }
                    routesToSet.put(Ordering.Path.BEFORE, (String[])befores);
                } else {
                    routesToSet.put(Ordering.Path.BEFORE, routes.get((Object)Ordering.Path.BEFORE));
                }
                if (this.afterNames.size() > 0) {
                    Object[] afters = this.afterNames.toArray(new String[this.afterNames.size()]);
                    if (this.afterNames.size() > 1) {
                        Arrays.sort(afters);
                    }
                    routesToSet.put(Ordering.Path.AFTER, (String[])afters);
                } else {
                    routesToSet.put(Ordering.Path.AFTER, routes.get((Object)Ordering.Path.AFTER));
                }
                this.ordering.setRoutes(routesToSet);
            }
            if (this.absoluteOrdering != null && this.absoluteOrdering.size() == 0) {
                this.absoluteOrdering = null;
            }
            FacesConfigDescriptorImpl facesConfigDescriptor = new FacesConfigDescriptorImpl(this.facesConfigName, path, this.isWebInfFacesConfig, this.absoluteOrdering, this.ordering);
            this.facesConfigName = null;
            this.absoluteOrdering = null;
            this.ordering = null;
            this.afterNames = null;
            this.beforeNames = null;
            this.saxParser.reset();
            return facesConfigDescriptor;
        }
        catch (SAXException e) {
            logger.error(e);
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public FacesConfigDescriptor parse(InputStream inputStream, URL url) throws IOException {
        String path = url.toExternalForm();
        return this.parse(inputStream, path);
    }

    @Override
    public void startElement(String uri, String localName, String elementName, Attributes attributes) throws SAXException {
        this.content = new StringBuilder();
        if (localName.equals(FACES_CONFIG)) {
            this.parsingFacesConfig = true;
            if (this.isWebInfFacesConfig()) {
                this.absoluteOrdering = new ArrayList<String>();
                this.ordering = null;
                this.afterNames = null;
                this.beforeNames = null;
            } else {
                this.absoluteOrdering = null;
                this.ordering = new OrderingImpl();
                this.afterNames = new ArrayList<String>();
                this.beforeNames = new ArrayList<String>();
            }
        } else if (localName.equals("name")) {
            this.parsingName = true;
        } else if (localName.equals(ABSOLUTE_ORDERING)) {
            if (this.isWebInfFacesConfig()) {
                this.parsingAbsoluteOrdering = true;
            } else {
                logger.warn("endElement: found " + localName + " section in " + uri.toString() + "\nTrying to ignore this section ...");
            }
        } else if (localName.equals(ORDERING)) {
            if (this.isWebInfFacesConfig()) {
                logger.warn("endElement: found " + localName + " section in " + uri.toString() + "\nTrying to ignore this section ...");
            } else {
                this.parsingOrdering = true;
            }
        } else if (localName.equals(BEFORE)) {
            this.parsingBefore = true;
        } else if (localName.equals(AFTER)) {
            this.parsingAfter = true;
        } else if (localName.startsWith(OTHERS)) {
            this.parsingOthers = true;
        } else {
            super.startElement(uri, localName, elementName, attributes);
        }
    }
}

