/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.application.internal;

import com.liferay.faces.util.application.ResourceValidator;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.FactoryFinder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewDeclarationLanguageFactory;

public class ResourceValidatorImpl
implements ResourceValidator,
Serializable {
    private static final long serialVersionUID = 1439627171348715228L;
    private static final Logger logger = LoggerFactory.getLogger(ResourceValidatorImpl.class);
    private static final Pattern BANNED_PATHS_PATTERN = Pattern.compile(".*/(?:META-INF|WEB-INF)/.*", 2);
    private static final String[] BANNED_SEQUENCES = new String[]{"//", "\\\\", "/\\", "\\/", "..", "./", ".\\", "%"};
    private static final String LEGACY_FACELETS_VIEW_MAPPINGS_PARAM_NAME = "facelets.VIEW_MAPPINGS";
    private final List<Pattern> excludeResourcePatterns;
    private final List<Pattern> excludeLibraryPatterns;

    public ResourceValidatorImpl(ArrayList<Pattern> excludeResourcePatterns, ArrayList<Pattern> excludeLibraryPatterns) {
        this.excludeResourcePatterns = excludeResourcePatterns != null ? Collections.unmodifiableList(excludeResourcePatterns) : null;
        this.excludeLibraryPatterns = excludeLibraryPatterns != null ? Collections.unmodifiableList(excludeLibraryPatterns) : null;
    }

    private static List<String> getViewMappings(ExternalContext externalContext, String ... viewMappingsParamNames) {
        ArrayList viewMappings = new ArrayList();
        for (String viewMappingsParamName : viewMappingsParamNames) {
            String configuredMappings = externalContext.getInitParameter(viewMappingsParamName);
            if (configuredMappings == null) continue;
            String[] mappings = configuredMappings.split(";");
            Collections.addAll(viewMappings, mappings);
        }
        return Collections.unmodifiableList(viewMappings);
    }

    @Override
    public boolean containsBannedPath(String resourceId) {
        Matcher matcher = BANNED_PATHS_PATTERN.matcher(resourceId);
        boolean matches = matcher.matches();
        if (matches) {
            logger.trace("MATCHED BANNED PATH resourceId=[{0}] matcher=[{1}]", resourceId, matcher);
        }
        return matches;
    }

    @Override
    public boolean isBannedSequence(String resourceId) {
        boolean bannedSequence = false;
        if (resourceId != null) {
            for (String sequence : BANNED_SEQUENCES) {
                if (!resourceId.contains(sequence)) continue;
                logger.trace("MATCHED BANNED SEQUENCE resourceId=[{0}] sequence=[{1}]", resourceId, sequence);
                bannedSequence = true;
                break;
            }
        }
        return bannedSequence;
    }

    @Override
    public boolean isFaceletDocument(FacesContext facesContext, String resourceId) {
        boolean faceletDocument = false;
        ArrayList<String> faceletExtensions = new ArrayList<String>();
        ArrayList<String> faceletPathMappings = new ArrayList<String>();
        faceletExtensions.add(".xhtml");
        ExternalContext externalContext = facesContext.getExternalContext();
        String configuredExtension = externalContext.getInitParameter("javax.faces.FACELETS_SUFFIX");
        if (configuredExtension != null && !faceletExtensions.contains(configuredExtension)) {
            faceletExtensions.add(configuredExtension);
        }
        List<String> viewMappings = ResourceValidatorImpl.getViewMappings(externalContext, "javax.faces.FACELETS_VIEW_MAPPINGS", LEGACY_FACELETS_VIEW_MAPPINGS_PARAM_NAME);
        for (String viewMapping : viewMappings) {
            String faceletPathMapping;
            if ((viewMapping = viewMapping.trim()).startsWith("*")) {
                String faceletExtension = viewMapping.substring(1);
                if (faceletExtensions.contains(faceletExtension)) continue;
                faceletExtensions.add(faceletExtension);
                continue;
            }
            if (!viewMapping.endsWith("*") || faceletPathMappings.contains(faceletPathMapping = viewMapping.substring(0, viewMapping.length() - 1))) continue;
            faceletPathMappings.add(faceletPathMapping);
        }
        for (String faceletPathMapping : faceletPathMappings) {
            if (!resourceId.startsWith(faceletPathMapping)) continue;
            logger.trace("MATCHED FACELET PATH MAPPING resourceId=[{0}] faceletPathMapping=[{1}]", resourceId, faceletPathMapping);
            faceletDocument = true;
            break;
        }
        for (String faceletExtension : faceletExtensions) {
            if (!resourceId.contains(faceletExtension)) continue;
            logger.trace("MATCHED FACELET EXTENSION MAPPING resourceId=[{0}] faceletExtension=[{1}] ", resourceId, faceletExtension);
            faceletDocument = true;
            break;
        }
        if (!faceletDocument) {
            faceletDocument = this.isFaceletsVDL(resourceId);
        }
        return faceletDocument;
    }

    @Override
    public boolean isSelfReferencing(FacesContext facesContext, String resourceId) {
        return false;
    }

    @Override
    public boolean isValidLibraryName(String libraryName) {
        boolean validLibraryName = true;
        if (this.excludeLibraryPatterns != null) {
            for (Pattern excludeLibraryPattern : this.excludeLibraryPatterns) {
                Matcher matcher = excludeLibraryPattern.matcher(libraryName);
                if (!matcher.matches()) continue;
                validLibraryName = false;
                logger.trace("MATCHED LIBRARY NAME EXCLUSION PATTERN libraryName=[{0}] matcher=[{1}]", libraryName, matcher);
                break;
            }
        }
        return validLibraryName;
    }

    @Override
    public boolean isValidResourceName(String resourceName) {
        boolean validResourceName = true;
        if (this.excludeResourcePatterns != null) {
            for (Pattern excludeResourcePattern : this.excludeResourcePatterns) {
                Matcher matcher = excludeResourcePattern.matcher(resourceName);
                if (!matcher.matches()) continue;
                validResourceName = false;
                logger.trace("MATCHED RESOURCE NAME EXCLUSION PATTERN resourceName=[{0}] matcher=[{1}] ", resourceName, matcher);
                break;
            }
        }
        return validResourceName;
    }

    protected boolean isFaceletsVDL(String viewId) {
        boolean faceletsVDL = false;
        ViewDeclarationLanguageFactory viewDeclarationLanguageFactory = (ViewDeclarationLanguageFactory)FactoryFinder.getFactory((String)"javax.faces.view.ViewDeclarationLanguageFactory");
        ViewDeclarationLanguage viewDeclarationLanguage = viewDeclarationLanguageFactory.getViewDeclarationLanguage(viewId);
        if (viewDeclarationLanguage != null && (faceletsVDL = viewDeclarationLanguage.getId().equals("java.faces.Facelets"))) {
            logger.trace("MATCHED FACELETS VDL viewId=[{0}]", viewId);
        }
        return faceletsVDL;
    }
}

