/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.render.internal;

import com.liferay.faces.util.client.Script;
import com.liferay.faces.util.client.ScriptsEncoder;
import com.liferay.faces.util.client.ScriptsEncoderFactory;
import com.liferay.faces.util.context.FacesContextHelperUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.context.ResponseWriterWrapper;

public class BodyScriptEncodingResponseWriter
extends ResponseWriterWrapper {
    private FacesContext facesContext;
    private ResponseWriter wrappedResponseWriter;
    private BufferedScript bufferedScript;

    public BodyScriptEncodingResponseWriter(ResponseWriter wrappedResponseWriter, FacesContext facesContext) {
        this.facesContext = facesContext;
        this.wrappedResponseWriter = wrappedResponseWriter;
        this.bufferedScript = new BufferedScript();
    }

    public void endElement(String name) throws IOException {
        if (this.bufferedScript.isBuffering() && "script".equals(name)) {
            if (this.bufferedScript.isResource()) {
                this.bufferedScript.write(this.wrappedResponseWriter);
            } else {
                String scriptSource = this.bufferedScript.toString();
                FacesContextHelperUtil.addScript(this.facesContext, scriptSource);
            }
            this.bufferedScript.clear();
        } else {
            List<Script> scripts;
            if ("body".equals(name) && !(scripts = FacesContextHelperUtil.getScripts(this.facesContext)).isEmpty()) {
                ExternalContext externalContext = this.facesContext.getExternalContext();
                ScriptsEncoder scriptsEncoder = ScriptsEncoderFactory.getScriptsEncoderInstance(externalContext);
                this.facesContext.setResponseWriter(this.wrappedResponseWriter);
                scriptsEncoder.encodeBodyScripts(this.facesContext, scripts);
                this.facesContext.setResponseWriter((ResponseWriter)this);
            }
            super.endElement(name);
        }
    }

    public ResponseWriter getWrapped() {
        return this.wrappedResponseWriter;
    }

    public void startElement(String name, UIComponent uiComponent) throws IOException {
        if ("script".equals(name)) {
            this.bufferedScript.startBuffering(uiComponent);
        } else {
            super.startElement(name, uiComponent);
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.bufferedScript.isBuffering()) {
            this.bufferedScript.bufferSourceCode(cbuf, off, len);
        } else {
            super.write(cbuf, off, len);
        }
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        if (this.bufferedScript.isBuffering()) {
            this.bufferedScript.bufferAttribute(name, value, property);
        } else {
            super.writeAttribute(name, value, property);
        }
    }

    public void writeText(Object text, String property) throws IOException {
        if (this.bufferedScript.isBuffering()) {
            this.bufferedScript.bufferSourceCode(text);
        } else {
            super.writeText(text, property);
        }
    }

    public void writeText(char[] cbuf, int off, int len) throws IOException {
        if (this.bufferedScript.isBuffering()) {
            this.bufferedScript.bufferSourceCode(cbuf, off, len);
        } else {
            super.writeText(cbuf, off, len);
        }
    }

    public void writeText(Object text, UIComponent component, String property) throws IOException {
        if (this.bufferedScript.isBuffering()) {
            this.bufferedScript.bufferSourceCode(text);
        } else {
            super.writeText(text, component, property);
        }
    }

    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        if (this.bufferedScript.isBuffering()) {
            this.bufferedScript.bufferURIAttribute(name, value, property);
        } else {
            super.writeURIAttribute(name, value, property);
        }
    }

    private static final class BufferedScript {
        private Map<String, BufferedScriptAttribute> attributes;
        private UIComponent scriptComponent;
        private StringWriter sourceCodeWriter = new StringWriter();
        private boolean writingScript;

        private BufferedScript() {
            this.attributes = new HashMap<String, BufferedScriptAttribute>();
        }

        public String toString() {
            return this.sourceCodeWriter.toString();
        }

        private void bufferAttribute(String name, Object value, String property) {
            this.attributes.put(name, new BufferedScriptAttribute(value, property, false));
        }

        private void bufferSourceCode(Object sourceCode) {
            this.sourceCodeWriter.write((String)sourceCode);
        }

        private void bufferSourceCode(char[] cbuf, int off, int len) {
            this.sourceCodeWriter.write(cbuf, off, len);
        }

        private void bufferURIAttribute(String name, Object value, String property) {
            this.attributes.put(name, new BufferedScriptAttribute(value, property, true));
        }

        private void clear() {
            this.writingScript = false;
            this.attributes.clear();
            this.scriptComponent = null;
            StringBuffer sourceCodeWriterBuffer = this.sourceCodeWriter.getBuffer();
            sourceCodeWriterBuffer.setLength(0);
        }

        private boolean isBuffering() {
            return this.writingScript;
        }

        private boolean isResource() {
            return this.attributes.containsKey("src");
        }

        private void startBuffering(UIComponent scriptComponent) {
            this.writingScript = true;
            this.scriptComponent = scriptComponent;
        }

        private void write(ResponseWriter responseWriter) throws IOException {
            responseWriter.startElement("script", this.scriptComponent);
            Set<String> attributeNames = this.attributes.keySet();
            for (String attributeName : attributeNames) {
                BufferedScriptAttribute attribute = this.attributes.get(attributeName);
                if (attribute.uriAttribute) {
                    responseWriter.writeURIAttribute(attributeName, attribute.value, attribute.property);
                    continue;
                }
                responseWriter.writeAttribute(attributeName, attribute.value, attribute.property);
            }
            responseWriter.endElement("script");
        }

        private static final class BufferedScriptAttribute {
            private Object value;
            private String property;
            private boolean uriAttribute;

            public BufferedScriptAttribute(Object value, String property, boolean uriAttribute) {
                this.value = value;
                this.property = property;
                this.uriAttribute = uriAttribute;
            }
        }
    }
}

