/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.render;

import com.liferay.faces.util.component.ComponentUtil;
import com.liferay.faces.util.component.Styleable;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class RendererUtil {
    private static final String JAVA_SCRIPT_HEX_PREFIX = "\\x";
    private static final char[] _HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final Logger logger = LoggerFactory.getLogger(RendererUtil.class);

    public static void addDefaultAjaxBehavior(ClientBehaviorHolder clientBehaviorHolder, String execute, String process, String defaultExecute, String render, String update, String defaultRender) {
        if (RendererUtil.getDefaultAjaxBehavior(clientBehaviorHolder) == null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            Application application = facesContext.getApplication();
            AjaxBehavior ajaxBehavior = (AjaxBehavior)application.createBehavior("javax.faces.behavior.Ajax");
            Collection<String> executeIds = RendererUtil.getExecuteIds(execute, process, defaultExecute);
            ajaxBehavior.setExecute(executeIds);
            Collection<String> renderIds = RendererUtil.getRenderIds(render, update, defaultRender);
            ajaxBehavior.setRender(renderIds);
            String defaultEventName = clientBehaviorHolder.getDefaultEventName();
            clientBehaviorHolder.addClientBehavior(defaultEventName, (ClientBehavior)ajaxBehavior);
        }
    }

    public static void decodeClientBehaviors(FacesContext facesContext, UIComponent uiComponent) {
        if (uiComponent instanceof ClientBehaviorHolder) {
            String clientId;
            String source;
            List clientBehaviors;
            ClientBehaviorHolder clientBehaviorHolder = (ClientBehaviorHolder)uiComponent;
            Map clientBehaviorMap = clientBehaviorHolder.getClientBehaviors();
            Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
            String behaviorEvent = (String)requestParameterMap.get("javax.faces.behavior.event");
            if (behaviorEvent != null && (clientBehaviors = (List)clientBehaviorMap.get(behaviorEvent)) != null && (source = (String)requestParameterMap.get("javax.faces.source")) != null && (clientId = uiComponent.getClientId(facesContext)).startsWith(source)) {
                for (ClientBehavior behavior : clientBehaviors) {
                    behavior.decode(facesContext, uiComponent);
                }
            }
        }
    }

    public static void encodeStyleable(ResponseWriter responseWriter, Styleable styleable, String ... classNames) throws IOException {
        String style;
        String styleClass;
        StringBuilder allCssClasses = new StringBuilder();
        String cssClasses = ComponentUtil.concatCssClasses(classNames);
        if (cssClasses != null) {
            allCssClasses.append(cssClasses);
            allCssClasses.append(" ");
        }
        if ((styleClass = styleable.getStyleClass()) != null) {
            allCssClasses.append(styleClass);
        }
        if (allCssClasses.length() > 0) {
            responseWriter.writeAttribute("class", (Object)allCssClasses.toString(), "styleClass");
        }
        if ((style = styleable.getStyle()) != null) {
            responseWriter.writeAttribute("style", (Object)style, "style");
        }
    }

    public static String escapeJavaScript(String javaScript) {
        char[] javaScriptCharArray;
        StringBuilder stringBuilder = new StringBuilder();
        for (char character : javaScriptCharArray = javaScript.toCharArray()) {
            if (character > '\u00ff' || Character.isLetterOrDigit(character)) {
                stringBuilder.append(character);
                continue;
            }
            stringBuilder.append(JAVA_SCRIPT_HEX_PREFIX);
            String hexString = RendererUtil.toHexString(character);
            if (hexString.length() == 1) {
                stringBuilder.append("0");
            }
            stringBuilder.append(hexString);
        }
        if (stringBuilder.length() != javaScript.length()) {
            javaScript = stringBuilder.toString();
        }
        return javaScript;
    }

    public static AjaxBehavior getDefaultAjaxBehavior(ClientBehaviorHolder clientBehaviorHolder) {
        String defaultEventName;
        Map clientBehaviorMap = clientBehaviorHolder.getClientBehaviors();
        List clientBehaviors = (List)clientBehaviorMap.get(defaultEventName = clientBehaviorHolder.getDefaultEventName());
        if (clientBehaviors != null) {
            for (ClientBehavior clientBehavior : clientBehaviors) {
                if (!(clientBehavior instanceof AjaxBehavior)) continue;
                return (AjaxBehavior)clientBehavior;
            }
        }
        return null;
    }

    private static Collection<String> getExecuteIds(String execute, String process, String defaultValue) {
        if (!execute.equals(process)) {
            if (execute.equals(defaultValue)) {
                execute = process;
            } else if (!process.equals(defaultValue)) {
                logger.warn("Different values were specified for the execute=[{0}] and process=[{0}]. The value for execute takes precedence.");
            }
        }
        return Arrays.asList(execute.split(" "));
    }

    private static Collection<String> getRenderIds(String render, String update, String defaultValue) {
        if (!render.equals(update)) {
            if (render.equals(defaultValue)) {
                render = update;
            } else if (!update.equals(defaultValue)) {
                logger.warn("Different values were specified for the render=[{0}] and update=[{0}]. The value for render takes precedence.");
            }
        }
        return Arrays.asList(render.split(" "));
    }

    private static String toHexString(int i) {
        char[] buffer = new char[8];
        int index = 8;
        do {
            buffer[--index] = _HEX_DIGITS[i & 0xF];
        } while ((i >>>= 4) != 0);
        return new String(buffer, index, 8 - index);
    }
}

