/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.osgi.internal;

import com.liferay.faces.util.i18n.internal.UTF8Control;
import com.liferay.faces.util.internal.TCCLUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.ServiceLoader;

public class ResourceBundleUtil {
    private static final BaseControl BASE_CONTROL = new BaseControl();
    private static final Method GET_CONTROL_METHOD;
    private static final List RESOURCE_BUNDLE_CONTROL_PROVIDERS;
    private static final ResourceBundle.Control UTF8_CONTROL;
    private static final ResourceBundle.Control OSGI_FRIENDLY_UTF8_CONTROL;

    private ResourceBundleUtil() {
        throw new AssertionError();
    }

    public static ResourceBundle getResourceBundleInOSGiEnvironment(String baseName, Locale targetLocale, ClassLoader threadContextClassLoader, Class<?> callingClass) throws MissingResourceException {
        ResourceBundle.Control osgiFriendlyControl = ResourceBundleUtil.getOSGiFriendlyControl(baseName, callingClass);
        return ResourceBundle.getBundle(baseName, targetLocale, threadContextClassLoader, osgiFriendlyControl);
    }

    public static ResourceBundle getResourceBundleInOSGiEnvironment(String baseName, Locale targetLocale, ClassLoader threadContextClassLoader, ResourceBundle.Control control, Class<?> callingClass) throws MissingResourceException {
        OSGiFriendlyControl osgiFriendlyControl = new OSGiFriendlyControl(control, callingClass);
        return ResourceBundle.getBundle(baseName, targetLocale, threadContextClassLoader, osgiFriendlyControl);
    }

    public static ResourceBundle getUTF8ResourceBundleInOSGiEnvironment(String baseName, Locale targetLocale) throws MissingResourceException {
        return ResourceBundleUtil.getUTF8ResourceBundleInOSGiEnvironment(baseName, targetLocale, OSGI_FRIENDLY_UTF8_CONTROL);
    }

    public static ResourceBundle getUTF8ResourceBundleInOSGiEnvironment(String baseName, Locale targetLocale, Class<?> callingClass) throws MissingResourceException {
        OSGiFriendlyControl osgiFriendlyUTF8Control = new OSGiFriendlyControl(UTF8_CONTROL, callingClass);
        return ResourceBundleUtil.getUTF8ResourceBundleInOSGiEnvironment(baseName, targetLocale, osgiFriendlyUTF8Control);
    }

    private static ResourceBundle.Control getOSGiFriendlyControl(String baseName, Class<?> callingClass) {
        OSGiFriendlyControl control = null;
        for (Object resourceBundleControlProvider : RESOURCE_BUNDLE_CONTROL_PROVIDERS) {
            ResourceBundle.Control providedControl = ResourceBundleUtil.getProvidedControl(resourceBundleControlProvider, baseName);
            if (providedControl == null) continue;
            control = new OSGiFriendlyControl(providedControl, callingClass);
            break;
        }
        if (control == null) {
            control = new OSGiFriendlyControl(BASE_CONTROL, callingClass);
        }
        return control;
    }

    private static ResourceBundle.Control getProvidedControl(Object resourceBundleControlProvider, String baseName) {
        ResourceBundle.Control control = null;
        try {
            control = (ResourceBundle.Control)GET_CONTROL_METHOD.invoke(resourceBundleControlProvider, baseName);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return control;
    }

    private static ResourceBundle getUTF8ResourceBundleInOSGiEnvironment(String baseName, Locale targetLocale, ResourceBundle.Control control) throws MissingResourceException {
        ClassLoader threadContextClassLoader = TCCLUtil.getThreadContextClassLoaderOrDefault(ResourceBundleUtil.class);
        return ResourceBundle.getBundle(baseName, targetLocale, threadContextClassLoader, control);
    }

    static {
        UTF8_CONTROL = new UTF8Control();
        OSGI_FRIENDLY_UTF8_CONTROL = new OSGiFriendlyControl(UTF8_CONTROL, ResourceBundleUtil.class);
        ArrayList resourceBundleControlProviders = new ArrayList();
        Class<?> resourceBundleControlProviderClass = null;
        Method getControlMethod = null;
        try {
            resourceBundleControlProviderClass = Class.forName("java.util.spi.ResourceBundleControlProvider");
            getControlMethod = resourceBundleControlProviderClass.getMethod("getControl", String.class);
            ServiceLoader<?> serviceLoaders = ServiceLoader.loadInstalled(resourceBundleControlProviderClass);
            Iterator<?> iterator = serviceLoaders.iterator();
            while (iterator.hasNext()) {
                resourceBundleControlProviders.add(iterator.next());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        GET_CONTROL_METHOD = getControlMethod;
        RESOURCE_BUNDLE_CONTROL_PROVIDERS = Collections.unmodifiableList(resourceBundleControlProviders);
    }

    private static final class OSGiFriendlyControl
    extends ResourceBundle.Control {
        private final ResourceBundle.Control wrappedControl;
        private final ClassLoader bundleClassLoader;

        public OSGiFriendlyControl(ResourceBundle.Control wrappedControl, Class<?> callingClass) {
            this.wrappedControl = wrappedControl;
            this.bundleClassLoader = callingClass.getClassLoader();
        }

        @Override
        public List<Locale> getCandidateLocales(String baseName, Locale locale) {
            return this.wrappedControl.getCandidateLocales(baseName, locale);
        }

        @Override
        public Locale getFallbackLocale(String baseName, Locale locale) {
            return this.wrappedControl.getFallbackLocale(baseName, locale);
        }

        @Override
        public List<String> getFormats(String baseName) {
            return this.wrappedControl.getFormats(baseName);
        }

        @Override
        public long getTimeToLive(String baseName, Locale locale) {
            return this.wrappedControl.getTimeToLive(baseName, locale);
        }

        @Override
        public boolean needsReload(String baseName, Locale locale, String format, ClassLoader classLoader, ResourceBundle bundle, long loadTime) {
            return this.wrappedControl.needsReload(baseName, locale, format, classLoader, bundle, loadTime);
        }

        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader classLoader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            ResourceBundle resourceBundle = this.wrappedControl.newBundle(baseName, locale, format, classLoader, reload);
            if (resourceBundle == null && !this.bundleClassLoader.equals(classLoader)) {
                resourceBundle = this.wrappedControl.newBundle(baseName, locale, format, this.bundleClassLoader, reload);
            }
            return resourceBundle;
        }

        @Override
        public String toBundleName(String baseName, Locale locale) {
            return this.wrappedControl.toBundleName(baseName, locale);
        }
    }

    private static final class BaseControl
    extends ResourceBundle.Control {
        private BaseControl() {
        }
    }
}

