/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.osgi.internal;

import com.liferay.faces.util.osgi.internal.FacesBundleUtil;
import java.util.Collection;
import org.osgi.framework.Bundle;

public abstract class FacesBundlesHandlerBase<ReturnValueType> {
    public final ReturnValueType handleFacesBundles(Object context, boolean recurse) {
        ReturnValueType returnValueObject = this.getInitialReturnValueObject();
        ReturnValueReference<ReturnValueType> returnValueReference = new ReturnValueReference<ReturnValueType>(returnValueObject);
        if (context != null) {
            this.handleCurrentFacesWab(FacesBundleUtil.getCurrentFacesWab(context), returnValueReference, recurse);
            Collection<Bundle> facesBundles = FacesBundleUtil.getFacesBundles(context);
            if (facesBundles != null) {
                for (Bundle facesBundle : facesBundles) {
                    this.handleFacesBundle(facesBundle, returnValueReference, recurse);
                }
            }
        }
        return returnValueReference.get();
    }

    protected abstract ReturnValueType getInitialReturnValueObject();

    protected abstract void handleFacesBundle(Bundle var1, ReturnValueReference<ReturnValueType> var2, boolean var3);

    protected void handleCurrentFacesWab(Bundle currentFacesWab, ReturnValueReference<ReturnValueType> returnValueReference, boolean recurse) {
        this.handleFacesBundle(currentFacesWab, returnValueReference, recurse);
    }

    protected static final class ReturnValueReference<ReturnValueType> {
        private ReturnValueType returnValueObject;

        public ReturnValueReference(ReturnValueType returnValueObject) {
            this.returnValueObject = returnValueObject;
        }

        public ReturnValueType get() {
            return this.returnValueObject;
        }

        public boolean isEmpty() {
            return this.returnValueObject == null;
        }

        public void set(ReturnValueType returnValueObject) {
            this.returnValueObject = returnValueObject;
        }
    }
}

