/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.logging;

import com.liferay.faces.util.logging.Logger;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class LoggerFactory {
    private static final LoggerFactory LOGGER_FACTORY;

    public static final Logger getLogger(String name) {
        return LOGGER_FACTORY.getLoggerImplementation(name);
    }

    public static final Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    public abstract Logger getLoggerImplementation(String var1);

    static {
        LoggerFactory loggerFactoryImpl;
        ServiceLoader<LoggerFactory> serviceLoader = ServiceLoader.load(LoggerFactory.class);
        if (serviceLoader != null) {
            Iterator<LoggerFactory> iterator = serviceLoader.iterator();
            loggerFactoryImpl = null;
            while (loggerFactoryImpl == null && iterator.hasNext()) {
                loggerFactoryImpl = iterator.next();
            }
            if (loggerFactoryImpl == null) {
                try {
                    Class<?> clazz = Class.forName("com.liferay.faces.util.logging.internal.LoggerFactoryImpl");
                    loggerFactoryImpl = (LoggerFactory)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable locate service for " + LoggerFactory.class.getName(), e);
                }
            }
        } else {
            throw new NullPointerException("Unable to acquire ServiceLoader for " + LoggerFactory.class.getName());
        }
        LOGGER_FACTORY = loggerFactoryImpl;
    }
}

