/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.i18n;

import com.liferay.faces.util.cache.Cache;
import com.liferay.faces.util.cache.CacheFactory;
import com.liferay.faces.util.i18n.I18n;
import com.liferay.faces.util.i18n.I18nUtil;
import com.liferay.faces.util.i18n.I18nWrapper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.osgi.internal.ResourceBundleUtil;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public abstract class I18nBundleBase
extends I18nWrapper
implements Serializable {
    private static final long serialVersionUID = 3785524975078495843L;
    private static final Logger logger = LoggerFactory.getLogger(I18nBundleBase.class);
    private final I18n wrappedI18n;

    public I18nBundleBase(I18n i18n) {
        this.wrappedI18n = i18n;
        FacesContext startupFacesContext = FacesContext.getCurrentInstance();
        if (startupFacesContext != null) {
            ExternalContext externalContext = startupFacesContext.getExternalContext();
            Cache<String, String> messageCache = this.newConcurrentMessageCache(externalContext);
            Map applicationMap = externalContext.getApplicationMap();
            applicationMap.put(this.getClass().getName(), messageCache);
        } else {
            logger.error("Unable to store the resource bundle cache in the application map");
        }
    }

    public abstract String getBundleKey();

    @Override
    public FacesMessage getFacesMessage(FacesContext facesContext, Locale locale, FacesMessage.Severity severity, String messageId) {
        return I18nUtil.getFacesMessage(this, facesContext, locale, severity, messageId);
    }

    @Override
    public FacesMessage getFacesMessage(FacesContext facesContext, Locale locale, FacesMessage.Severity severity, String messageId, Object ... arguments) {
        return I18nUtil.getFacesMessage(this, facesContext, locale, severity, messageId, arguments);
    }

    @Override
    public String getMessage(FacesContext facesContext, Locale locale, String messageId) {
        String message;
        block11: {
            Class<?> clazz;
            ExternalContext externalContext;
            Map applicationMap;
            Cache messageCache;
            message = null;
            String key = messageId;
            if (locale != null) {
                key = locale.toString() + messageId;
            }
            if ((messageCache = (Cache)(applicationMap = (externalContext = facesContext.getExternalContext()).getApplicationMap()).get((clazz = this.getClass()).getName())) != null && messageCache.containsKey(key)) {
                message = (String)messageCache.getValue(key);
                if ("".equals(message)) {
                    message = null;
                }
            } else {
                ResourceBundle resourceBundle = null;
                try {
                    String bundleKey = this.getBundleKey();
                    resourceBundle = locale == null ? ResourceBundleUtil.getUTF8ResourceBundleInOSGiEnvironment(bundleKey, Locale.getDefault(), clazz) : ResourceBundleUtil.getUTF8ResourceBundleInOSGiEnvironment(bundleKey, locale, clazz);
                }
                catch (MissingResourceException e) {
                    logger.error(e);
                }
                if (resourceBundle != null) {
                    try {
                        message = resourceBundle.getString(messageId);
                        if (messageCache != null) {
                            message = messageCache.putValueIfAbsent(key, message);
                        }
                    }
                    catch (MissingResourceException e) {
                        if (messageCache == null) break block11;
                        messageCache.putValueIfAbsent(key, "");
                    }
                }
            }
        }
        if (message == null) {
            message = super.getMessage(facesContext, locale, messageId);
        }
        return message;
    }

    @Override
    public String getMessage(FacesContext facesContext, Locale locale, String messageId, Object ... arguments) {
        String message = this.getMessage(facesContext, locale, messageId);
        if (message != null) {
            message = MessageFormat.format(message, arguments);
        }
        return message;
    }

    @Override
    public I18n getWrapped() {
        return this.wrappedI18n;
    }

    protected Cache<String, String> newConcurrentMessageCache(ExternalContext externalContext) {
        return CacheFactory.getConcurrentCacheInstance(externalContext, 16);
    }
}

