/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.config.internal;

import com.liferay.faces.util.config.internal.FacesConfigDescriptor;
import com.liferay.faces.util.config.internal.Ordering;
import java.io.Serializable;
import java.util.List;

public class FacesConfigDescriptorImpl
implements FacesConfigDescriptor,
Serializable {
    private static final long serialVersionUID = 5479857091609259746L;
    private String name;
    private boolean isWebInfFacesConfig;
    private List<String> absoluteOrdering;
    private Ordering ordering;
    private String url;

    public FacesConfigDescriptorImpl(FacesConfigDescriptor facesConfigDescriptor) {
        this.name = facesConfigDescriptor.getName();
        this.isWebInfFacesConfig = facesConfigDescriptor.isWebInfFacesConfig();
        this.absoluteOrdering = facesConfigDescriptor.getAbsoluteOrdering();
        this.ordering = facesConfigDescriptor.getOrdering();
        this.url = facesConfigDescriptor.getURL();
    }

    public FacesConfigDescriptorImpl(String name, String url, boolean isWebInfFacesConfig, List<String> absoluteOrdering, Ordering ordering) {
        this.name = name;
        this.isWebInfFacesConfig = isWebInfFacesConfig;
        this.absoluteOrdering = absoluteOrdering;
        this.ordering = ordering;
        this.url = url;
    }

    @Override
    public List<String> getAbsoluteOrdering() {
        return this.absoluteOrdering;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = "";
        }
        return this.name;
    }

    @Override
    public Ordering getOrdering() {
        return this.ordering;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public boolean hasAbsoluteOrdering() {
        return this.isWebInfFacesConfig && this.absoluteOrdering != null;
    }

    @Override
    public boolean isWebInfFacesConfig() {
        return this.isWebInfFacesConfig;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOrdering(Ordering ordering) {
        this.ordering = ordering;
    }
}

