/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.client.internal;

import com.liferay.faces.util.client.internal.LiferayPortalBrowserSniffer;
import com.liferay.faces.util.client.internal.LiferayPortalBrowserSnifferCompat;
import javax.servlet.http.HttpServletRequest;

public class LiferayPortalBrowserSnifferImpl
extends LiferayPortalBrowserSnifferCompat
implements LiferayPortalBrowserSniffer {
    protected static final String[] revisionLeadings = new String[]{"rv", "it", "ra", "ie"};
    protected static final char[] revisionSeparators = new char[]{'\\', ':', '/', ' '};
    protected static final String[] versionLeadings = new String[]{"version", "firefox", "minefield", "chrome"};
    protected static final char[] versionSeparators = new char[]{'\\', '/'};
    private static final String[] _FIREFOX_ALIASES = new String[]{"firefox", "minefield", "granparadiso", "bonecho", "firebird", "phoenix", "camino"};
    private static final String[] _WEBKIT_ALIASES = new String[]{"khtml", "applewebkit"};
    private static final String[] _WINDOWS_ALIASES = new String[]{"windows", "win32", "16bit"};

    @Override
    public boolean acceptsGzip(HttpServletRequest request) {
        String acceptEncoding = request.getHeader("Accept-Encoding");
        return acceptEncoding != null && acceptEncoding.contains("gzip");
    }

    @Override
    public String getBrowserId(HttpServletRequest request) {
        if (this.isIe(request)) {
            return "ie";
        }
        if (this.isFirefox(request)) {
            return "firefox";
        }
        return "other";
    }

    @Override
    public float getMajorVersion(HttpServletRequest request) {
        return LiferayPortalBrowserSnifferCompat.GetterUtil.getFloat(this.getVersion(request));
    }

    @Override
    public String getRevision(HttpServletRequest request) {
        String revision = (String)request.getAttribute("BROWSER_SNIFFER_REVISION");
        if (revision != null) {
            return revision;
        }
        revision = LiferayPortalBrowserSnifferImpl.parseVersion(this.getUserAgent(request), revisionLeadings, revisionSeparators);
        request.setAttribute("BROWSER_SNIFFER_REVISION", (Object)revision);
        return revision;
    }

    @Override
    public String getVersion(HttpServletRequest request) {
        String version = (String)request.getAttribute("BROWSER_SNIFFER_VERSION");
        if (version != null) {
            return version;
        }
        String userAgent = this.getUserAgent(request);
        version = LiferayPortalBrowserSnifferImpl.parseVersion(userAgent, versionLeadings, versionSeparators);
        if (version.isEmpty()) {
            version = LiferayPortalBrowserSnifferImpl.parseVersion(userAgent, revisionLeadings, revisionSeparators);
        }
        request.setAttribute("BROWSER_SNIFFER_VERSION", (Object)version);
        return version;
    }

    @Override
    public boolean isAir(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("adobeair");
    }

    @Override
    public boolean isAndroid(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("android");
    }

    @Override
    public boolean isChrome(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("chrome");
    }

    @Override
    public boolean isFirefox(HttpServletRequest request) {
        if (!this.isMozilla(request)) {
            return false;
        }
        String userAgent = this.getUserAgent(request);
        for (String firefoxAlias : _FIREFOX_ALIASES) {
            if (!userAgent.contains(firefoxAlias)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isGecko(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("gecko");
    }

    @Override
    public boolean isIe(HttpServletRequest request) {
        return this.isIe(this.getUserAgent(request));
    }

    @Override
    public boolean isIeOnWin32(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return this.isIe(userAgent) && !userAgent.contains("wow64") && !userAgent.contains("win64");
    }

    @Override
    public boolean isIeOnWin64(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return this.isIe(userAgent) && (userAgent.contains("wow64") || userAgent.contains("win64"));
    }

    @Override
    public boolean isIphone(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("iphone");
    }

    @Override
    public boolean isLinux(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("linux");
    }

    @Override
    public boolean isMac(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("mac");
    }

    @Override
    public boolean isMobile(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("mobile") || this.isAndroid(request) && userAgent.contains("nexus");
    }

    @Override
    public boolean isMozilla(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("mozilla") && !userAgent.contains("compatible") && !userAgent.contains("webkit");
    }

    @Override
    public boolean isOpera(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("opera");
    }

    @Override
    public boolean isRtf(HttpServletRequest request) {
        if (this.isAndroid(request)) {
            return true;
        }
        if (this.isChrome(request)) {
            return true;
        }
        float majorVersion = this.getMajorVersion(request);
        if (this.isIe(request) && (double)majorVersion >= 5.5) {
            return true;
        }
        if (this.isMozilla(request) && (double)majorVersion >= 1.3) {
            return true;
        }
        if (this.isOpera(request)) {
            if (this.isMobile(request) && (double)majorVersion >= 10.0) {
                return true;
            }
            if (!this.isMobile(request)) {
                return true;
            }
        }
        if (this.isSafari(request)) {
            if (this.isMobile(request) && (double)majorVersion >= 5.0) {
                return true;
            }
            if (!this.isMobile(request) && (double)majorVersion >= 3.0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSafari(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return this.isWebKit(request) && userAgent.contains("safari");
    }

    @Override
    public boolean isSun(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("sunos");
    }

    @Override
    public boolean isWebKit(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        for (String webKitAlias : _WEBKIT_ALIASES) {
            if (!userAgent.contains(webKitAlias)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isWindows(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        for (String windowsAlias : _WINDOWS_ALIASES) {
            if (!userAgent.contains(windowsAlias)) continue;
            return true;
        }
        return false;
    }

    protected static String parseVersion(String userAgent, String[] leadings, char[] separators) {
        for (String leading : leadings) {
            int index = 0;
            while ((index = userAgent.indexOf(leading, index)) >= 0 && (index += leading.length()) + 2 <= userAgent.length()) {
                char c2;
                char c1 = userAgent.charAt(index);
                if (((c2 = userAgent.charAt(++index)) < '0' || c2 > '9') && c2 != '.') continue;
                for (char separator : separators) {
                    if (c1 != separator) {
                        continue;
                    }
                    int majorStart = index;
                    int majorEnd = index + 1;
                    for (int i = majorStart; i < userAgent.length(); ++i) {
                        char c = userAgent.charAt(i);
                        if (c >= '0' && c <= '9') continue;
                        majorEnd = i;
                        break;
                    }
                    String major = userAgent.substring(majorStart, majorEnd);
                    if (userAgent.charAt(majorEnd) != '.') {
                        return major;
                    }
                    int minorStart = majorEnd + 1;
                    int minorEnd = userAgent.length();
                    for (int i = minorStart; i < userAgent.length(); ++i) {
                        char c = userAgent.charAt(i);
                        if (c >= '0' && c <= '9') continue;
                        minorEnd = i;
                        break;
                    }
                    String minor = userAgent.substring(minorStart, minorEnd);
                    return major.concat(".").concat(minor);
                }
            }
        }
        return "";
    }

    protected String getAccept(HttpServletRequest request) {
        String accept = "";
        if (request == null) {
            return accept;
        }
        accept = String.valueOf(request.getAttribute("ACCEPT"));
        if (LiferayPortalBrowserSnifferCompat.Validator.isNotNull(accept)) {
            return accept;
        }
        accept = request.getHeader("ACCEPT");
        accept = accept != null ? LiferayPortalBrowserSnifferCompat.StringUtil.toLowerCase(accept) : "";
        request.setAttribute("ACCEPT", (Object)accept);
        return accept;
    }

    protected String getUserAgent(HttpServletRequest request) {
        String userAgent = "";
        if (request == null) {
            return userAgent;
        }
        userAgent = String.valueOf(request.getAttribute("User-Agent"));
        if (LiferayPortalBrowserSnifferCompat.Validator.isNotNull(userAgent)) {
            return userAgent;
        }
        userAgent = request.getHeader("User-Agent");
        userAgent = userAgent != null ? LiferayPortalBrowserSnifferCompat.StringUtil.toLowerCase(userAgent) : "";
        request.setAttribute("User-Agent", (Object)userAgent);
        return userAgent;
    }

    protected boolean isIe(String userAgent) {
        return userAgent.contains("msie") && !userAgent.contains("opera");
    }
}

