/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.resource.internal;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ResourceProviderUtil {
    private static final Logger logger = LoggerFactory.getLogger(ResourceProviderUtil.class);
    public static final String ALL_FACES_CONFIG_PATTERN = "*faces-config.xml";
    public static final String FACES_CONFIG_EXTENSION_PATTERN = "*.faces-config.xml";
    public static final String META_INF_PATH = "/META-INF/";
    public static final String WEB_FRAGMENT = "web-fragment.xml";
    public static final String META_INF_WEB_FRAGMENT = "/META-INF/web-fragment.xml";

    private ResourceProviderUtil() {
        throw new AssertionError();
    }

    public static void addAllEnumerationURLsToList(Enumeration<URL> urlsToAdd, List<URL> urls) {
        if (urlsToAdd != null) {
            ArrayList<URL> facesBundleResourceURLs = Collections.list(urlsToAdd);
            urls.addAll(facesBundleResourceURLs);
        }
    }

    public static Set<URI> getResourcesAsURIs(List<URL> resourceURLs) {
        HashSet<URI> resourceURIs = new HashSet<URI>();
        for (URL resourceURL : resourceURLs) {
            try {
                resourceURIs.add(resourceURL.toURI());
            }
            catch (URISyntaxException e) {
                logger.error(e);
            }
        }
        return Collections.unmodifiableSet(resourceURIs);
    }
}

