/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.product.internal;

import com.liferay.faces.util.helper.IntegerHelper;
import com.liferay.faces.util.internal.TCCLUtil;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.internal.PackageManifest;
import com.liferay.faces.util.product.internal.PomProperties;

public class ProductInfo {
    private static final Logger logger = LoggerFactory.getLogger(ProductInfo.class);
    public static final String REGEX_VERSION_DELIMITER = "[.[-]_]";
    public final int buildId;
    public final boolean detected;
    public final int majorVersion;
    public final int minorVersion;
    public final int patchVersion;
    public final String stringValue;
    public final String title;
    public final String version;

    public ProductInfo(String title) {
        this(title, null, (Integer)null);
    }

    public ProductInfo(boolean detected, String title) {
        this(detected, title, (String)null);
    }

    public ProductInfo(String title, String version) {
        this(title, version, (Integer)null);
    }

    public ProductInfo(boolean detected, String title, String version) {
        this(detected, title, version, null);
    }

    public ProductInfo(String title, String version, Integer buildId) {
        this(title, version, null, null, null, buildId);
    }

    public ProductInfo(boolean detected, String title, String version, Integer buildId) {
        this(detected, title, version, null, null, null, buildId);
    }

    public ProductInfo(String title, String version, Integer majorVersion, Integer minorVersion, Integer patchVersion, Integer buildId) {
        this(true, title, version, null, majorVersion, minorVersion, patchVersion, buildId);
    }

    public ProductInfo(boolean detected, String title, String version, Integer majorVersion, Integer minorVersion, Integer patchVersion, Integer buildId) {
        this(detected, title, version, null, majorVersion, minorVersion, patchVersion, buildId);
    }

    public ProductInfo(boolean detected, String title, String version, String stringValue, Integer majorVersion, Integer minorVersion, Integer patchVersion, Integer buildId) {
        this.detected = detected;
        this.title = title;
        String string = this.version = version != null ? version : "0.0.0";
        if (majorVersion == null || minorVersion == null || patchVersion == null) {
            String[] versionParts = this.version.split(REGEX_VERSION_DELIMITER);
            if (majorVersion == null) {
                majorVersion = ProductInfo.getSubVersion(versionParts, 0);
            }
            if (minorVersion == null) {
                minorVersion = ProductInfo.getSubVersion(versionParts, 1);
            }
            if (patchVersion == null) {
                patchVersion = ProductInfo.getSubVersion(versionParts, 2);
            }
        }
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.patchVersion = patchVersion;
        this.buildId = buildId != null ? buildId : majorVersion * 100 + minorVersion * 10 + patchVersion;
        this.stringValue = stringValue != null ? stringValue : title + " " + this.version;
    }

    public static int getMajorVersion(String version) {
        String[] versionParts = version.split(REGEX_VERSION_DELIMITER);
        return ProductInfo.getSubVersion(versionParts, 0);
    }

    public static ProductInfo newInstance(String expectedTitle, String className) {
        return ProductInfo.newInstance(expectedTitle, className, null);
    }

    public static ProductInfo newInstance(String expectedTitle, Class<?> clazz) {
        return ProductInfo.newInstance(true, expectedTitle, clazz, null, null, true);
    }

    public static ProductInfo newInstance(String expectedTitle, String className, String pomPropertiesFile) {
        return ProductInfo.newInstance(expectedTitle, className, pomPropertiesFile, null, true);
    }

    public static ProductInfo newInstance(String expectedTitle, String className, boolean warnOnFail) {
        return ProductInfo.newInstance(expectedTitle, className, null, null, warnOnFail);
    }

    private static int getSubVersion(String[] versionParts, int index) {
        int subVersion = 0;
        if (versionParts.length > index) {
            subVersion = IntegerHelper.toInteger(versionParts[index]);
        }
        return subVersion;
    }

    private static ProductInfo newInstance(String expectedTitle, String className, String pomPropertiesFile, Integer buildId, boolean warnOnFail) {
        ProductInfo productInfo = null;
        boolean detected = false;
        String title = expectedTitle;
        try {
            Class<?> clazz = TCCLUtil.loadClassFromContext(ProductInfo.class, className);
            detected = true;
            productInfo = ProductInfo.newInstance(detected, title, clazz, pomPropertiesFile, buildId, warnOnFail);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (productInfo == null) {
            productInfo = new ProductInfo(detected, title);
        }
        return productInfo;
    }

    private static ProductInfo newInstance(boolean detected, String expectedTitle, Class<?> clazz, String pomPropertiesFile, Integer buildId, boolean warnOnFail) {
        String title = expectedTitle;
        String version = null;
        Package pkg = clazz.getPackage();
        if (pkg != null && pkg.getImplementationVersion() != null) {
            String implementationTitle = pkg.getImplementationTitle();
            if (implementationTitle != null) {
                title = implementationTitle;
            }
            version = pkg.getImplementationVersion();
        }
        if (version == null) {
            PackageManifest packageManifest = new PackageManifest(clazz, expectedTitle);
            version = packageManifest.getImplementationVersion();
        }
        if (version == null && pomPropertiesFile != null) {
            PomProperties pomProperties = new PomProperties(clazz, pomPropertiesFile);
            version = pomProperties.getVersion();
        }
        if (version == null && warnOnFail) {
            logger.warn("Unable to obtain version information for {0}.", title);
        }
        return new ProductInfo(detected, title, version, buildId);
    }
}

