/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.osgi.mojarra.spi.internal;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.osgi.internal.FacesBundlesHandlerBase;
import com.sun.faces.config.FacesInitializer;
import com.sun.faces.spi.AnnotationProvider;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.faces.bean.ManagedBean;
import javax.faces.component.FacesComponent;
import javax.faces.component.behavior.FacesBehavior;
import javax.faces.convert.FacesConverter;
import javax.faces.event.NamedEvent;
import javax.faces.render.FacesBehaviorRenderer;
import javax.faces.render.FacesRenderer;
import javax.faces.validator.FacesValidator;
import javax.servlet.annotation.HandlesTypes;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class AnnotationProviderOSGiImpl
extends AnnotationProvider {
    private static final Logger logger = LoggerFactory.getLogger(AnnotationProviderOSGiImpl.class);
    private static final Set<Class<?>> ANNOTATIONS_HANDLED_BY_MOJARRA;
    private static final String WEB_INF_CLASSES_PATH = "WEB-INF/classes/";

    public Map<Class<? extends Annotation>, Set<Class<?>>> getAnnotatedClasses(Set<URI> set) {
        Map annotatedClasses;
        if (FacesBundlesHandlerBase.isCurrentWarThinWab()) {
            FacesBundlesHandlerAnnotationProviderOSGiImpl facesBundlesHandler = new FacesBundlesHandlerAnnotationProviderOSGiImpl();
            annotatedClasses = Collections.unmodifiableMap((Map)facesBundlesHandler.handleFacesBundles(this.sc));
        } else {
            annotatedClasses = this.wrappedAnnotationProvider.getAnnotatedClasses(set);
        }
        return annotatedClasses;
    }

    static {
        HashSet<Class> annotationsHandledByMojarra = new HashSet<Class>();
        try {
            Class<?> annotationScanningServletContainerInitializerClass = Class.forName(FacesInitializer.class.getName());
            HandlesTypes handledTypes = annotationScanningServletContainerInitializerClass.getAnnotation(HandlesTypes.class);
            Class[] annotationsHandledByMojarraArray = handledTypes.value();
            annotationsHandledByMojarra.addAll(Arrays.asList(annotationsHandledByMojarraArray));
            annotationsHandledByMojarra.addAll(Arrays.asList(FacesComponent.class, FacesConverter.class, FacesRenderer.class, FacesValidator.class, ManagedBean.class, NamedEvent.class, FacesBehavior.class, FacesBehaviorRenderer.class));
        }
        catch (ClassNotFoundException e) {
            logger.error(e);
        }
        catch (NoClassDefFoundError e) {
            logger.error(e);
        }
        ANNOTATIONS_HANDLED_BY_MOJARRA = !annotationsHandledByMojarra.isEmpty() ? Collections.unmodifiableSet(annotationsHandledByMojarra) : Collections.emptySet();
    }

    private static final class FacesBundlesHandlerAnnotationProviderOSGiImpl
    extends FacesBundlesHandlerBase<Map<Class<? extends Annotation>, Set<Class<?>>>> {
        private FacesBundlesHandlerAnnotationProviderOSGiImpl() {
        }

        private static boolean isClassInBundle(String classFilePath, Bundle bundle, boolean wab) {
            return bundle.getEntry(classFilePath) != null || wab && !classFilePath.startsWith(AnnotationProviderOSGiImpl.WEB_INF_CLASSES_PATH) && bundle.getEntry(AnnotationProviderOSGiImpl.WEB_INF_CLASSES_PATH + classFilePath) != null;
        }

        private static Class<?> loadBundleClass(Bundle bundle, String className) {
            Class clazz = null;
            try {
                clazz = bundle.loadClass(className);
            }
            catch (LinkageError linkageError) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            return clazz;
        }

        @Override
        protected Map<Class<? extends Annotation>, Set<Class<?>>> getInitialReturnValueObject() {
            HashMap annotatedClasses = new HashMap();
            for (Class annotation : ANNOTATIONS_HANDLED_BY_MOJARRA) {
                annotatedClasses.put(annotation, new HashSet());
            }
            return annotatedClasses;
        }

        @Override
        protected void handleFacesBundle(Bundle bundle, FacesBundlesHandlerBase.ReturnValueReference<Map<Class<? extends Annotation>, Set<Class<?>>>> returnValueReference) {
            BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            if (bundleWiring != null) {
                Collection classFilePaths = bundleWiring.listResources("/", "*.class", 1);
                boolean wab = FacesBundlesHandlerAnnotationProviderOSGiImpl.isWab(bundle);
                for (String classFilePath : classFilePaths) {
                    Annotation[] classAnnotations;
                    String className;
                    Class<?> clazz;
                    if (!FacesBundlesHandlerAnnotationProviderOSGiImpl.isClassInBundle(classFilePath, bundle, wab) || (clazz = FacesBundlesHandlerAnnotationProviderOSGiImpl.loadBundleClass(bundle, className = classFilePath.replaceAll("\\.class$", "").replace("/", "."))) == null) continue;
                    for (Annotation annotation : classAnnotations = clazz.getAnnotations()) {
                        Class<? extends Annotation> annotationType = annotation.annotationType();
                        if (!ANNOTATIONS_HANDLED_BY_MOJARRA.contains(annotationType)) continue;
                        returnValueReference.get().get(annotationType).add(clazz);
                    }
                }
            }
        }
    }
}

