/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.osgi.internal;

import com.liferay.faces.util.config.WebConfig;
import com.liferay.faces.util.config.WebConfigParam;
import com.liferay.faces.util.config.internal.ResourceReaderImpl;
import com.liferay.faces.util.config.internal.WebConfigScannerImpl;
import com.liferay.faces.util.helper.BooleanHelper;
import com.liferay.faces.util.internal.TCCLUtil;
import com.liferay.faces.util.osgi.internal.FacesBundlesHandlerBase;
import com.liferay.faces.util.xml.ConcurrentSAXParserFactory;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.osgi.framework.Bundle;

public final class FacesThinWabInitializer
implements ServletContainerInitializer {
    private static boolean getBooleanValue(ServletContext servletContext, String name, String alternateName, boolean defaultBooleanValue) {
        boolean booleanValue = defaultBooleanValue;
        String configuredValue = FacesThinWabInitializer.getConfiguredValue(servletContext, name, alternateName);
        if (configuredValue != null) {
            booleanValue = BooleanHelper.isTrueToken(configuredValue);
        }
        return booleanValue;
    }

    private static String getConfiguredValue(ServletContext servletContext, String name, String alternateName) {
        String configuredValue = servletContext.getInitParameter(name);
        if (configuredValue == null && alternateName != null) {
            configuredValue = servletContext.getInitParameter(alternateName);
        }
        return configuredValue;
    }

    public void onStartup(Set<Class<?>> classes, ServletContext servletContext) throws ServletException {
        ClassLoader classLoader = TCCLUtil.getThreadContextClassLoaderOrDefault(this.getClass());
        ResourceReaderImpl resourceReader = new ResourceReaderImpl(servletContext);
        SAXParserFactory saxParserFactory = ConcurrentSAXParserFactory.newInstance();
        saxParserFactory.setValidating(false);
        saxParserFactory.setNamespaceAware(true);
        try {
            SAXParser saxParser = saxParserFactory.newSAXParser();
            String resolveXMLEntitiesName = WebConfigParam.ResolveXMLEntities.getName();
            String resolveXMLEntitiesAlternateName = WebConfigParam.ResolveXMLEntities.getAlternateName();
            boolean resolveEntities = FacesThinWabInitializer.getBooleanValue(servletContext, resolveXMLEntitiesName, resolveXMLEntitiesAlternateName, false);
            WebConfigScannerImpl webConfigScanner = new WebConfigScannerImpl(classLoader, resourceReader, saxParser, resolveEntities);
            FacesBundlesHandlerGetWebFragmentImpl facesBundlesHandlerGetWebFragmentImpl = new FacesBundlesHandlerGetWebFragmentImpl();
            List webFragmentURLs = (List)facesBundlesHandlerGetWebFragmentImpl.handleFacesBundles(servletContext);
            WebConfig webFragmentConfig = webConfigScanner.scanWebFragments(Collections.enumeration(webFragmentURLs));
            Map<String, String> webFragmentContextParams = webFragmentConfig.getConfiguredContextParams();
            Set<Map.Entry<String, String>> entrySet = webFragmentContextParams.entrySet();
            if (!webFragmentContextParams.isEmpty()) {
                ArrayList initParameterNames = Collections.list(servletContext.getInitParameterNames());
                for (Map.Entry<String, String> webFragmentContextParam : entrySet) {
                    String name = webFragmentContextParam.getKey();
                    if (initParameterNames.contains(name)) continue;
                    String value = webFragmentContextParam.getValue();
                    servletContext.setInitParameter(name, value);
                }
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private static final class FacesBundlesHandlerGetWebFragmentImpl
    extends FacesBundlesHandlerBase<List<URL>> {
        private FacesBundlesHandlerGetWebFragmentImpl() {
        }

        @Override
        protected List<URL> getInitialReturnValueObject() {
            return new ArrayList<URL>();
        }

        @Override
        protected void handleCurrentFacesWab(Bundle currentFacesWab, FacesBundlesHandlerBase.ReturnValueReference<List<URL>> returnValueReference) {
            super.handleCurrentFacesWab(currentFacesWab, returnValueReference);
            URL webConfigURL = currentFacesWab.getEntry("WEB-INF/web.xml");
            if (webConfigURL != null) {
                returnValueReference.get().add(webConfigURL);
            }
        }

        @Override
        protected void handleFacesBundle(Bundle bundle, FacesBundlesHandlerBase.ReturnValueReference<List<URL>> returnValueReference) {
            this.collect(bundle, "META-INF", "*.web-fragment.xml", returnValueReference);
            this.collect(bundle, "META-INF", "web-fragment.xml", returnValueReference);
        }

        private void collect(Bundle bundle, String directory, String pattern, FacesBundlesHandlerBase.ReturnValueReference<List<URL>> returnValueReference) {
            Enumeration webFragmentURLs = bundle.findEntries(directory, pattern, false);
            while (webFragmentURLs != null && webFragmentURLs.hasMoreElements()) {
                returnValueReference.get().add((URL)webFragmentURLs.nextElement());
            }
        }
    }
}

