/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.osgi.internal;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.osgi.internal.FacesBundlesHandlerBase;
import com.liferay.faces.util.resource.internal.ResourceProviderUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class FacesBundlesHandlerResourceProviderOSGiImpl
extends FacesBundlesHandlerBase<List<URL>> {
    private static final Logger logger = LoggerFactory.getLogger(ResourceProviderUtil.class);
    private final String currentFacesWabFilePattern;
    private final String path;
    private final String facesBunleFilePattern;

    public FacesBundlesHandlerResourceProviderOSGiImpl(String path, String facesBundleFilePattern) {
        this.path = path;
        this.currentFacesWabFilePattern = facesBundleFilePattern;
        this.facesBunleFilePattern = facesBundleFilePattern;
    }

    public FacesBundlesHandlerResourceProviderOSGiImpl(String path, String currentFacesWabFilePattern, String facesBundleFilePattern) {
        this.path = path;
        this.currentFacesWabFilePattern = currentFacesWabFilePattern;
        this.facesBunleFilePattern = facesBundleFilePattern;
    }

    @Override
    protected List<URL> getInitialReturnValueObject() {
        return new ArrayList<URL>();
    }

    @Override
    protected void handleCurrentFacesWab(Bundle currentFacesWab, FacesBundlesHandlerBase.ReturnValueReference<List<URL>> returnValueReference) {
        BundleWiring bundleWiring = (BundleWiring)currentFacesWab.adapt(BundleWiring.class);
        if (bundleWiring != null) {
            Collection resourceFilePaths = bundleWiring.listResources(this.path, this.currentFacesWabFilePattern, 1);
            for (String resourceFilePath : resourceFilePaths) {
                Enumeration resources = null;
                try {
                    resources = currentFacesWab.getResources(resourceFilePath);
                }
                catch (IOException e) {
                    long bundleId = currentFacesWab.getBundleId();
                    String symbolicName = currentFacesWab.getSymbolicName();
                    logger.error("Failed to obtain URLs of resources with path \"{0}\" from bundle with bundle id \"{1}\" and symbolic name \"{2}\" due to the following error:", resourceFilePath, bundleId, symbolicName);
                    logger.error(e);
                }
                List<URL> urls = returnValueReference.get();
                ResourceProviderUtil.addAllEnumerationURLsToList(resources, urls);
            }
        }
    }

    @Override
    protected void handleFacesBundle(Bundle bundle, FacesBundlesHandlerBase.ReturnValueReference<List<URL>> returnValueReference) {
        Enumeration resources = bundle.findEntries(this.path, this.facesBunleFilePattern, true);
        List<URL> urls = returnValueReference.get();
        ResourceProviderUtil.addAllEnumerationURLsToList(resources, urls);
    }
}

