/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.osgi.internal;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.util.Dictionary;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public abstract class FacesBundlesHandlerBase<ReturnValueType> {
    private static final Logger logger;
    private static final boolean OSGI_ENVIRONMENT_DETECTED;

    public static boolean isCurrentWarThinWab() {
        return OSGI_ENVIRONMENT_DETECTED && !FacesBundlesHandlerBase.isWab(FacesBundlesHandlerBase.getCurrentBundle());
    }

    protected static boolean isWab(Bundle bundle) {
        String webContextPathHeader = null;
        if (bundle != null) {
            Dictionary headers = bundle.getHeaders();
            webContextPathHeader = (String)headers.get("Web-ContextPath");
        }
        return webContextPathHeader != null;
    }

    private static Bundle getCurrentBundle() {
        return FrameworkUtil.getBundle(FacesBundlesHandlerBase.class);
    }

    private static Bundle getCurrentFacesWab(Object context) {
        Bundle bundle;
        BundleContext bundleContext = (BundleContext)FacesBundlesHandlerBase.getServletContextAttribute(context, "osgi-bundlecontext");
        try {
            bundle = bundleContext.getBundle();
        }
        catch (IllegalStateException e) {
            bundle = null;
        }
        return bundle;
    }

    private static Object getServletContextAttribute(Object context, String servletContextAttributeName) {
        Object servletContextAttributeValue = null;
        boolean isFacesContext = context instanceof FacesContext;
        if (isFacesContext || context instanceof ExternalContext) {
            ExternalContext externalContext;
            if (isFacesContext) {
                FacesContext facesContext = (FacesContext)context;
                externalContext = facesContext.getExternalContext();
            } else {
                externalContext = (ExternalContext)context;
            }
            Map applicationMap = externalContext.getApplicationMap();
            servletContextAttributeValue = applicationMap.get(servletContextAttributeName);
        } else if (context instanceof ServletContext) {
            ServletContext servletContext = (ServletContext)context;
            servletContextAttributeValue = servletContext.getAttribute(servletContextAttributeName);
        } else {
            String contextClassName = "null";
            if (context != null) {
                contextClassName = context.getClass().getName();
            }
            throw new IllegalArgumentException("context [" + contextClassName + "] is not an instance of " + FacesContext.class.getName() + " or " + ExternalContext.class.getName() + " or " + ServletContext.class.getName());
        }
        return servletContextAttributeValue;
    }

    public final ReturnValueType handleFacesBundles(Object context) {
        ReturnValueType returnValueObject = this.getInitialReturnValueObject();
        ReturnValueReference<ReturnValueType> returnValueReference = new ReturnValueReference<ReturnValueType>(returnValueObject);
        if (OSGI_ENVIRONMENT_DETECTED) {
            Bundle currentFacesWab = FacesBundlesHandlerBase.getCurrentFacesWab(context);
            this.handleCurrentFacesWab(currentFacesWab, returnValueReference);
            Bundle currentBundle = FacesBundlesHandlerBase.getCurrentBundle();
            if (currentFacesWab.getBundleId() != currentBundle.getBundleId()) {
                this.handleFacesBundle(currentBundle, returnValueReference);
            }
        }
        return returnValueReference.get();
    }

    protected abstract ReturnValueType getInitialReturnValueObject();

    protected abstract void handleFacesBundle(Bundle var1, ReturnValueReference<ReturnValueType> var2);

    protected void handleCurrentFacesWab(Bundle currentFacesWab, ReturnValueReference<ReturnValueType> returnValueReference) {
        this.handleFacesBundle(currentFacesWab, returnValueReference);
    }

    static {
        Bundle currentBundle;
        logger = LoggerFactory.getLogger(FacesBundlesHandlerBase.class);
        boolean frameworkUtilDetected = false;
        try {
            Class.forName("org.osgi.framework.FrameworkUtil");
            frameworkUtilDetected = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Throwable t) {
            logger.error("An unexpected error occurred when attempting to detect OSGi:");
            logger.error(t);
        }
        boolean osgiEnvironmentDetected = false;
        if (frameworkUtilDetected && (currentBundle = FrameworkUtil.getBundle(FacesBundlesHandlerBase.class)) != null) {
            osgiEnvironmentDetected = true;
        }
        OSGI_ENVIRONMENT_DETECTED = osgiEnvironmentDetected;
    }

    protected static final class ReturnValueReference<ReturnValueType> {
        private ReturnValueType returnValueObject;

        public ReturnValueReference(ReturnValueType returnValueObject) {
            this.returnValueObject = returnValueObject;
        }

        public ReturnValueType get() {
            return this.returnValueObject;
        }

        public boolean isEmpty() {
            return this.returnValueObject == null;
        }

        public void set(ReturnValueType returnValueObject) {
            this.returnValueObject = returnValueObject;
        }
    }
}

